/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableColumnSelectorFactory;
import org.apache.druid.segment.join.table.IndexedTableDimensionSelector;
import org.apache.druid.segment.join.table.IndexedTableJoinMatcher;

public class IndexedTableJoinable
implements Joinable {
    private final IndexedTable table;

    public IndexedTableJoinable(IndexedTable table) {
        this.table = table;
    }

    @Override
    public List<String> getAvailableColumns() {
        return this.table.rowSignature().getColumnNames();
    }

    @Override
    public int getCardinality(String columnName) {
        if (this.table.rowSignature().contains(columnName)) {
            return IndexedTableDimensionSelector.computeDimensionSelectorCardinality(this.table);
        }
        return 1;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        return IndexedTableColumnSelectorFactory.columnCapabilities(this.table, columnName);
    }

    @Override
    public JoinMatcher makeJoinMatcher(ColumnSelectorFactory leftColumnSelectorFactory, JoinConditionAnalysis condition, boolean remainderNeeded) {
        return new IndexedTableJoinMatcher(this.table, leftColumnSelectorFactory, condition, remainderNeeded);
    }

    @Override
    public Set<String> getCorrelatedColumnValues(String searchColumnName, String searchColumnValue, String retrievalColumnName, long maxCorrelationSetSize, boolean allowNonKeyColumnSearch) {
        int filterColumnPosition = this.table.rowSignature().indexOf(searchColumnName);
        int correlatedColumnPosition = this.table.rowSignature().indexOf(retrievalColumnName);
        if (filterColumnPosition < 0 || correlatedColumnPosition < 0) {
            return ImmutableSet.of();
        }
        HashSet<String> correlatedValues = new HashSet<String>();
        if (this.table.keyColumns().contains(searchColumnName)) {
            IndexedTable.Index index = this.table.columnIndex(filterColumnPosition);
            IndexedTable.Reader reader = this.table.columnReader(correlatedColumnPosition);
            IntList rowIndex = index.find(searchColumnValue);
            for (int i = 0; i < rowIndex.size(); ++i) {
                int rowNum = rowIndex.getInt(i);
                String correlatedDimVal = Objects.toString(reader.read(rowNum), null);
                correlatedValues.add(correlatedDimVal);
                if ((long)correlatedValues.size() <= maxCorrelationSetSize) continue;
                return ImmutableSet.of();
            }
            return correlatedValues;
        }
        if (!allowNonKeyColumnSearch) {
            return ImmutableSet.of();
        }
        IndexedTable.Reader dimNameReader = this.table.columnReader(filterColumnPosition);
        IndexedTable.Reader correlatedColumnReader = this.table.columnReader(correlatedColumnPosition);
        for (int i = 0; i < this.table.numRows(); ++i) {
            String dimVal = Objects.toString(dimNameReader.read(i), null);
            if (!searchColumnValue.equals(dimVal)) continue;
            String correlatedDimVal = Objects.toString(correlatedColumnReader.read(i), null);
            correlatedValues.add(correlatedDimVal);
            if ((long)correlatedValues.size() <= maxCorrelationSetSize) continue;
            return ImmutableSet.of();
        }
        return correlatedValues;
    }
}

