/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinables;

public class JoinDataSource
implements DataSource {
    private final DataSource left;
    private final DataSource right;
    private final String rightPrefix;
    private final JoinConditionAnalysis conditionAnalysis;
    private final JoinType joinType;

    private JoinDataSource(DataSource left, DataSource right, String rightPrefix, JoinConditionAnalysis conditionAnalysis, JoinType joinType) {
        this.left = (DataSource)Preconditions.checkNotNull((Object)left, (Object)"left");
        this.right = (DataSource)Preconditions.checkNotNull((Object)right, (Object)"right");
        this.rightPrefix = Joinables.validatePrefix(rightPrefix);
        this.conditionAnalysis = (JoinConditionAnalysis)Preconditions.checkNotNull((Object)conditionAnalysis, (Object)"conditionAnalysis");
        this.joinType = (JoinType)((Object)Preconditions.checkNotNull((Object)((Object)joinType), (Object)"joinType"));
    }

    @JsonCreator
    public static JoinDataSource create(@JsonProperty(value="left") DataSource left, @JsonProperty(value="right") DataSource right, @JsonProperty(value="rightPrefix") String rightPrefix, @JsonProperty(value="condition") String condition, @JsonProperty(value="joinType") JoinType joinType, @JacksonInject ExprMacroTable macroTable) {
        return new JoinDataSource(left, right, StringUtils.nullToEmptyNonDruidDataString((String)rightPrefix), JoinConditionAnalysis.forExpression((String)Preconditions.checkNotNull((Object)condition, (Object)"condition"), StringUtils.nullToEmptyNonDruidDataString((String)rightPrefix), macroTable), joinType);
    }

    @Override
    public Set<String> getTableNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.left.getTableNames());
        names.addAll(this.right.getTableNames());
        return names;
    }

    @JsonProperty
    public DataSource getLeft() {
        return this.left;
    }

    @JsonProperty
    public DataSource getRight() {
        return this.right;
    }

    @JsonProperty
    public String getRightPrefix() {
        return this.rightPrefix;
    }

    @JsonProperty
    public String getCondition() {
        return this.conditionAnalysis.getOriginalExpression();
    }

    public JoinConditionAnalysis getConditionAnalysis() {
        return this.conditionAnalysis;
    }

    @JsonProperty
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public List<DataSource> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (children.size() != 2) {
            throw new IAE("Expected [2] children, got [%d]", new Object[]{children.size()});
        }
        return new JoinDataSource(children.get(0), children.get(1), this.rightPrefix, this.conditionAnalysis, this.joinType);
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return this.left.isGlobal() && this.right.isGlobal();
    }

    @Override
    public boolean isConcrete() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinDataSource that = (JoinDataSource)o;
        return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right) && Objects.equals(this.rightPrefix, that.rightPrefix) && Objects.equals(this.conditionAnalysis, that.conditionAnalysis) && this.joinType == that.joinType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.left, this.right, this.rightPrefix, this.conditionAnalysis, this.joinType});
    }

    public String toString() {
        return "JoinDataSource{left=" + this.left + ", right=" + this.right + ", rightPrefix='" + this.rightPrefix + '\'' + ", condition=" + this.conditionAnalysis + ", joinType=" + (Object)((Object)this.joinType) + '}';
    }
}

