/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.List;
import java.util.function.Function;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.DelegatingAggregator;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableValueFloatColumnValueSelector;

public class StringColumnFloatAggregatorWrapper
extends DelegatingAggregator {
    private final BaseObjectColumnValueSelector selector;
    private final float nullValue;
    private final SettableValueFloatColumnValueSelector floatSelector = new SettableValueFloatColumnValueSelector();

    public StringColumnFloatAggregatorWrapper(BaseObjectColumnValueSelector selector, Function<BaseFloatColumnValueSelector, Aggregator> delegateBuilder, float nullValue) {
        this.selector = selector;
        this.nullValue = nullValue;
        this.delegate = delegateBuilder.apply(this.floatSelector);
    }

    @Override
    public void aggregate() {
        Object update = this.selector.getObject();
        if (update == null) {
            this.floatSelector.setValue(this.nullValue);
            this.delegate.aggregate();
        } else if (update instanceof List) {
            for (Object o : (List)update) {
                this.floatSelector.setValue(Numbers.tryParseFloat(o, (float)this.nullValue));
                this.delegate.aggregate();
            }
        } else {
            this.floatSelector.setValue(Numbers.tryParseFloat(update, (float)this.nullValue));
            this.delegate.aggregate();
        }
    }
}

