/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.orderby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.Rows;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.groupby.orderby.TopNSequence;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class DefaultLimitSpec
implements LimitSpec {
    private static final byte CACHE_KEY = 1;
    private final List<OrderByColumnSpec> columns;
    private final int limit;

    public static boolean sortingOrderHasNonGroupingFields(DefaultLimitSpec limitSpec, List<DimensionSpec> dimensions) {
        for (OrderByColumnSpec orderSpec : limitSpec.getColumns()) {
            int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, dimensions);
            if (dimIndex >= 0) continue;
            return true;
        }
        return false;
    }

    public static StringComparator getComparatorForDimName(DefaultLimitSpec limitSpec, String dimName) {
        OrderByColumnSpec orderBy = OrderByColumnSpec.getOrderByForDimName(limitSpec.getColumns(), dimName);
        if (orderBy == null) {
            return null;
        }
        return orderBy.getDimensionComparator();
    }

    @JsonCreator
    public DefaultLimitSpec(@JsonProperty(value="columns") List<OrderByColumnSpec> columns, @JsonProperty(value="limit") Integer limit) {
        this.columns = columns == null ? ImmutableList.of() : columns;
        this.limit = limit == null ? Integer.MAX_VALUE : limit;
        Preconditions.checkArgument((this.limit > 0 ? 1 : 0) != 0, (String)"limit[%s] must be >0", (Object[])new Object[]{limit});
    }

    @JsonProperty
    public List<OrderByColumnSpec> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    public boolean isLimited() {
        return this.limit < Integer.MAX_VALUE;
    }

    @Override
    public Function<Sequence<ResultRow>, Sequence<ResultRow>> build(GroupByQuery query) {
        List<DimensionSpec> dimensions = query.getDimensions();
        boolean sortingNeeded = dimensions.size() < this.columns.size();
        HashSet<String> aggAndPostAggNames = new HashSet<String>();
        for (AggregatorFactory agg : query.getAggregatorSpecs()) {
            aggAndPostAggNames.add(agg.getName());
        }
        for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
            aggAndPostAggNames.add(postAgg.getName());
        }
        if (!sortingNeeded) {
            for (int i = 0; i < this.columns.size(); ++i) {
                StringComparator naturalComparator;
                OrderByColumnSpec columnSpec = this.columns.get(i);
                if (aggAndPostAggNames.contains(columnSpec.getDimension())) {
                    sortingNeeded = true;
                    break;
                }
                ValueType columnType = this.getOrderByType(columnSpec, dimensions);
                if (columnType == ValueType.STRING) {
                    naturalComparator = StringComparators.LEXICOGRAPHIC;
                } else if (ValueType.isNumeric(columnType)) {
                    naturalComparator = StringComparators.NUMERIC;
                } else {
                    sortingNeeded = true;
                    break;
                }
                if (columnSpec.getDirection() == OrderByColumnSpec.Direction.ASCENDING && columnSpec.getDimensionComparator().equals(naturalComparator) && columnSpec.getDimension().equals(dimensions.get(i).getOutputName())) continue;
                sortingNeeded = true;
                break;
            }
        }
        if (!sortingNeeded) {
            boolean bl = sortingNeeded = !query.getGranularity().equals(Granularities.ALL) && query.getContextSortByDimsFirst();
        }
        if (!sortingNeeded) {
            return this.isLimited() ? new LimitingFn(this.limit) : Functions.identity();
        }
        Ordering<ResultRow> ordering = this.makeComparator(query.getResultRowSignature(), query.getResultRowHasTimestamp(), query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), query.getContextSortByDimsFirst());
        if (this.isLimited()) {
            return new TopNFunction(ordering, this.limit);
        }
        return new SortingFn(ordering);
    }

    @Override
    public LimitSpec merge(LimitSpec other) {
        return this;
    }

    private ValueType getOrderByType(OrderByColumnSpec columnSpec, List<DimensionSpec> dimensions) {
        for (DimensionSpec dimSpec : dimensions) {
            if (!columnSpec.getDimension().equals(dimSpec.getOutputName())) continue;
            return dimSpec.getOutputType();
        }
        throw new ISE("Unknown column in order clause[%s]", new Object[]{columnSpec});
    }

    @Override
    public LimitSpec filterColumns(Set<String> names) {
        return new DefaultLimitSpec(this.columns.stream().filter(c -> names.contains(c.getDimension())).collect(Collectors.toList()), this.limit);
    }

    /*
     * WARNING - void declaration
     */
    private Ordering<ResultRow> makeComparator(RowSignature rowSignature, boolean hasTimestamp, List<DimensionSpec> dimensions, List<AggregatorFactory> aggs, List<PostAggregator> postAggs, boolean sortByDimsFirst) {
        void var11_20;
        void var11_16;
        Ordering<ResultRow> timeOrdering = hasTimestamp ? new Ordering<ResultRow>(){

            public int compare(ResultRow left, ResultRow right) {
                return Longs.compare((long)left.getLong(0), (long)right.getLong(0));
            }
        } : null;
        HashMap<String, DimensionSpec> dimensionsMap = new HashMap<String, DimensionSpec>();
        for (DimensionSpec dimensionSpec : dimensions) {
            dimensionsMap.put(dimensionSpec.getOutputName(), dimensionSpec);
        }
        HashMap<String, AggregatorFactory> aggregatorsMap = new HashMap<String, AggregatorFactory>();
        for (AggregatorFactory aggregatorFactory : aggs) {
            aggregatorsMap.put(aggregatorFactory.getName(), aggregatorFactory);
        }
        HashMap<String, PostAggregator> hashMap = new HashMap<String, PostAggregator>();
        for (PostAggregator postAgg : postAggs) {
            hashMap.put(postAgg.getName(), postAgg);
        }
        Object var11_15 = null;
        for (OrderByColumnSpec columnSpec : this.columns) {
            String columnName = columnSpec.getDimension();
            Ordering<ResultRow> nextOrdering = null;
            int columnIndex = rowSignature.indexOf(columnName);
            if (columnIndex >= 0) {
                if (hashMap.containsKey(columnName)) {
                    nextOrdering = this.metricOrdering(columnIndex, ((PostAggregator)hashMap.get(columnName)).getComparator());
                } else if (aggregatorsMap.containsKey(columnName)) {
                    nextOrdering = this.metricOrdering(columnIndex, ((AggregatorFactory)aggregatorsMap.get(columnName)).getComparator());
                } else if (dimensionsMap.containsKey(columnName)) {
                    nextOrdering = this.dimensionOrdering(columnIndex, columnSpec.getDimensionComparator());
                }
            }
            if (nextOrdering == null) {
                throw new ISE("Unknown column in order clause[%s]", new Object[]{columnSpec});
            }
            if (columnSpec.getDirection() == OrderByColumnSpec.Direction.DESCENDING) {
                nextOrdering = nextOrdering.reverse();
            }
            Ordering<ResultRow> ordering = var11_16 == null ? nextOrdering : var11_16.compound((Comparator)nextOrdering);
        }
        if (var11_16 == null) {
            Ordering<ResultRow> ordering = timeOrdering;
        } else if (timeOrdering != null) {
            Ordering ordering = sortByDimsFirst ? var11_16.compound((Comparator)timeOrdering) : timeOrdering.compound((Comparator)var11_16);
        }
        return var11_20 != null ? var11_20 : Ordering.allEqual();
    }

    private <T> Ordering<ResultRow> metricOrdering(int column, Comparator<T> comparator) {
        Comparator<T> nullFriendlyComparator = NullHandling.sqlCompatible() ? Comparator.nullsFirst(comparator) : Comparator.nullsLast(comparator);
        return Ordering.from(Comparator.comparing(row -> row.get(column), nullFriendlyComparator));
    }

    private Ordering<ResultRow> dimensionOrdering(int column, StringComparator comparator) {
        return Ordering.from(Comparator.comparing(row -> DefaultLimitSpec.getDimensionValue(row, column), Comparator.nullsFirst(comparator)));
    }

    @Nullable
    private static String getDimensionValue(ResultRow row, int column) {
        List values = Rows.objectToStrings((Object)row.get(column));
        return values.isEmpty() ? null : (String)Iterables.getOnlyElement((Iterable)values);
    }

    public String toString() {
        return "DefaultLimitSpec{columns='" + this.columns + '\'' + ", limit=" + this.limit + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLimitSpec that = (DefaultLimitSpec)o;
        if (this.limit != that.limit) {
            return false;
        }
        return !(this.columns != null ? !this.columns.equals(that.columns) : that.columns != null);
    }

    public int hashCode() {
        int result = this.columns != null ? this.columns.hashCode() : 0;
        result = 31 * result + this.limit;
        return result;
    }

    public byte[] getCacheKey() {
        byte[][] columnBytes = new byte[this.columns.size()][];
        int columnsBytesSize = 0;
        int index = 0;
        for (OrderByColumnSpec column : this.columns) {
            columnBytes[index] = column.getCacheKey();
            columnsBytesSize += columnBytes[index].length;
            ++index;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + columnsBytesSize + 4).put((byte)1);
        for (byte[] columnByte : columnBytes) {
            buffer.put(columnByte);
        }
        buffer.put(Ints.toByteArray((int)this.limit));
        return buffer.array();
    }

    private static class TopNFunction
    implements Function<Sequence<ResultRow>, Sequence<ResultRow>> {
        private final Ordering<ResultRow> ordering;
        private final int limit;

        public TopNFunction(Ordering<ResultRow> ordering, int limit) {
            this.ordering = ordering;
            this.limit = limit;
        }

        public Sequence<ResultRow> apply(Sequence<ResultRow> input) {
            return new TopNSequence<ResultRow>(input, this.ordering, this.limit);
        }
    }

    private static class SortingFn
    implements Function<Sequence<ResultRow>, Sequence<ResultRow>> {
        private final Ordering<ResultRow> ordering;

        public SortingFn(Ordering<ResultRow> ordering) {
            this.ordering = ordering;
        }

        public Sequence<ResultRow> apply(@Nullable Sequence<ResultRow> input) {
            return Sequences.sort(input, this.ordering);
        }
    }

    private static class LimitingFn
    implements Function<Sequence<ResultRow>, Sequence<ResultRow>> {
        private final int limit;

        public LimitingFn(int limit) {
            this.limit = limit;
        }

        public Sequence<ResultRow> apply(Sequence<ResultRow> input) {
            return input.limit((long)this.limit);
        }
    }
}

