/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.IndexedIterable;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;

public class StringDimensionIndexer
implements DimensionIndexer<Integer, int[], String> {
    private static final int ABSENT_VALUE_ID = -1;
    private final DimensionDictionary dimLookup = new DimensionDictionary();
    private final DimensionSchema.MultiValueHandling multiValueHandling;
    private final boolean hasBitmapIndexes;
    private volatile boolean hasMultipleValues = false;
    private volatile boolean isSparse = false;
    @Nullable
    private SortedDimensionDictionary sortedLookup;

    @Nullable
    private static String emptyToNullIfNeeded(@Nullable Object o) {
        return o != null ? NullHandling.emptyToNullIfNeeded((String)o.toString()) : null;
    }

    public StringDimensionIndexer(DimensionSchema.MultiValueHandling multiValueHandling, boolean hasBitmapIndexes) {
        this.multiValueHandling = multiValueHandling == null ? DimensionSchema.MultiValueHandling.ofDefault() : multiValueHandling;
        this.hasBitmapIndexes = hasBitmapIndexes;
    }

    @Override
    public int[] processRowValsToUnsortedEncodedKeyComponent(@Nullable Object dimValues, boolean reportParseExceptions) {
        int[] encodedDimensionValues;
        int oldDictSize = this.dimLookup.size();
        if (dimValues == null) {
            int[] nArray;
            int nullId = this.dimLookup.getId(null);
            if (nullId == -1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.dimLookup.add(null);
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = nullId;
            }
            encodedDimensionValues = nArray;
        } else if (dimValues instanceof List) {
            List dimValuesList = (List)dimValues;
            if (dimValuesList.isEmpty()) {
                this.dimLookup.add(null);
                encodedDimensionValues = IntArrays.EMPTY_ARRAY;
            } else if (dimValuesList.size() == 1) {
                encodedDimensionValues = new int[]{this.dimLookup.add(StringDimensionIndexer.emptyToNullIfNeeded(dimValuesList.get(0)))};
            } else {
                this.hasMultipleValues = true;
                String[] dimensionValues = new String[dimValuesList.size()];
                for (int i = 0; i < dimValuesList.size(); ++i) {
                    dimensionValues[i] = StringDimensionIndexer.emptyToNullIfNeeded(dimValuesList.get(i));
                }
                if (this.multiValueHandling.needSorting()) {
                    Arrays.sort(dimensionValues, Comparators.naturalNullsFirst());
                }
                int[] retVal = new int[dimensionValues.length];
                int prevId = -1;
                int pos = 0;
                for (String dimensionValue : dimensionValues) {
                    if (this.multiValueHandling != DimensionSchema.MultiValueHandling.SORTED_SET) {
                        retVal[pos++] = this.dimLookup.add(dimensionValue);
                        continue;
                    }
                    int index = this.dimLookup.add(dimensionValue);
                    if (index == prevId) continue;
                    int n = pos++;
                    int n2 = index;
                    retVal[n] = n2;
                    prevId = n2;
                }
                encodedDimensionValues = pos == retVal.length ? retVal : Arrays.copyOf(retVal, pos);
            }
        } else {
            encodedDimensionValues = new int[]{this.dimLookup.add(StringDimensionIndexer.emptyToNullIfNeeded(dimValues))};
        }
        if (oldDictSize != this.dimLookup.size()) {
            this.sortedLookup = null;
        }
        return encodedDimensionValues;
    }

    @Override
    public void setSparseIndexed() {
        this.isSparse = true;
    }

    @Override
    public long estimateEncodedKeyComponentSize(int[] key) {
        long estimatedSize = key.length * 4;
        long totalChars = 0L;
        for (int element : key) {
            String val = this.dimLookup.getValue(element);
            if (val == null) continue;
            totalChars += (long)val.length();
        }
        return estimatedSize += totalChars * 2L;
    }

    public Integer getSortedEncodedValueFromUnsorted(Integer unsortedIntermediateValue) {
        return this.sortedLookup().getSortedIdFromUnsortedId(unsortedIntermediateValue);
    }

    @Override
    public Integer getUnsortedEncodedValueFromSorted(Integer sortedIntermediateValue) {
        return this.sortedLookup().getUnsortedIdFromSortedId(sortedIntermediateValue);
    }

    @Override
    public CloseableIndexed<String> getSortedIndexedValues() {
        return new CloseableIndexed<String>(){

            @Override
            public int size() {
                return StringDimensionIndexer.this.getCardinality();
            }

            @Override
            public String get(int index) {
                return StringDimensionIndexer.this.getActualValue(index, true);
            }

            @Override
            public int indexOf(String value) {
                int id = StringDimensionIndexer.this.getEncodedValue(value, false);
                return id < 0 ? -1 : StringDimensionIndexer.this.getSortedEncodedValueFromUnsorted(id);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public String getMinValue() {
        return this.dimLookup.getMinValue();
    }

    @Override
    public String getMaxValue() {
        return this.dimLookup.getMaxValue();
    }

    @Override
    public int getCardinality() {
        return this.dimLookup.size();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(int[] lhs, int[] rhs) {
        int lhsLen = lhs.length;
        int rhsLen = rhs.length;
        int lenCompareResult = Ints.compare((int)lhsLen, (int)rhsLen);
        if (lenCompareResult != 0 && lhsLen + rhsLen == 1) {
            int[] longerVal;
            int[] nArray = longerVal = rhsLen > lhsLen ? rhs : lhs;
            if (longerVal[0] == this.dimLookup.idForNull) {
                return 0;
            }
            return longerVal == lhs ? 1 : -1;
        }
        int lenToCompare = Math.min(lhsLen, rhsLen);
        for (int valsIndex = 0; valsIndex < lenToCompare; ++valsIndex) {
            int lhsVal = lhs[valsIndex];
            int rhsVal = rhs[valsIndex];
            if (lhsVal == rhsVal) continue;
            String lhsValActual = this.getActualValue(lhsVal, false);
            String rhsValActual = this.getActualValue(rhsVal, false);
            int valueCompareResult = 0;
            if (lhsValActual != null && rhsValActual != null) {
                valueCompareResult = lhsValActual.compareTo(rhsValActual);
            } else if (lhsValActual == null ^ rhsValActual == null) {
                int n = valueCompareResult = lhsValActual == null ? -1 : 1;
            }
            if (valueCompareResult == 0) continue;
            return valueCompareResult;
        }
        return lenCompareResult;
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(int[] lhs, int[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(int[] key) {
        return Arrays.hashCode(key);
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, final IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final ExtractionFn extractionFn = spec.getExtractionFn();
        final int dimIndex = desc.getIndex();
        final int maxId = this.getCardinality();
        class IndexerDimensionSelector
        implements DimensionSelector,
        IdLookup {
            private final ArrayBasedIndexedInts indexedInts = new ArrayBasedIndexedInts();
            private int[] nullIdIntArray;

            IndexerDimensionSelector() {
            }

            @Override
            public IndexedInts getRow() {
                Object[] dims = currEntry.get().getDims();
                int[] indices = dimIndex < dims.length ? (int[])dims[dimIndex] : null;
                int[] row = null;
                int rowSize = 0;
                if (indices == null || indices.length == 0) {
                    if (StringDimensionIndexer.this.hasMultipleValues) {
                        row = IntArrays.EMPTY_ARRAY;
                        rowSize = 0;
                    } else {
                        int nullId = StringDimensionIndexer.this.getEncodedValue(null, false);
                        if (nullId > -1) {
                            if (this.nullIdIntArray == null) {
                                this.nullIdIntArray = new int[]{nullId};
                            }
                            row = this.nullIdIntArray;
                            rowSize = 1;
                        } else {
                            row = IntArrays.EMPTY_ARRAY;
                            rowSize = 0;
                        }
                    }
                }
                if (row == null && indices != null && indices.length > 0) {
                    row = indices;
                    rowSize = indices.length;
                }
                this.indexedInts.setValues(row, rowSize);
                return this.indexedInts;
            }

            @Override
            public ValueMatcher makeValueMatcher(final String value) {
                if (extractionFn == null) {
                    final int valueId = this.lookupId(value);
                    if (valueId >= 0 || value == null) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches() {
                                Object[] dims = currEntry.get().getDims();
                                if (dimIndex >= dims.length) {
                                    return value == null;
                                }
                                int[] dimsInt = (int[])dims[dimIndex];
                                if (dimsInt == null || dimsInt.length == 0) {
                                    return value == null;
                                }
                                for (int id : dimsInt) {
                                    if (id != valueId) continue;
                                    return true;
                                }
                                return false;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            }
                        };
                    }
                    return BooleanValueMatcher.of(false);
                }
                return this.makeValueMatcher((Predicate<String>)Predicates.equalTo((Object)value));
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final BitSet checkedIds = new BitSet(maxId);
                final BitSet matchingIds = new BitSet(maxId);
                final boolean matchNull = predicate.apply(null);
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        Object[] dims = currEntry.get().getDims();
                        if (dimIndex >= dims.length) {
                            return matchNull;
                        }
                        int[] dimsInt = (int[])dims[dimIndex];
                        if (dimsInt == null || dimsInt.length == 0) {
                            return matchNull;
                        }
                        for (int id : dimsInt) {
                            if (checkedIds.get(id)) {
                                if (!matchingIds.get(id)) continue;
                                return true;
                            }
                            boolean matches = predicate.apply((Object)this.lookupName(id));
                            checkedIds.set(id);
                            if (!matches) continue;
                            matchingIds.set(id);
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }
                };
            }

            @Override
            public int getValueCardinality() {
                return maxId;
            }

            @Override
            public String lookupName(int id) {
                if (id >= maxId) {
                    throw new ISE("id[%d] >= maxId[%d]", new Object[]{id, maxId});
                }
                String strValue = StringDimensionIndexer.this.getActualValue(id, false);
                return extractionFn == null ? strValue : extractionFn.apply(strValue);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return !StringDimensionIndexer.this.isSparse || StringDimensionIndexer.this.dimLookup.idForNull != -1;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return extractionFn == null ? this : null;
            }

            @Override
            public int lookupId(String name) {
                if (extractionFn != null) {
                    throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                }
                return StringDimensionIndexer.this.getEncodedValue(name, false);
            }

            @Override
            @Nullable
            public Object getObject() {
                IncrementalIndexRow key = currEntry.get();
                if (key == null) {
                    return null;
                }
                Object[] dims = key.getDims();
                if (dimIndex >= dims.length) {
                    return null;
                }
                return StringDimensionIndexer.this.convertUnsortedEncodedKeyComponentToActualList((int[])dims[dimIndex]);
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerDimensionSelector();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return this.makeDimensionSelector(DefaultDimensionSpec.of(desc.getName()), currEntry, desc);
    }

    @Override
    @Nullable
    public Object convertUnsortedEncodedKeyComponentToActualList(int[] key) {
        if (key == null || key.length == 0) {
            return null;
        }
        if (key.length == 1) {
            return this.getActualValue(key[0], false);
        }
        String[] rowArray = new String[key.length];
        for (int i = 0; i < key.length; ++i) {
            String val = this.getActualValue(key[i], false);
            rowArray[i] = NullHandling.nullToEmptyIfNeeded((String)val);
        }
        return Arrays.asList(rowArray);
    }

    @Override
    public ColumnValueSelector convertUnsortedValuesToSorted(ColumnValueSelector selectorWithUnsortedValues) {
        final DimensionSelector dimSelectorWithUnsortedValues = (DimensionSelector)selectorWithUnsortedValues;
        class SortedDimensionSelector
        implements DimensionSelector,
        IndexedInts {
            SortedDimensionSelector() {
            }

            @Override
            public int size() {
                return dimSelectorWithUnsortedValues.getRow().size();
            }

            @Override
            public int get(int index) {
                return StringDimensionIndexer.this.sortedLookup().getSortedIdFromUnsortedId(dimSelectorWithUnsortedValues.getRow().get(index));
            }

            @Override
            public IndexedInts getRow() {
                return this;
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getValueCardinality() {
                return dimSelectorWithUnsortedValues.getValueCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("dimSelectorWithUnsortedValues", dimSelectorWithUnsortedValues);
            }

            @Override
            @Nullable
            public Object getObject() {
                return dimSelectorWithUnsortedValues.getObject();
            }

            @Override
            public Class classOfObject() {
                return dimSelectorWithUnsortedValues.classOfObject();
            }
        }
        return new SortedDimensionSelector();
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(int[] key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        if (!this.hasBitmapIndexes) {
            throw new UnsupportedOperationException("This column does not include bitmap indexes");
        }
        for (int dimValIdx : key) {
            if (bitmapIndexes[dimValIdx] == null) {
                bitmapIndexes[dimValIdx] = factory.makeEmptyMutableBitmap();
            }
            bitmapIndexes[dimValIdx].add(rowNum);
        }
    }

    private SortedDimensionDictionary sortedLookup() {
        return this.sortedLookup == null ? (this.sortedLookup = this.dimLookup.sort()) : this.sortedLookup;
    }

    @Nullable
    private String getActualValue(int intermediateValue, boolean idSorted) {
        if (idSorted) {
            return this.sortedLookup().getValueFromSortedId(intermediateValue);
        }
        return this.dimLookup.getValue(intermediateValue);
    }

    private int getEncodedValue(String fullValue, boolean idSorted) {
        int unsortedId = this.dimLookup.getId(fullValue);
        if (idSorted) {
            return this.sortedLookup().getSortedIdFromUnsortedId(unsortedId);
        }
        return unsortedId;
    }

    private static class SortedDimensionDictionary {
        private final List<String> sortedVals;
        private final int[] idToIndex;
        private final int[] indexToId;

        public SortedDimensionDictionary(List<String> idToValue, int length) {
            Object2IntRBTreeMap sortedMap = new Object2IntRBTreeMap((Comparator)Comparators.naturalNullsFirst());
            for (int id = 0; id < length; ++id) {
                String value = idToValue.get(id);
                sortedMap.put((Object)value, id);
            }
            this.sortedVals = Lists.newArrayList((Iterable)sortedMap.keySet());
            this.idToIndex = new int[length];
            this.indexToId = new int[length];
            int index = 0;
            IntIterator iterator = sortedMap.values().iterator();
            while (iterator.hasNext()) {
                int id = iterator.nextInt();
                this.idToIndex[id] = index;
                this.indexToId[index] = id;
                ++index;
            }
        }

        public int getUnsortedIdFromSortedId(int index) {
            return this.indexToId[index];
        }

        public int getSortedIdFromUnsortedId(int id) {
            return this.idToIndex[id];
        }

        public String getValueFromSortedId(int index) {
            return this.sortedVals.get(index);
        }
    }

    private static class DimensionDictionary {
        @Nullable
        private String minValue = null;
        @Nullable
        private String maxValue = null;
        private int idForNull = -1;
        private final Object2IntMap<String> valueToId = new Object2IntOpenHashMap();
        private final List<String> idToValue = new ArrayList<String>();
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        public DimensionDictionary() {
            this.valueToId.defaultReturnValue(-1);
        }

        public int getId(@Nullable String value) {
            this.lock.readLock().lock();
            try {
                if (value == null) {
                    int n = this.idForNull;
                    return n;
                }
                int n = this.valueToId.getInt((Object)value);
                return n;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Nullable
        public String getValue(int id) {
            this.lock.readLock().lock();
            try {
                if (id == this.idForNull) {
                    String string = null;
                    return string;
                }
                String string = this.idToValue.get(id);
                return string;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public int size() {
            this.lock.readLock().lock();
            try {
                int n = this.idToValue.size();
                return n;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int add(@Nullable String originalValue) {
            this.lock.writeLock().lock();
            try {
                if (originalValue == null) {
                    if (this.idForNull == -1) {
                        this.idForNull = this.idToValue.size();
                        this.idToValue.add(null);
                    }
                    int n = this.idForNull;
                    return n;
                }
                int prev = this.valueToId.getInt((Object)originalValue);
                if (prev >= 0) {
                    int n = prev;
                    return n;
                }
                int index = this.idToValue.size();
                this.valueToId.put((Object)originalValue, index);
                this.idToValue.add(originalValue);
                this.minValue = this.minValue == null || this.minValue.compareTo(originalValue) > 0 ? originalValue : this.minValue;
                this.maxValue = this.maxValue == null || this.maxValue.compareTo(originalValue) < 0 ? originalValue : this.maxValue;
                int n = index;
                return n;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public String getMinValue() {
            this.lock.readLock().lock();
            try {
                String string = this.minValue;
                return string;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public String getMaxValue() {
            this.lock.readLock().lock();
            try {
                String string = this.maxValue;
                return string;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public SortedDimensionDictionary sort() {
            this.lock.readLock().lock();
            try {
                SortedDimensionDictionary sortedDimensionDictionary = new SortedDimensionDictionary(this.idToValue, this.idToValue.size());
                return sortedDimensionDictionary;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }
}

