/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;

public class ColumnCapabilitiesImpl
implements ColumnCapabilities {
    @Nullable
    private ValueType type = null;
    private boolean dictionaryEncoded = false;
    private boolean runLengthEncoded = false;
    private boolean hasInvertedIndexes = false;
    private boolean hasSpatialIndexes = false;
    private ColumnCapabilities.Capable hasMultipleValues = ColumnCapabilities.Capable.UNKNOWN;
    @JsonIgnore
    private ColumnCapabilities.Capable dictionaryValuesSorted = ColumnCapabilities.Capable.UNKNOWN;
    @JsonIgnore
    private ColumnCapabilities.Capable dictionaryValuesUnique = ColumnCapabilities.Capable.UNKNOWN;
    @JsonIgnore
    private boolean filterable;

    public static ColumnCapabilitiesImpl copyOf(@Nullable ColumnCapabilities other) {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl();
        if (other != null) {
            capabilities.type = other.getType();
            capabilities.dictionaryEncoded = other.isDictionaryEncoded();
            capabilities.runLengthEncoded = other.isRunLengthEncoded();
            capabilities.hasInvertedIndexes = other.hasBitmapIndexes();
            capabilities.hasSpatialIndexes = other.hasSpatialIndexes();
            capabilities.hasMultipleValues = other.hasMultipleValues();
            capabilities.dictionaryValuesSorted = other.areDictionaryValuesSorted();
            capabilities.dictionaryValuesUnique = other.areDictionaryValuesUnique();
            capabilities.filterable = other.isFilterable();
        }
        return capabilities;
    }

    @Nullable
    public static ColumnCapabilitiesImpl snapshot(@Nullable ColumnCapabilities capabilities) {
        return ColumnCapabilitiesImpl.snapshot(capabilities, false);
    }

    @Nullable
    public static ColumnCapabilitiesImpl snapshot(@Nullable ColumnCapabilities capabilities, boolean unknownIsTrue) {
        if (capabilities == null) {
            return null;
        }
        ColumnCapabilitiesImpl copy = ColumnCapabilitiesImpl.copyOf(capabilities);
        copy.hasMultipleValues = copy.hasMultipleValues.coerceUnknownToBoolean(unknownIsTrue);
        copy.dictionaryValuesSorted = copy.dictionaryValuesSorted.coerceUnknownToBoolean(unknownIsTrue);
        copy.dictionaryValuesUnique = copy.dictionaryValuesUnique.coerceUnknownToBoolean(unknownIsTrue);
        return copy;
    }

    public static ColumnCapabilitiesImpl createSimpleNumericColumnCapabilities(ValueType valueType) {
        return new ColumnCapabilitiesImpl().setType(valueType).setHasMultipleValues(false).setHasBitmapIndexes(false).setDictionaryEncoded(false).setDictionaryValuesSorted(false).setDictionaryValuesUnique(false).setHasSpatialIndexes(false);
    }

    @Override
    @JsonProperty
    public ValueType getType() {
        return this.type;
    }

    public ColumnCapabilitiesImpl setType(ValueType type) {
        this.type = (ValueType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"'type' must be nonnull"));
        return this;
    }

    @Override
    @JsonProperty
    public boolean isDictionaryEncoded() {
        return this.dictionaryEncoded;
    }

    public ColumnCapabilitiesImpl setDictionaryEncoded(boolean dictionaryEncoded) {
        this.dictionaryEncoded = dictionaryEncoded;
        return this;
    }

    @Override
    public ColumnCapabilities.Capable areDictionaryValuesSorted() {
        return this.dictionaryValuesSorted;
    }

    public ColumnCapabilitiesImpl setDictionaryValuesSorted(boolean dictionaryValuesSorted) {
        this.dictionaryValuesSorted = ColumnCapabilities.Capable.of(dictionaryValuesSorted);
        return this;
    }

    @Override
    public ColumnCapabilities.Capable areDictionaryValuesUnique() {
        return this.dictionaryValuesUnique;
    }

    public ColumnCapabilitiesImpl setDictionaryValuesUnique(boolean dictionaryValuesUnique) {
        this.dictionaryValuesUnique = ColumnCapabilities.Capable.of(dictionaryValuesUnique);
        return this;
    }

    @Override
    @JsonProperty
    public boolean isRunLengthEncoded() {
        return this.runLengthEncoded;
    }

    @Override
    @JsonProperty(value="hasBitmapIndexes")
    public boolean hasBitmapIndexes() {
        return this.hasInvertedIndexes;
    }

    public ColumnCapabilitiesImpl setHasBitmapIndexes(boolean hasInvertedIndexes) {
        this.hasInvertedIndexes = hasInvertedIndexes;
        return this;
    }

    @Override
    @JsonProperty(value="hasSpatialIndexes")
    public boolean hasSpatialIndexes() {
        return this.hasSpatialIndexes;
    }

    public ColumnCapabilitiesImpl setHasSpatialIndexes(boolean hasSpatialIndexes) {
        this.hasSpatialIndexes = hasSpatialIndexes;
        return this;
    }

    @Override
    @JsonProperty(value="hasMultipleValues")
    public ColumnCapabilities.Capable hasMultipleValues() {
        return this.hasMultipleValues;
    }

    public ColumnCapabilitiesImpl setHasMultipleValues(boolean hasMultipleValues) {
        this.hasMultipleValues = ColumnCapabilities.Capable.of(hasMultipleValues);
        return this;
    }

    @Override
    public boolean isFilterable() {
        return this.type == ValueType.STRING || this.type == ValueType.LONG || this.type == ValueType.FLOAT || this.type == ValueType.DOUBLE || this.filterable;
    }

    public ColumnCapabilitiesImpl setFilterable(boolean filterable) {
        this.filterable = filterable;
        return this;
    }

    public ColumnCapabilities merge(@Nullable ColumnCapabilities other) {
        if (other == null) {
            return this;
        }
        if (this.type == null) {
            this.type = other.getType();
        }
        if (!this.type.equals((Object)other.getType())) {
            throw new ISE("Cannot merge columns of type[%s] and [%s]", new Object[]{this.type, other.getType()});
        }
        this.dictionaryEncoded |= other.isDictionaryEncoded();
        this.runLengthEncoded |= other.isRunLengthEncoded();
        this.hasInvertedIndexes |= other.hasBitmapIndexes();
        this.hasSpatialIndexes |= other.hasSpatialIndexes();
        this.filterable &= other.isFilterable();
        this.hasMultipleValues = this.hasMultipleValues.or(other.hasMultipleValues());
        this.dictionaryValuesSorted = this.dictionaryValuesSorted.and(other.areDictionaryValuesSorted());
        this.dictionaryValuesUnique = this.dictionaryValuesUnique.and(other.areDictionaryValuesUnique());
        return this;
    }
}

