/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.column.ValueType;

public class RowSignature {
    private static final RowSignature EMPTY = new RowSignature(Collections.emptyList());
    private final Map<String, ValueType> columnTypes = new HashMap<String, ValueType>();
    private final Object2IntMap<String> columnPositions = new Object2IntOpenHashMap();
    private final List<String> columnNames;

    private RowSignature(List<Pair<String, ValueType>> columnTypeList) {
        this.columnPositions.defaultReturnValue(-1);
        ImmutableList.Builder columnNamesBuilder = ImmutableList.builder();
        for (int i = 0; i < columnTypeList.size(); ++i) {
            Pair<String, ValueType> pair = columnTypeList.get(i);
            ValueType existingType = this.columnTypes.get(pair.lhs);
            if (this.columnTypes.containsKey(pair.lhs) && existingType != pair.rhs) {
                throw new IAE("Column[%s] has conflicting types [%s] and [%s]", new Object[]{pair.lhs, existingType, pair.rhs});
            }
            this.columnTypes.put((String)pair.lhs, (ValueType)((Object)pair.rhs));
            this.columnPositions.put(pair.lhs, i);
            columnNamesBuilder.add(pair.lhs);
        }
        this.columnNames = columnNamesBuilder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RowSignature empty() {
        return EMPTY;
    }

    public String getColumnName(int columnNumber) {
        return this.columnNames.get(columnNumber);
    }

    public Optional<ValueType> getColumnType(String columnName) {
        return Optional.ofNullable(this.columnTypes.get(columnName));
    }

    public Optional<ValueType> getColumnType(int columnNumber) {
        return Optional.ofNullable(this.columnTypes.get(this.getColumnName(columnNumber)));
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public int size() {
        return this.columnNames.size();
    }

    public boolean contains(String columnName) {
        return this.columnPositions.containsKey((Object)columnName);
    }

    public int indexOf(String columnName) {
        return this.columnPositions.applyAsInt((Object)columnName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowSignature that = (RowSignature)o;
        return this.columnTypes.equals(that.columnTypes) && this.columnNames.equals(that.columnNames);
    }

    public int hashCode() {
        return Objects.hash(this.columnTypes, this.columnNames);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (i > 0) {
                s.append(", ");
            }
            String columnName = this.columnNames.get(i);
            s.append(columnName).append(":").append((Object)this.columnTypes.get(columnName));
        }
        return s.append("}").toString();
    }

    public static class Builder {
        private final List<Pair<String, ValueType>> columnTypeList = new ArrayList<Pair<String, ValueType>>();

        private Builder() {
        }

        public Builder add(String columnName, @Nullable ValueType columnType) {
            Preconditions.checkNotNull((Object)columnName, (Object)"'columnName' must be nonnull");
            this.columnTypeList.add((Pair<String, ValueType>)Pair.of((Object)columnName, (Object)((Object)columnType)));
            return this;
        }

        public Builder addAll(RowSignature other) {
            for (String columnName : other.getColumnNames()) {
                this.add(columnName, other.getColumnType(columnName).orElse(null));
            }
            return this;
        }

        public Builder addTimeColumn() {
            return this.add("__time", ValueType.LONG);
        }

        public Builder addDimensions(List<DimensionSpec> dimensions) {
            for (DimensionSpec dimension : dimensions) {
                this.add(dimension.getOutputName(), dimension.getOutputType());
            }
            return this;
        }

        public Builder addAggregators(List<AggregatorFactory> aggregators) {
            for (AggregatorFactory aggregator : aggregators) {
                ValueType type = (ValueType)GuavaUtils.getEnumIfPresent(ValueType.class, (String)StringUtils.toUpperCase((String)aggregator.getTypeName()));
                if (type != null && type.isNumeric()) {
                    this.add(aggregator.getName(), type);
                    continue;
                }
                this.add(aggregator.getName(), null);
            }
            return this;
        }

        public Builder addPostAggregators(List<PostAggregator> postAggregators) {
            for (PostAggregator postAggregator : postAggregators) {
                String name = (String)Preconditions.checkNotNull((Object)postAggregator.getName(), (Object)"postAggregators must have nonnull names");
                this.add(name, null);
            }
            return this;
        }

        public RowSignature build() {
            return new RowSignature(this.columnTypeList);
        }
    }
}

