/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DoubleWrappingDimensionSelector;
import org.apache.druid.segment.FloatWrappingDimensionSelector;
import org.apache.druid.segment.LongWrappingDimensionSelector;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableDimensionValueSelector;
import org.apache.druid.segment.selector.settable.SettableDoubleColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableFloatColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableLongColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableObjectColumnValueSelector;

public enum ValueType {
    FLOAT{

        @Override
        public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, @Nullable ExtractionFn extractionFn) {
            return new FloatWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
        }

        @Override
        public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
            return new SettableFloatColumnValueSelector();
        }
    }
    ,
    DOUBLE{

        @Override
        public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, @Nullable ExtractionFn extractionFn) {
            return new DoubleWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
        }

        @Override
        public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
            return new SettableDoubleColumnValueSelector();
        }
    }
    ,
    LONG{

        @Override
        public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, @Nullable ExtractionFn extractionFn) {
            return new LongWrappingDimensionSelector(numericColumnValueSelector, extractionFn);
        }

        @Override
        public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
            return new SettableLongColumnValueSelector();
        }
    }
    ,
    STRING{

        @Override
        public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
            return new SettableDimensionValueSelector();
        }
    }
    ,
    COMPLEX{

        @Override
        public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
            return new SettableObjectColumnValueSelector();
        }
    };


    public DimensionSelector makeNumericWrappingDimensionSelector(ColumnValueSelector numericColumnValueSelector, @Nullable ExtractionFn extractionFn) {
        throw new UnsupportedOperationException("Not a numeric value type: " + this.name());
    }

    public abstract SettableColumnValueSelector makeNewSettableColumnValueSelector();

    public boolean isNumeric() {
        return ValueType.isNumeric(this);
    }

    @JsonCreator
    @Nullable
    public static ValueType fromString(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return ValueType.valueOf(StringUtils.toUpperCase((String)name));
    }

    public static boolean isNumeric(ValueType type) {
        return type == LONG || type == FLOAT || type == DOUBLE;
    }
}

