/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Predicate;
import java.util.List;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.Rows;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.filter.ValueMatchers;

public class PredicateValueMatcherFactory
implements ColumnProcessorFactory<ValueMatcher> {
    private final DruidPredicateFactory predicateFactory;

    PredicateValueMatcherFactory(DruidPredicateFactory predicateFactory) {
        this.predicateFactory = predicateFactory;
    }

    @Override
    public ValueType defaultType() {
        return ValueType.COMPLEX;
    }

    @Override
    public ValueMatcher makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
        return ValueMatchers.makeStringValueMatcher(selector, this.predicateFactory, multiValue);
    }

    @Override
    public ValueMatcher makeFloatProcessor(BaseFloatColumnValueSelector selector) {
        return ValueMatchers.makeFloatValueMatcher(selector, this.predicateFactory);
    }

    @Override
    public ValueMatcher makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
        return ValueMatchers.makeDoubleValueMatcher(selector, this.predicateFactory);
    }

    @Override
    public ValueMatcher makeLongProcessor(BaseLongColumnValueSelector selector) {
        return ValueMatchers.makeLongValueMatcher(selector, this.predicateFactory);
    }

    @Override
    public ValueMatcher makeComplexProcessor(final BaseObjectColumnValueSelector<?> selector) {
        if (selector instanceof NilColumnValueSelector || !PredicateValueMatcherFactory.mayBeFilterable(selector.classOfObject())) {
            return BooleanValueMatcher.of(this.predicateFactory.makeStringPredicate().apply(null));
        }
        return new ValueMatcher(){
            private Predicate<String> stringPredicate;
            private DruidLongPredicate longPredicate;
            private DruidFloatPredicate floatPredicate;
            private DruidDoublePredicate doublePredicate;

            @Override
            public boolean matches() {
                Object rowValue = selector.getObject();
                if (rowValue == null) {
                    return this.getStringPredicate().apply(null);
                }
                if (rowValue instanceof Integer) {
                    return this.getLongPredicate().applyLong(((Integer)rowValue).intValue());
                }
                if (rowValue instanceof Long) {
                    return this.getLongPredicate().applyLong((Long)rowValue);
                }
                if (rowValue instanceof Float) {
                    return this.getFloatPredicate().applyFloat(((Float)rowValue).floatValue());
                }
                if (rowValue instanceof Number) {
                    return this.getDoublePredicate().applyDouble((Double)rowValue);
                }
                List rowValueStrings = Rows.objectToStrings(rowValue);
                if (rowValueStrings.isEmpty()) {
                    return this.getStringPredicate().apply(null);
                }
                for (String rowValueString : rowValueStrings) {
                    if (!this.getStringPredicate().apply((Object)NullHandling.emptyToNullIfNeeded((String)rowValueString))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("value", PredicateValueMatcherFactory.this.predicateFactory);
            }

            private Predicate<String> getStringPredicate() {
                if (this.stringPredicate == null) {
                    this.stringPredicate = PredicateValueMatcherFactory.this.predicateFactory.makeStringPredicate();
                }
                return this.stringPredicate;
            }

            private DruidLongPredicate getLongPredicate() {
                if (this.longPredicate == null) {
                    this.longPredicate = PredicateValueMatcherFactory.this.predicateFactory.makeLongPredicate();
                }
                return this.longPredicate;
            }

            private DruidFloatPredicate getFloatPredicate() {
                if (this.floatPredicate == null) {
                    this.floatPredicate = PredicateValueMatcherFactory.this.predicateFactory.makeFloatPredicate();
                }
                return this.floatPredicate;
            }

            private DruidDoublePredicate getDoublePredicate() {
                if (this.doublePredicate == null) {
                    this.doublePredicate = PredicateValueMatcherFactory.this.predicateFactory.makeDoublePredicate();
                }
                return this.doublePredicate;
            }
        };
    }

    private static <T> boolean mayBeFilterable(Class<T> clazz) {
        if (Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(String.class);
    }
}

