/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.generator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.generator.ColumnValueGenerator;

public class GeneratorColumnSchema {
    private ValueDistribution distributionType;
    private String name;
    private ValueType type;
    private boolean isMetric;
    private int rowSize;
    private final Double nullProbability;
    private List<Object> enumeratedValues;
    private List<Double> enumeratedProbabilities;
    private Integer startInt;
    private Integer endInt;
    private Double startDouble;
    private Double endDouble;
    private Double zipfExponent;
    private Double mean;
    private Double standardDeviation;

    @JsonCreator
    public GeneratorColumnSchema(@JsonProperty(value="name") String name, @JsonProperty(value="type") ValueType type, @JsonProperty(value="isMetric") boolean isMetric, @JsonProperty(value="rowSize") int rowSize, @JsonProperty(value="nullProbability") Double nullProbability, @JsonProperty(value="distributionType") ValueDistribution distributionType, @JsonProperty(value="enumeratedValues") List<Object> enumeratedValues, @JsonProperty(value="enumeratedProbabilities") List<Double> enumeratedProbabilities, @JsonProperty(value="startInt") Integer startInt, @JsonProperty(value="endInt") Integer endInt, @JsonProperty(value="startDouble") Double startDouble, @JsonProperty(value="endDouble") Double endDouble, @JsonProperty(value="zipfExponent") Double zipfExponent, @JsonProperty(value="mean") Double mean, @JsonProperty(value="standardDeviation") Double standardDeviation) {
        this.name = name;
        this.type = type;
        this.isMetric = isMetric;
        this.distributionType = distributionType;
        this.rowSize = rowSize;
        this.nullProbability = nullProbability;
        this.enumeratedValues = enumeratedValues;
        this.enumeratedProbabilities = enumeratedProbabilities;
        this.startInt = startInt;
        this.endInt = endInt;
        this.startDouble = startDouble;
        this.endDouble = endDouble;
        this.zipfExponent = zipfExponent;
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    private GeneratorColumnSchema(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, ValueDistribution distributionType) {
        this.name = name;
        this.type = type;
        this.isMetric = isMetric;
        this.distributionType = distributionType;
        this.rowSize = rowSize;
        this.nullProbability = nullProbability;
    }

    public ColumnValueGenerator makeGenerator(long seed) {
        return new ColumnValueGenerator(this, seed);
    }

    @JsonIgnore
    public DimensionSchema getDimensionSchema() {
        switch (this.type) {
            case LONG: {
                return new LongDimensionSchema(this.name);
            }
            case FLOAT: {
                return new FloatDimensionSchema(this.name);
            }
            case DOUBLE: {
                return new DoubleDimensionSchema(this.name);
            }
            case STRING: {
                return new StringDimensionSchema(this.name);
            }
        }
        throw new IAE("unable to make dimension schema for %s", new Object[]{this.type});
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Double getNullProbability() {
        return this.nullProbability;
    }

    @JsonProperty
    public ValueType getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isMetric() {
        return this.isMetric;
    }

    @JsonProperty
    public ValueDistribution getDistributionType() {
        return this.distributionType;
    }

    @JsonProperty
    public int getRowSize() {
        return this.rowSize;
    }

    @JsonProperty
    public List<Object> getEnumeratedValues() {
        return this.enumeratedValues;
    }

    @JsonProperty
    public List<Double> getEnumeratedProbabilities() {
        return this.enumeratedProbabilities;
    }

    @JsonProperty
    public Integer getStartInt() {
        return this.startInt;
    }

    @JsonProperty
    public Integer getEndInt() {
        return this.endInt;
    }

    @JsonProperty
    public Double getStartDouble() {
        return this.startDouble;
    }

    @JsonProperty
    public Double getEndDouble() {
        return this.endDouble;
    }

    @JsonProperty
    public Double getZipfExponent() {
        return this.zipfExponent;
    }

    @JsonProperty
    public Double getMean() {
        return this.mean;
    }

    @JsonProperty
    public Double getStandardDeviation() {
        return this.standardDeviation;
    }

    public static GeneratorColumnSchema makeSequential(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, int startInt, int endInt) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, ValueDistribution.SEQUENTIAL);
        schema.startInt = startInt;
        schema.endInt = endInt;
        return schema;
    }

    public static GeneratorColumnSchema makeEnumeratedSequential(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, List<Object> enumeratedValues) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, ValueDistribution.SEQUENTIAL);
        schema.enumeratedValues = enumeratedValues;
        return schema;
    }

    public static GeneratorColumnSchema makeDiscreteUniform(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, int startInt, int endInt) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, ValueDistribution.DISCRETE_UNIFORM);
        schema.startInt = startInt;
        schema.endInt = endInt;
        return schema;
    }

    public static GeneratorColumnSchema makeEnumeratedDiscreteUniform(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, List<Object> enumeratedValues) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, ValueDistribution.DISCRETE_UNIFORM);
        schema.enumeratedValues = enumeratedValues;
        return schema;
    }

    public static GeneratorColumnSchema makeLazyDiscreteUniform(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, int startInt, int endInt) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, ValueDistribution.LAZY_DISCRETE_UNIFORM);
        schema.startInt = startInt;
        schema.endInt = endInt;
        return schema;
    }

    public static GeneratorColumnSchema makeContinuousUniform(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, double startDouble, double endDouble) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, ValueDistribution.UNIFORM);
        schema.startDouble = startDouble;
        schema.endDouble = endDouble;
        return schema;
    }

    public static GeneratorColumnSchema makeNormal(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, Double mean, Double standardDeviation, boolean useRounding) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, useRounding ? ValueDistribution.ROUNDED_NORMAL : ValueDistribution.NORMAL);
        schema.mean = mean;
        schema.standardDeviation = standardDeviation;
        return schema;
    }

    public static GeneratorColumnSchema makeZipf(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, int startInt, int endInt, Double zipfExponent) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, ValueDistribution.ZIPF);
        schema.startInt = startInt;
        schema.endInt = endInt;
        schema.zipfExponent = zipfExponent;
        return schema;
    }

    public static GeneratorColumnSchema makeLazyZipf(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, int startInt, int endInt, Double zipfExponent) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, ValueDistribution.LAZY_ZIPF);
        schema.startInt = startInt;
        schema.endInt = endInt;
        schema.zipfExponent = zipfExponent;
        return schema;
    }

    public static GeneratorColumnSchema makeEnumeratedZipf(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, List<Object> enumeratedValues, Double zipfExponent) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, ValueDistribution.ZIPF);
        schema.enumeratedValues = enumeratedValues;
        schema.zipfExponent = zipfExponent;
        return schema;
    }

    public static GeneratorColumnSchema makeEnumerated(String name, ValueType type, boolean isMetric, int rowSize, Double nullProbability, List<Object> enumeratedValues, List<Double> enumeratedProbabilities) {
        GeneratorColumnSchema schema = new GeneratorColumnSchema(name, type, isMetric, rowSize, nullProbability, ValueDistribution.ENUMERATED);
        schema.enumeratedValues = enumeratedValues;
        schema.enumeratedProbabilities = enumeratedProbabilities;
        return schema;
    }

    public String toString() {
        return "BenchmarkColumnSchema{distributionType=" + (Object)((Object)this.distributionType) + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", isMetric=" + this.isMetric + ", rowSize=" + this.rowSize + ", nullProbability=" + this.nullProbability + ", enumeratedValues=" + this.enumeratedValues + ", enumeratedProbabilities=" + this.enumeratedProbabilities + ", startInt=" + this.startInt + ", endInt=" + this.endInt + ", startDouble=" + this.startDouble + ", endDouble=" + this.endDouble + ", zipfExponent=" + this.zipfExponent + ", mean=" + this.mean + ", standardDeviation=" + this.standardDeviation + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratorColumnSchema that = (GeneratorColumnSchema)o;
        return this.isMetric == that.isMetric && this.rowSize == that.rowSize && this.distributionType == that.distributionType && this.name.equals(that.name) && this.type == that.type && Objects.equals(this.nullProbability, that.nullProbability) && Objects.equals(this.enumeratedValues, that.enumeratedValues) && Objects.equals(this.enumeratedProbabilities, that.enumeratedProbabilities) && Objects.equals(this.startInt, that.startInt) && Objects.equals(this.endInt, that.endInt) && Objects.equals(this.startDouble, that.startDouble) && Objects.equals(this.endDouble, that.endDouble) && Objects.equals(this.zipfExponent, that.zipfExponent) && Objects.equals(this.mean, that.mean) && Objects.equals(this.standardDeviation, that.standardDeviation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.distributionType, this.name, this.type, this.isMetric, this.rowSize, this.nullProbability, this.enumeratedValues, this.enumeratedProbabilities, this.startInt, this.endInt, this.startDouble, this.endDouble, this.zipfExponent, this.mean, this.standardDeviation});
    }

    public static enum ValueDistribution {
        SEQUENTIAL,
        DISCRETE_UNIFORM,
        ROUNDED_NORMAL,
        ZIPF,
        ENUMERATED,
        LAZY_ZIPF,
        LAZY_DISCRETE_UNIFORM,
        UNIFORM,
        NORMAL;

    }
}

