/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinMatcher;

public class RowBasedIndexedTable<RowType>
implements IndexedTable {
    private final List<RowType> table;
    private final List<Map<Object, IntList>> index;
    private final RowSignature rowSignature;
    private final List<Function<RowType, Object>> columnFunctions;
    private final Set<String> keyColumns;
    private final String version;

    public RowBasedIndexedTable(List<RowType> table, RowAdapter<RowType> rowAdapter, RowSignature rowSignature, Set<String> keyColumns, String version) {
        this.table = table;
        this.rowSignature = rowSignature;
        this.columnFunctions = rowSignature.getColumnNames().stream().map(rowAdapter::columnFunction).collect(Collectors.toList());
        this.keyColumns = keyColumns;
        this.version = version;
        if (new HashSet<String>(keyColumns).size() != keyColumns.size()) {
            throw new ISE("keyColumns[%s] must not contain duplicates", new Object[]{keyColumns});
        }
        if (!ImmutableSet.copyOf(rowSignature.getColumnNames()).containsAll(keyColumns)) {
            throw new ISE("keyColumns[%s] must all be contained in rowSignature[%s]", new Object[]{String.join((CharSequence)", ", keyColumns), rowSignature});
        }
        this.index = new ArrayList<Map<Object, IntList>>(rowSignature.size());
        for (int i = 0; i < rowSignature.size(); ++i) {
            HashMap<Object, IntList> m;
            String column = rowSignature.getColumnName(i);
            if (keyColumns.contains(column)) {
                ValueType keyType = rowSignature.getColumnType(column).orElse(IndexedTableJoinMatcher.DEFAULT_KEY_TYPE);
                Function<RowType, Object> columnFunction = this.columnFunctions.get(i);
                m = new HashMap<Object, IntList>();
                for (int j = 0; j < table.size(); ++j) {
                    RowType row = table.get(j);
                    Comparable<?> key = DimensionHandlerUtils.convertObjectToType(columnFunction.apply(row), keyType);
                    if (key == null) continue;
                    IntList array = m.computeIfAbsent(key, k -> new IntArrayList());
                    array.add(j);
                }
            } else {
                m = null;
            }
            this.index.add(m);
        }
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public Set<String> keyColumns() {
        return this.keyColumns;
    }

    @Override
    public RowSignature rowSignature() {
        return this.rowSignature;
    }

    @Override
    public IndexedTable.Index columnIndex(int column) {
        Map<Object, IntList> indexMap = this.index.get(column);
        if (indexMap == null) {
            throw new IAE("Column[%d] is not a key column", new Object[]{column});
        }
        ValueType columnType = this.rowSignature.getColumnType(column).orElse(IndexedTableJoinMatcher.DEFAULT_KEY_TYPE);
        return key -> {
            Comparable<?> convertedKey = DimensionHandlerUtils.convertObjectToType(key, columnType, false);
            if (convertedKey != null) {
                IntList found = (IntList)indexMap.get(convertedKey);
                if (found != null) {
                    return found;
                }
                return IntLists.EMPTY_LIST;
            }
            return IntLists.EMPTY_LIST;
        };
    }

    @Override
    public IndexedTable.Reader columnReader(int column) {
        Function<RowType, Object> columnFn = this.columnFunctions.get(column);
        if (columnFn == null) {
            throw new IAE("Column[%d] is not a valid column", new Object[]{column});
        }
        return row -> columnFn.apply(this.table.get(row));
    }

    @Override
    public int numRows() {
        return this.table.size();
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        return Optional.of(() -> {});
    }

    @Override
    public void close() {
    }
}

