/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.FloatColumnSelector;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;

public class AggregatorUtil {
    public static final byte STRING_SEPARATOR = -1;
    public static final byte COUNT_CACHE_TYPE_ID = 0;
    public static final byte LONG_SUM_CACHE_TYPE_ID = 1;
    public static final byte DOUBLE_SUM_CACHE_TYPE_ID = 2;
    public static final byte DOUBLE_MAX_CACHE_TYPE_ID = 3;
    public static final byte DOUBLE_MIN_CACHE_TYPE_ID = 4;
    public static final byte HYPER_UNIQUE_CACHE_TYPE_ID = 5;
    public static final byte JS_CACHE_TYPE_ID = 6;
    public static final byte HIST_CACHE_TYPE_ID = 7;
    public static final byte CARD_CACHE_TYPE_ID = 8;
    public static final byte FILTERED_AGG_CACHE_TYPE_ID = 9;
    public static final byte LONG_MAX_CACHE_TYPE_ID = 10;
    public static final byte LONG_MIN_CACHE_TYPE_ID = 11;
    public static final byte FLOAT_SUM_CACHE_TYPE_ID = 12;
    public static final byte FLOAT_MAX_CACHE_TYPE_ID = 13;
    public static final byte FLOAT_MIN_CACHE_TYPE_ID = 14;
    public static final byte SKETCH_MERGE_CACHE_TYPE_ID = 15;
    public static final byte DISTINCT_COUNT_CACHE_KEY = 16;
    public static final byte FLOAT_LAST_CACHE_TYPE_ID = 17;
    public static final byte APPROX_HIST_CACHE_TYPE_ID = 18;
    public static final byte APPROX_HIST_FOLDING_CACHE_TYPE_ID = 19;
    public static final byte DOUBLE_FIRST_CACHE_TYPE_ID = 20;
    public static final byte DOUBLE_LAST_CACHE_TYPE_ID = 21;
    public static final byte FLOAT_FIRST_CACHE_TYPE_ID = 22;
    public static final byte LONG_FIRST_CACHE_TYPE_ID = 23;
    public static final byte LONG_LAST_CACHE_TYPE_ID = 24;
    public static final byte TIMESTAMP_CACHE_TYPE_ID = 25;
    public static final byte VARIANCE_CACHE_TYPE_ID = 26;
    public static final byte QUANTILES_DOUBLES_SKETCH_BUILD_CACHE_TYPE_ID = 27;
    public static final byte QUANTILES_DOUBLES_SKETCH_MERGE_CACHE_TYPE_ID = 28;
    public static final byte QUANTILES_DOUBLES_SKETCH_TO_HISTOGRAM_CACHE_TYPE_ID = 29;
    public static final byte QUANTILES_DOUBLES_SKETCH_TO_QUANTILE_CACHE_TYPE_ID = 30;
    public static final byte QUANTILES_DOUBLES_SKETCH_TO_QUANTILES_CACHE_TYPE_ID = 31;
    public static final byte QUANTILES_DOUBLES_SKETCH_TO_STRING_CACHE_TYPE_ID = 32;
    public static final byte ARRAY_OF_DOUBLES_SKETCH_CACHE_TYPE_ID = 33;
    public static final byte ARRAY_OF_DOUBLES_SKETCH_SET_OP_CACHE_TYPE_ID = 34;
    public static final byte ARRAY_OF_DOUBLES_SKETCH_TO_ESTIMATE_CACHE_TYPE_ID = 35;
    public static final byte ARRAY_OF_DOUBLES_SKETCH_TO_ESTIMATE_AND_BOUNDS_CACHE_TYPE_ID = 36;
    public static final byte ARRAY_OF_DOUBLES_SKETCH_TO_MEANS_CACHE_TYPE_ID = 37;
    public static final byte ARRAY_OF_DOUBLES_SKETCH_TO_VARIANCES_CACHE_TYPE_ID = 38;
    public static final byte ARRAY_OF_DOUBLES_SKETCH_TO_NUM_ENTRIES_CACHE_TYPE_ID = 39;
    public static final byte ARRAY_OF_DOUBLES_SKETCH_TO_QUANTILES_SKETCH_CACHE_TYPE_ID = 40;
    public static final byte ARRAY_OF_DOUBLES_SKETCH_T_TEST_CACHE_TYPE_ID = 41;
    public static final byte ARRAY_OF_DOUBLES_SKETCH_TO_STRING_CACHE_TYPE_ID = 42;
    public static final byte STRING_FIRST_CACHE_TYPE_ID = 43;
    public static final byte STRING_LAST_CACHE_TYPE_ID = 44;
    public static final byte SUPPRESSED_AGG_CACHE_TYPE_ID = 45;
    public static final byte HLL_SKETCH_BUILD_CACHE_TYPE_ID = 46;
    public static final byte HLL_SKETCH_MERGE_CACHE_TYPE_ID = 47;
    public static final byte HLL_SKETCH_UNION_CACHE_TYPE_ID = 48;
    public static final byte HLL_SKETCH_TO_STRING_CACHE_TYPE_ID = 49;
    public static final byte HLL_SKETCH_TO_ESTIMATE_AND_BOUNDS_CACHE_TYPE_ID = 50;
    public static final byte FIXED_BUCKET_HIST_CACHE_TYPE_ID = 51;
    public static final byte BLOOM_FILTER_CACHE_TYPE_ID = 52;
    public static final byte BLOOM_FILTER_MERGE_CACHE_TYPE_ID = 53;
    public static final byte MOMENTS_SKETCH_BUILD_CACHE_TYPE_ID = 54;
    public static final byte MOMENTS_SKETCH_MERGE_CACHE_TYPE_ID = 55;
    public static final byte TDIGEST_BUILD_SKETCH_CACHE_TYPE_ID = 56;
    public static final byte MEAN_CACHE_TYPE_ID = 65;
    public static final byte LONG_ANY_CACHE_TYPE_ID = 66;
    public static final byte DOUBLE_ANY_CACHE_TYPE_ID = 67;
    public static final byte FLOAT_ANY_CACHE_TYPE_ID = 68;
    public static final byte STRING_ANY_CACHE_TYPE_ID = 69;

    public static List<PostAggregator> pruneDependentPostAgg(List<PostAggregator> postAggregatorList, String postAggName) {
        ArrayList<PostAggregator> rv = new ArrayList<PostAggregator>();
        HashSet<String> deps = new HashSet<String>();
        deps.add(postAggName);
        for (PostAggregator agg : Lists.reverse(postAggregatorList)) {
            if (!deps.contains(agg.getName())) continue;
            rv.add(agg);
            deps.remove(agg.getName());
            deps.addAll(agg.getDependentFields());
        }
        Collections.reverse(rv);
        return rv;
    }

    public static Pair<List<AggregatorFactory>, List<PostAggregator>> condensedAggregators(List<AggregatorFactory> aggList, List<PostAggregator> postAggList, String metric) {
        List<PostAggregator> condensedPostAggs = AggregatorUtil.pruneDependentPostAgg(postAggList, metric);
        HashSet<String> dependencySet = new HashSet<String>();
        dependencySet.add(metric);
        for (PostAggregator postAggregator : condensedPostAggs) {
            dependencySet.addAll(postAggregator.getDependentFields());
        }
        ArrayList<AggregatorFactory> condensedAggs = new ArrayList<AggregatorFactory>();
        for (AggregatorFactory aggregatorSpec : aggList) {
            if (!dependencySet.contains(aggregatorSpec.getName())) continue;
            condensedAggs.add(aggregatorSpec);
        }
        return new Pair(condensedAggs, condensedPostAggs);
    }

    static ColumnValueSelector makeColumnValueSelectorWithFloatDefault(ColumnSelectorFactory metricFactory, @Nullable String fieldName, @Nullable Expr fieldExpression, final float nullValue) {
        if (fieldName == null == (fieldExpression == null)) {
            throw new IllegalArgumentException("Only one of fieldName or expression should be non-null");
        }
        if (fieldName != null) {
            return metricFactory.makeColumnValueSelector(fieldName);
        }
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(metricFactory, fieldExpression);
        class ExpressionFloatColumnSelector
        implements FloatColumnSelector {
            ExpressionFloatColumnSelector() {
            }

            @Override
            public float getFloat() {
                ExprEval exprEval = (ExprEval)baseSelector.getObject();
                return exprEval.isNumericNull() ? nullValue : (float)exprEval.asDouble();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }

            @Override
            public boolean isNull() {
                ExprEval exprEval = (ExprEval)baseSelector.getObject();
                return exprEval == null || exprEval.isNumericNull();
            }
        }
        return new ExpressionFloatColumnSelector();
    }

    static ColumnValueSelector makeColumnValueSelectorWithLongDefault(ColumnSelectorFactory metricFactory, @Nullable String fieldName, @Nullable Expr fieldExpression, final long nullValue) {
        if (fieldName == null == (fieldExpression == null)) {
            throw new IllegalArgumentException("Only one of fieldName and fieldExpression should be non-null");
        }
        if (fieldName != null) {
            return metricFactory.makeColumnValueSelector(fieldName);
        }
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(metricFactory, fieldExpression);
        class ExpressionLongColumnSelector
        implements LongColumnSelector {
            ExpressionLongColumnSelector() {
            }

            @Override
            public long getLong() {
                ExprEval exprEval = (ExprEval)baseSelector.getObject();
                return exprEval.isNumericNull() ? nullValue : exprEval.asLong();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }

            @Override
            public boolean isNull() {
                ExprEval exprEval = (ExprEval)baseSelector.getObject();
                return exprEval == null || exprEval.isNumericNull();
            }
        }
        return new ExpressionLongColumnSelector();
    }

    static ColumnValueSelector makeColumnValueSelectorWithDoubleDefault(ColumnSelectorFactory metricFactory, @Nullable String fieldName, @Nullable Expr fieldExpression, final double nullValue) {
        if (fieldName == null == (fieldExpression == null)) {
            throw new IllegalArgumentException("Only one of fieldName and fieldExpression should be non-null");
        }
        if (fieldName != null) {
            return metricFactory.makeColumnValueSelector(fieldName);
        }
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(metricFactory, fieldExpression);
        class ExpressionDoubleColumnSelector
        implements DoubleColumnSelector {
            ExpressionDoubleColumnSelector() {
            }

            @Override
            public double getDouble() {
                ExprEval exprEval = (ExprEval)baseSelector.getObject();
                return exprEval.isNumericNull() ? nullValue : exprEval.asDouble();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }

            @Override
            public boolean isNull() {
                ExprEval exprEval = (ExprEval)baseSelector.getObject();
                return exprEval == null || exprEval.isNumericNull();
            }
        }
        return new ExpressionDoubleColumnSelector();
    }

    public static boolean canVectorize(ColumnInspector columnInspector, @Nullable String fieldName, @Nullable String expression, Supplier<Expr> fieldExpression) {
        if (fieldName != null) {
            ColumnCapabilities capabilities = columnInspector.getColumnCapabilities(fieldName);
            return capabilities == null || ValueType.isNumeric((ValueType)capabilities.getType());
        }
        if (expression != null) {
            return ((Expr)fieldExpression.get()).canVectorize((Expr.InputBindingTypes)columnInspector);
        }
        return false;
    }

    public static VectorValueSelector makeVectorValueSelector(VectorColumnSelectorFactory columnSelectorFactory, @Nullable String fieldName, @Nullable String expression, Supplier<Expr> fieldExpression) {
        if (fieldName == null == (expression == null)) {
            throw new IllegalArgumentException("Only one of fieldName or expression should be non-null");
        }
        if (expression != null) {
            return ExpressionVectorSelectors.makeVectorValueSelector(columnSelectorFactory, (Expr)fieldExpression.get());
        }
        return columnSelectorFactory.makeValueSelector(fieldName);
    }
}

