/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.net.Inet4Address;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.query.expression.IPv4AddressExprUtils;

public class IPv4AddressParseExprMacro
implements ExprMacroTable.ExprMacro {
    public static final String FN_NAME = "ipv4_parse";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        if (args.size() != 1) {
            throw new IAE(ExprUtils.createErrMsg(this.name(), "must have 1 argument"), new Object[0]);
        }
        Expr arg = args.get(0);
        class IPv4AddressParseExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            IPv4AddressParseExpr(Expr arg) {
                super(IPv4AddressParseExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval eval = this.arg.eval(bindings);
                switch (eval.type()) {
                    case STRING: {
                        return IPv4AddressParseExprMacro.evalAsString(eval);
                    }
                    case LONG: {
                        return IPv4AddressParseExprMacro.evalAsLong(eval);
                    }
                }
                return ExprEval.ofLong(null);
            }

            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit((Expr)new IPv4AddressParseExpr(newArg));
            }

            @Nullable
            public ExprType getOutputType(Expr.InputBindingTypes inputTypes) {
                return ExprType.LONG;
            }
        }
        return new IPv4AddressParseExpr(arg);
    }

    private static ExprEval evalAsString(ExprEval eval) {
        Inet4Address address = IPv4AddressExprUtils.parse(eval.asString());
        Long value = address == null ? null : Long.valueOf(IPv4AddressExprUtils.toLong(address));
        return ExprEval.ofLong((Number)value);
    }

    private static ExprEval evalAsLong(ExprEval eval) {
        if (eval.isNumericNull() || !IPv4AddressExprUtils.overflowsUnsignedInt(eval.asLong())) {
            return eval;
        }
        return ExprEval.ofLong(null);
    }
}

