/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ValueType;

public class GrouperBufferComparatorUtils {
    public static Grouper.BufferComparator bufferComparator(boolean includeTimestamp, boolean sortByDimsFirst, final int dimCount, final Grouper.BufferComparator[] serdeHelperComparators) {
        if (includeTimestamp) {
            if (sortByDimsFirst) {
                return new Grouper.BufferComparator(){

                    @Override
                    public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                        int cmp = GrouperBufferComparatorUtils.compareDimsInBuffersForNullFudgeTimestamp(serdeHelperComparators, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return Longs.compare((long)lhsBuffer.getLong(lhsPosition), (long)rhsBuffer.getLong(rhsPosition));
                    }
                };
            }
            return new Grouper.BufferComparator(){

                @Override
                public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                    int timeCompare = Longs.compare((long)lhsBuffer.getLong(lhsPosition), (long)rhsBuffer.getLong(rhsPosition));
                    if (timeCompare != 0) {
                        return timeCompare;
                    }
                    return GrouperBufferComparatorUtils.compareDimsInBuffersForNullFudgeTimestamp(serdeHelperComparators, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                }
            };
        }
        return new Grouper.BufferComparator(){

            @Override
            public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                for (int i = 0; i < dimCount; ++i) {
                    int cmp = serdeHelperComparators[i].compare(lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                    if (cmp == 0) continue;
                    return cmp;
                }
                return 0;
            }
        };
    }

    public static Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets, DefaultLimitSpec limitSpec, List<DimensionSpec> dimensions, Grouper.BufferComparator[] dimComparators, boolean includeTimestamp, boolean sortByDimsFirst) {
        int dimCount = dimensions.size();
        final ArrayList<Boolean> needsReverses = new ArrayList<Boolean>();
        ArrayList<Grouper.BufferComparator> comparators = new ArrayList<Grouper.BufferComparator>();
        HashSet<Integer> orderByIndices = new HashSet<Integer>();
        int aggCount = 0;
        for (OrderByColumnSpec orderSpec : limitSpec.getColumns()) {
            boolean needsReverse = orderSpec.getDirection() != OrderByColumnSpec.Direction.ASCENDING;
            int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, dimensions);
            if (dimIndex >= 0) {
                comparators.add(dimComparators[dimIndex]);
                orderByIndices.add(dimIndex);
                needsReverses.add(needsReverse);
                continue;
            }
            int aggIndex = OrderByColumnSpec.getAggIndexForOrderBy(orderSpec, Arrays.asList(aggregatorFactories));
            if (aggIndex < 0) continue;
            StringComparator stringComparator = orderSpec.getDimensionComparator();
            ValueType valueType = aggregatorFactories[aggIndex].getType();
            int aggOffset = aggregatorOffsets[aggIndex] - 4;
            ++aggCount;
            if (!valueType.isNumeric()) {
                throw new IAE("Cannot order by a non-numeric aggregator[%s]", new Object[]{orderSpec});
            }
            comparators.add(GrouperBufferComparatorUtils.makeNullHandlingBufferComparatorForNumericData(aggOffset, GrouperBufferComparatorUtils.makeNumericBufferComparator(valueType, aggOffset, true, stringComparator)));
            needsReverses.add(needsReverse);
        }
        for (int i = 0; i < dimCount; ++i) {
            if (orderByIndices.contains(i)) continue;
            comparators.add(dimComparators[i]);
            needsReverses.add(false);
        }
        final Grouper.BufferComparator[] adjustedSerdeHelperComparators = comparators.toArray(new Grouper.BufferComparator[0]);
        final int fieldCount = dimCount + aggCount;
        if (includeTimestamp) {
            if (sortByDimsFirst) {
                return new Grouper.BufferComparator(){

                    @Override
                    public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                        int cmp = GrouperBufferComparatorUtils.compareDimsInBuffersForNullFudgeTimestampForPushDown(adjustedSerdeHelperComparators, needsReverses, fieldCount, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return Longs.compare((long)lhsBuffer.getLong(lhsPosition), (long)rhsBuffer.getLong(rhsPosition));
                    }
                };
            }
            return new Grouper.BufferComparator(){

                @Override
                public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                    int timeCompare = Longs.compare((long)lhsBuffer.getLong(lhsPosition), (long)rhsBuffer.getLong(rhsPosition));
                    if (timeCompare != 0) {
                        return timeCompare;
                    }
                    int cmp = GrouperBufferComparatorUtils.compareDimsInBuffersForNullFudgeTimestampForPushDown(adjustedSerdeHelperComparators, needsReverses, fieldCount, lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                    return cmp;
                }
            };
        }
        return new Grouper.BufferComparator(){

            @Override
            public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                for (int i = 0; i < fieldCount; ++i) {
                    int cmp = (Boolean)needsReverses.get(i) != false ? adjustedSerdeHelperComparators[i].compare(rhsBuffer, lhsBuffer, rhsPosition, lhsPosition) : adjustedSerdeHelperComparators[i].compare(lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
                    if (cmp == 0) continue;
                    return cmp;
                }
                return 0;
            }
        };
    }

    private static int compareDimsInBuffersForNullFudgeTimestampForPushDown(Grouper.BufferComparator[] serdeHelperComparators, List<Boolean> needsReverses, int dimCount, ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
        for (int i = 0; i < dimCount; ++i) {
            int cmp = needsReverses.get(i) != false ? serdeHelperComparators[i].compare(rhsBuffer, lhsBuffer, rhsPosition + 8, lhsPosition + 8) : serdeHelperComparators[i].compare(lhsBuffer, rhsBuffer, lhsPosition + 8, rhsPosition + 8);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static int compareDimsInBuffersForNullFudgeTimestamp(Grouper.BufferComparator[] serdeHelperComparators, ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
        for (Grouper.BufferComparator comparator : serdeHelperComparators) {
            int cmp = comparator.compare(lhsBuffer, rhsBuffer, lhsPosition + 8, rhsPosition + 8);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static Grouper.BufferComparator makeNumericBufferComparator(ValueType valueType, int keyBufferPosition, boolean pushLimitDown, @Nullable StringComparator stringComparator) {
        switch (valueType) {
            case LONG: {
                return GrouperBufferComparatorUtils.makeBufferComparatorForLong(keyBufferPosition, pushLimitDown, stringComparator);
            }
            case FLOAT: {
                return GrouperBufferComparatorUtils.makeBufferComparatorForFloat(keyBufferPosition, pushLimitDown, stringComparator);
            }
            case DOUBLE: {
                return GrouperBufferComparatorUtils.makeBufferComparatorForDouble(keyBufferPosition, pushLimitDown, stringComparator);
            }
        }
        throw new IAE("invalid type: %s", new Object[]{valueType});
    }

    public static Grouper.BufferComparator makeBufferComparatorForLong(int keyBufferPosition, boolean pushLimitDown, @Nullable StringComparator stringComparator) {
        if (GrouperBufferComparatorUtils.isPrimitiveComparable(pushLimitDown, stringComparator)) {
            return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Longs.compare((long)lhsBuffer.getLong(lhsPosition + keyBufferPosition), (long)rhsBuffer.getLong(rhsPosition + keyBufferPosition));
        }
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            long lhs = lhsBuffer.getLong(lhsPosition + keyBufferPosition);
            long rhs = rhsBuffer.getLong(rhsPosition + keyBufferPosition);
            return stringComparator.compare(String.valueOf(lhs), String.valueOf(rhs));
        };
    }

    public static Grouper.BufferComparator makeBufferComparatorForDouble(int keyBufferPosition, boolean pushLimitDown, @Nullable StringComparator stringComparator) {
        if (GrouperBufferComparatorUtils.isPrimitiveComparable(pushLimitDown, stringComparator)) {
            return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Double.compare(lhsBuffer.getDouble(lhsPosition + keyBufferPosition), rhsBuffer.getDouble(rhsPosition + keyBufferPosition));
        }
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            double lhs = lhsBuffer.getDouble(lhsPosition + keyBufferPosition);
            double rhs = rhsBuffer.getDouble(rhsPosition + keyBufferPosition);
            return stringComparator.compare(String.valueOf(lhs), String.valueOf(rhs));
        };
    }

    public static Grouper.BufferComparator makeBufferComparatorForFloat(int keyBufferPosition, boolean pushLimitDown, @Nullable StringComparator stringComparator) {
        if (GrouperBufferComparatorUtils.isPrimitiveComparable(pushLimitDown, stringComparator)) {
            return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Float.compare(lhsBuffer.getFloat(lhsPosition + keyBufferPosition), rhsBuffer.getFloat(rhsPosition + keyBufferPosition));
        }
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            float lhs = lhsBuffer.getFloat(lhsPosition + keyBufferPosition);
            float rhs = rhsBuffer.getFloat(rhsPosition + keyBufferPosition);
            return stringComparator.compare(String.valueOf(lhs), String.valueOf(rhs));
        };
    }

    public static Grouper.BufferComparator makeNullHandlingBufferComparatorForNumericData(int keyBufferPosition, Grouper.BufferComparator delegate) {
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            boolean isRhsNull;
            boolean isLhsNull = lhsBuffer.get(lhsPosition + keyBufferPosition) == 1;
            boolean bl = isRhsNull = rhsBuffer.get(rhsPosition + keyBufferPosition) == 1;
            if (isLhsNull && isRhsNull) {
                return 0;
            }
            if (isLhsNull) {
                return -1;
            }
            if (isRhsNull) {
                return 1;
            }
            return delegate.compare(lhsBuffer, rhsBuffer, lhsPosition, rhsPosition);
        };
    }

    private static boolean isPrimitiveComparable(boolean pushLimitDown, @Nullable StringComparator stringComparator) {
        return !pushLimitDown || stringComparator == null || stringComparator.equals(StringComparators.NUMERIC);
    }
}

