/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.AbstractBufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.ByteBufferHashTable;
import org.apache.druid.query.groupby.epinephelinae.ByteBufferMinMaxOffsetHeap;
import org.apache.druid.query.groupby.epinephelinae.Grouper;

public class LimitedBufferHashGrouper<KeyType>
extends AbstractBufferHashGrouper<KeyType> {
    private static final int MIN_INITIAL_BUCKETS = 4;
    private static final int DEFAULT_INITIAL_BUCKETS = 1024;
    private static final float DEFAULT_MAX_LOAD_FACTOR = 0.7f;
    private int limit;
    private boolean sortHasNonGroupingFields;
    private ByteBufferMinMaxOffsetHeap offsetHeap;
    private ByteBuffer totalBuffer;
    private ByteBuffer hashTableBuffer;
    private ByteBuffer offsetHeapBuffer;
    private BufferGrouperOffsetHeapIndexUpdater heapIndexUpdater;
    private boolean initialized = false;

    public LimitedBufferHashGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerde<KeyType> keySerde, AggregatorAdapters aggregators, int bufferGrouperMaxSize, float maxLoadFactor, int initialBuckets, int limit, boolean sortHasNonGroupingFields) {
        super(bufferSupplier, keySerde, aggregators, 4 + keySerde.keySize(), bufferGrouperMaxSize);
        this.maxLoadFactor = maxLoadFactor > 0.0f ? maxLoadFactor : 0.7f;
        this.initialBuckets = initialBuckets > 0 ? Math.max(4, initialBuckets) : 1024;
        this.limit = limit;
        this.sortHasNonGroupingFields = sortHasNonGroupingFields;
        if (this.maxLoadFactor >= 1.0f) {
            throw new IAE("Invalid maxLoadFactor[%f], must be < 1.0", new Object[]{Float.valueOf(maxLoadFactor)});
        }
        this.bucketSize = 4 + keySerde.keySize() + 4 + aggregators.spaceNeeded();
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.totalBuffer = (ByteBuffer)this.bufferSupplier.get();
        if (!this.validateBufferCapacity(this.totalBuffer.capacity())) {
            throw new IAE("LimitedBufferHashGrouper initialized with insufficient buffer capacity", new Object[0]);
        }
        int heapByteSize = (this.limit + 1) * 4;
        int hashTableSize = ByteBufferHashTable.calculateTableArenaSizeWithFixedAdditionalSize(this.totalBuffer.capacity(), this.bucketSize, heapByteSize);
        this.hashTableBuffer = this.totalBuffer.duplicate();
        this.hashTableBuffer.position(0);
        this.hashTableBuffer.limit(hashTableSize);
        this.hashTableBuffer = this.hashTableBuffer.slice();
        this.offsetHeapBuffer = this.totalBuffer.duplicate();
        this.offsetHeapBuffer.position(hashTableSize);
        this.offsetHeapBuffer = this.offsetHeapBuffer.slice();
        this.offsetHeapBuffer.limit(this.totalBuffer.capacity() - hashTableSize);
        this.hashTable = new AlternatingByteBufferHashTable(this.maxLoadFactor, this.initialBuckets, this.bucketSize, this.hashTableBuffer, this.keySize, this.bufferGrouperMaxSize);
        this.heapIndexUpdater = new BufferGrouperOffsetHeapIndexUpdater(this.totalBuffer, this.bucketSize - 4);
        this.offsetHeap = new ByteBufferMinMaxOffsetHeap(this.offsetHeapBuffer, this.limit, this.makeHeapComparator(), this.heapIndexUpdater);
        this.reset();
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void newBucketHook(int bucketOffset) {
        this.heapIndexUpdater.updateHeapIndexForOffset(bucketOffset, -1);
        if (!this.sortHasNonGroupingFields) {
            this.offsetHeap.addOffset(bucketOffset);
        }
    }

    @Override
    public boolean canSkipAggregate(int bucketOffset) {
        return !this.sortHasNonGroupingFields && this.heapIndexUpdater.getHeapIndexForOffset(bucketOffset) < 0;
    }

    @Override
    public void afterAggregateHook(int bucketOffset) {
        if (this.sortHasNonGroupingFields) {
            int heapIndex = this.heapIndexUpdater.getHeapIndexForOffset(bucketOffset);
            if (heapIndex < 0) {
                this.offsetHeap.addOffset(bucketOffset);
            } else {
                this.offsetHeap.removeAt(heapIndex);
                this.offsetHeap.addOffset(bucketOffset);
            }
        }
    }

    @Override
    public void reset() {
        this.hashTable.reset();
        this.keySerde.reset();
        this.offsetHeap.reset();
        this.heapIndexUpdater.setHashTableBuffer(this.hashTable.getTableBuffer());
    }

    @Override
    public CloseableIterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        if (!this.initialized) {
            return CloseableIterators.withEmptyBaggage(Collections.emptyIterator());
        }
        if (this.sortHasNonGroupingFields) {
            return this.makeDefaultOrderingIterator();
        }
        return this.makeHeapIterator();
    }

    public int getLimit() {
        return this.limit;
    }

    private CloseableIterator<Grouper.Entry<KeyType>> makeDefaultOrderingIterator() {
        final int size = this.offsetHeap.getHeapSize();
        final AbstractList<Integer> wrappedOffsets = new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return LimitedBufferHashGrouper.this.offsetHeap.getAt(index);
            }

            @Override
            public Integer set(int index, Integer element) {
                Integer oldValue = this.get(index);
                LimitedBufferHashGrouper.this.offsetHeap.setAt(index, element);
                return oldValue;
            }

            @Override
            public int size() {
                return size;
            }
        };
        final Grouper.BufferComparator comparator = this.keySerde.bufferComparator();
        Collections.sort(wrappedOffsets, new Comparator<Integer>(){

            @Override
            public int compare(Integer lhs, Integer rhs) {
                ByteBuffer curHashTableBuffer = LimitedBufferHashGrouper.this.hashTable.getTableBuffer();
                return comparator.compare(curHashTableBuffer, curHashTableBuffer, lhs + 4, rhs + 4);
            }
        });
        return new CloseableIterator<Grouper.Entry<KeyType>>(){
            int curr = 0;

            public boolean hasNext() {
                return this.curr < size;
            }

            public Grouper.Entry<KeyType> next() {
                return LimitedBufferHashGrouper.this.bucketEntryForOffset((Integer)wrappedOffsets.get(this.curr++));
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void close() {
            }
        };
    }

    private CloseableIterator<Grouper.Entry<KeyType>> makeHeapIterator() {
        final int initialHeapSize = this.offsetHeap.getHeapSize();
        return new CloseableIterator<Grouper.Entry<KeyType>>(){
            int curr = 0;

            public boolean hasNext() {
                return this.curr < initialHeapSize;
            }

            public Grouper.Entry<KeyType> next() {
                if (this.curr >= initialHeapSize) {
                    throw new NoSuchElementException();
                }
                int offset = LimitedBufferHashGrouper.this.offsetHeap.removeMin();
                Grouper.Entry entry = LimitedBufferHashGrouper.this.bucketEntryForOffset(offset);
                ++this.curr;
                return entry;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void close() {
            }
        };
    }

    private Comparator<Integer> makeHeapComparator() {
        return new Comparator<Integer>(){
            final Grouper.BufferComparator bufferComparator;
            {
                this.bufferComparator = LimitedBufferHashGrouper.this.keySerde.bufferComparatorWithAggregators(LimitedBufferHashGrouper.this.aggregators.factories().toArray(new AggregatorFactory[0]), LimitedBufferHashGrouper.this.aggregators.aggregatorPositions());
            }

            @Override
            public int compare(Integer o1, Integer o2) {
                ByteBuffer tableBuffer = LimitedBufferHashGrouper.this.hashTable.getTableBuffer();
                return this.bufferComparator.compare(tableBuffer, tableBuffer, o1 + 4, o2 + 4);
            }
        };
    }

    public boolean validateBufferCapacity(int bufferCapacity) {
        long heapSize;
        long numBucketsNeeded = (long)Math.ceil((float)(this.limit + 1) / this.maxLoadFactor);
        long targetTableArenaSize = numBucketsNeeded * (long)this.bucketSize * 2L;
        long requiredSize = targetTableArenaSize + (heapSize = ((long)this.limit + 1L) * 4L);
        if ((long)bufferCapacity < requiredSize) {
            log.debug("Buffer capacity [%,d] is too small for limit[%d] with load factor[%f], minimum bytes needed: [%,d], not applying limit push down optimization.", new Object[]{bufferCapacity, this.limit, Float.valueOf(this.maxLoadFactor), requiredSize});
            return false;
        }
        return true;
    }

    private class AlternatingByteBufferHashTable
    extends ByteBufferHashTable {
        private ByteBuffer[] subHashTableBuffers;

        public AlternatingByteBufferHashTable(float maxLoadFactor, int initialBuckets, int bucketSizeWithHash, ByteBuffer totalHashTableBuffer, int keySize, int maxSizeForTesting) {
            super(maxLoadFactor, initialBuckets, bucketSizeWithHash, totalHashTableBuffer, keySize, maxSizeForTesting, null);
            this.growthCount = 0;
            int subHashTableSize = this.tableArenaSize / 2;
            this.maxBuckets = subHashTableSize / bucketSizeWithHash;
            this.regrowthThreshold = this.maxSizeForBuckets(this.maxBuckets);
            ByteBuffer subHashTable1Buffer = totalHashTableBuffer.duplicate();
            subHashTable1Buffer.position(0);
            subHashTable1Buffer.limit(subHashTableSize);
            subHashTable1Buffer = subHashTable1Buffer.slice();
            ByteBuffer subHashTable2Buffer = totalHashTableBuffer.duplicate();
            subHashTable2Buffer.position(subHashTableSize);
            subHashTable2Buffer.limit(this.tableArenaSize);
            subHashTable2Buffer = subHashTable2Buffer.slice();
            this.subHashTableBuffers = new ByteBuffer[]{subHashTable1Buffer, subHashTable2Buffer};
        }

        @Override
        public void reset() {
            this.size = 0;
            this.growthCount = 0;
            for (int i = 0; i < this.maxBuckets; ++i) {
                this.subHashTableBuffers[0].put(i * this.bucketSizeWithHash, (byte)0);
            }
            this.tableBuffer = this.subHashTableBuffers[0];
        }

        @Override
        public void adjustTableWhenFull() {
            int newTableIdx = this.growthCount % 2 == 0 ? 1 : 0;
            ByteBuffer newTableBuffer = this.subHashTableBuffers[newTableIdx];
            for (int i = 0; i < this.maxBuckets; ++i) {
                newTableBuffer.put(i * this.bucketSizeWithHash, (byte)0);
            }
            ByteBuffer entryBuffer = this.tableBuffer.duplicate();
            ByteBuffer keyBuffer = this.tableBuffer.duplicate();
            int numCopied = 0;
            for (int i = 0; i < LimitedBufferHashGrouper.this.offsetHeap.getHeapSize(); ++i) {
                int oldBucketOffset = LimitedBufferHashGrouper.this.offsetHeap.getAt(i);
                if (!this.isOffsetUsed(oldBucketOffset)) continue;
                entryBuffer.limit(oldBucketOffset + this.bucketSizeWithHash);
                entryBuffer.position(oldBucketOffset);
                keyBuffer.limit(entryBuffer.position() + 4 + this.keySize);
                keyBuffer.position(entryBuffer.position() + 4);
                int keyHash = entryBuffer.getInt(entryBuffer.position()) & Integer.MAX_VALUE;
                int newBucket = this.findBucket(true, this.maxBuckets, newTableBuffer, keyBuffer, keyHash);
                if (newBucket < 0) {
                    throw new ISE("Couldn't find a bucket while resizing", new Object[0]);
                }
                int newBucketOffset = newBucket * this.bucketSizeWithHash;
                newTableBuffer.position(newBucketOffset);
                newTableBuffer.put(entryBuffer);
                ++numCopied;
                LimitedBufferHashGrouper.this.offsetHeap.setAt(i, newBucketOffset);
                LimitedBufferHashGrouper.this.aggregators.relocate(oldBucketOffset + LimitedBufferHashGrouper.this.baseAggregatorOffset, newBucketOffset + LimitedBufferHashGrouper.this.baseAggregatorOffset, this.tableBuffer, newTableBuffer);
            }
            this.size = numCopied;
            this.tableBuffer = newTableBuffer;
            ++this.growthCount;
        }
    }

    public static class BufferGrouperOffsetHeapIndexUpdater {
        private ByteBuffer hashTableBuffer;
        private final int indexPosition;

        public BufferGrouperOffsetHeapIndexUpdater(ByteBuffer hashTableBuffer, int indexPosition) {
            this.hashTableBuffer = hashTableBuffer;
            this.indexPosition = indexPosition;
        }

        public void setHashTableBuffer(ByteBuffer newTableBuffer) {
            this.hashTableBuffer = newTableBuffer;
        }

        public void updateHeapIndexForOffset(int bucketOffset, int newHeapIndex) {
            this.hashTableBuffer.putInt(bucketOffset + this.indexPosition, newHeapIndex);
        }

        public int getHeapIndexForOffset(int bucketOffset) {
            return this.hashTableBuffer.getInt(bucketOffset + this.indexPosition);
        }
    }
}

