/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.join.HashJoinSegmentStorageAdapter;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class HashJoinSegment
implements SegmentReference {
    private final SegmentReference baseSegment;
    private final List<JoinableClause> clauses;
    private final JoinFilterPreAnalysis joinFilterPreAnalysis;

    public HashJoinSegment(SegmentReference baseSegment, List<JoinableClause> clauses, JoinFilterPreAnalysis joinFilterPreAnalysis) {
        this.baseSegment = baseSegment;
        this.clauses = clauses;
        this.joinFilterPreAnalysis = joinFilterPreAnalysis;
        if (clauses.isEmpty()) {
            throw new IAE("'clauses' is empty, no need to create HashJoinSegment", new Object[0]);
        }
    }

    @Override
    public SegmentId getId() {
        return this.baseSegment.getId();
    }

    @Override
    public Interval getDataInterval() {
        return this.baseSegment.getDataInterval();
    }

    @Override
    @Nullable
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    public StorageAdapter asStorageAdapter() {
        return new HashJoinSegmentStorageAdapter(this.baseSegment.asStorageAdapter(), this.clauses, this.joinFilterPreAnalysis);
    }

    @Override
    public void close() throws IOException {
        this.baseSegment.close();
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        Closer closer = Closer.create();
        try {
            boolean acquireFailed = this.baseSegment.acquireReferences().map(closeable -> {
                closer.register(closeable);
                return false;
            }).orElse(true);
            for (JoinableClause joinClause : this.clauses) {
                if (acquireFailed) break;
                acquireFailed |= joinClause.acquireReferences().map(closeable -> {
                    closer.register(closeable);
                    return false;
                }).orElse(true).booleanValue();
            }
            if (acquireFailed) {
                CloseQuietly.close((Closeable)closer);
                return Optional.empty();
            }
            return Optional.of(closer);
        }
        catch (Exception ex) {
            CloseQuietly.close((Closeable)closer);
            return Optional.empty();
        }
    }
}

