/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.util.SuppressForbidden;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.SimpleDescendingOffset;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.join.Equality;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableColumnSelectorFactory;
import org.apache.druid.segment.join.table.SortedIntIntersectionIterator;

public class IndexedTableJoinMatcher
implements JoinMatcher {
    private static final int UNINITIALIZED_CURRENT_ROW = -1;
    static final ValueType DEFAULT_KEY_TYPE = ValueType.STRING;
    private final IndexedTable table;
    private final List<Supplier<IntIterator>> conditionMatchers;
    private final IntIterator[] currentMatchedRows;
    private final ColumnSelectorFactory selectorFactory;
    private final IntSet matchedRows;
    private boolean matchingRemainder = false;
    @Nullable
    private IntIterator currentIterator;
    private int currentRow;
    private final SimpleSettableOffset joinableOffset;

    IndexedTableJoinMatcher(IndexedTable table, ColumnSelectorFactory leftSelectorFactory, JoinConditionAnalysis condition, boolean remainderNeeded, boolean descending, Closer closer) {
        this.table = table;
        this.joinableOffset = descending ? new SimpleDescendingOffset(table.numRows()) : new SimpleAscendingOffset(table.numRows());
        this.reset();
        if (condition.isAlwaysTrue()) {
            this.conditionMatchers = Collections.singletonList(() -> IntIterators.fromTo((int)0, (int)table.numRows()));
        } else if (condition.isAlwaysFalse()) {
            this.conditionMatchers = Collections.singletonList(() -> IntIterators.EMPTY_ITERATOR);
        } else if (condition.getNonEquiConditions().isEmpty()) {
            this.conditionMatchers = condition.getEquiConditions().stream().map(eq -> IndexedTableJoinMatcher.makeConditionMatcher(table, leftSelectorFactory, eq)).collect(Collectors.toCollection(ArrayList::new));
        } else {
            throw new IAE("Cannot build hash-join matcher on non-equi-join condition: %s", new Object[]{condition.getOriginalExpression()});
        }
        this.currentMatchedRows = new IntIterator[this.conditionMatchers.size()];
        ColumnSelectorFactory selectorFactory = table.makeColumnSelectorFactory(this.joinableOffset, descending, closer);
        this.selectorFactory = selectorFactory != null ? selectorFactory : new IndexedTableColumnSelectorFactory(table, () -> this.currentRow, closer);
        this.matchedRows = remainderNeeded ? new IntRBTreeSet() : null;
    }

    private static Supplier<IntIterator> makeConditionMatcher(IndexedTable table, ColumnSelectorFactory selectorFactory, Equality condition) {
        if (!table.keyColumns().contains(condition.getRightColumn())) {
            throw new IAE("Cannot build hash-join matcher on non-key-based condition: %s", new Object[]{condition});
        }
        int keyColumnNumber = table.rowSignature().indexOf(condition.getRightColumn());
        ValueType keyType = table.rowSignature().getColumnType(condition.getRightColumn()).orElse(DEFAULT_KEY_TYPE);
        IndexedTable.Index index = table.columnIndex(keyColumnNumber);
        return ColumnProcessors.makeProcessor(condition.getLeftExpr(), keyType, new ConditionMatcherFactory(keyType, index), selectorFactory);
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return this.selectorFactory;
    }

    @Override
    public void matchCondition() {
        this.reset();
        for (int i = 0; i < this.conditionMatchers.size(); ++i) {
            IntIterator rows = this.conditionMatchers.get(i).get();
            if (!rows.hasNext()) {
                return;
            }
            this.currentMatchedRows[i] = rows;
        }
        this.currentIterator = this.currentMatchedRows.length == 1 ? this.currentMatchedRows[0] : new SortedIntIntersectionIterator(this.currentMatchedRows);
        this.nextMatch();
    }

    @Override
    public void matchRemainder() {
        Preconditions.checkState((this.matchedRows != null ? 1 : 0) != 0, (Object)"matchedRows != null");
        this.currentIterator = new IntIterator(){
            int current = -1;
            {
                this.advanceRemainderIterator();
            }

            public int nextInt() {
                if (this.current >= IndexedTableJoinMatcher.this.table.numRows()) {
                    throw new NoSuchElementException();
                }
                int retVal = this.current;
                this.advanceRemainderIterator();
                return retVal;
            }

            public boolean hasNext() {
                return this.current < IndexedTableJoinMatcher.this.table.numRows();
            }

            private void advanceRemainderIterator() {
                do {
                    ++this.current;
                } while (this.current < IndexedTableJoinMatcher.this.table.numRows() && IndexedTableJoinMatcher.this.matchedRows.contains(this.current));
            }
        };
        this.matchingRemainder = true;
        this.nextMatch();
    }

    @Override
    public boolean matchingRemainder() {
        return this.matchingRemainder;
    }

    @Override
    public boolean hasMatch() {
        return this.currentRow >= 0;
    }

    @Override
    public void nextMatch() {
        this.advanceCurrentRow();
        if (!this.matchingRemainder && this.matchedRows != null && this.hasMatch()) {
            this.matchedRows.add(this.currentRow);
        }
    }

    @Override
    public void reset() {
        this.currentIterator = null;
        this.currentRow = -1;
        this.matchingRemainder = false;
        this.joinableOffset.reset();
    }

    private void advanceCurrentRow() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            this.currentRow = this.currentIterator.nextInt();
        } else {
            this.currentIterator = null;
            this.currentRow = -1;
            this.joinableOffset.setCurrentOffset(this.currentRow);
        }
    }

    @VisibleForTesting
    static class Int2IntListLruCache
    implements Int2IntListMap {
        private final Int2ObjectLinkedOpenHashMap<IntList> cache;
        private final int maxSize;
        private final IntFunction<IntList> loader;

        Int2IntListLruCache(int maxSize, IntFunction<IntList> loader) {
            this.cache = new Int2ObjectLinkedOpenHashMap(maxSize);
            this.maxSize = maxSize;
            this.loader = loader;
        }

        @Override
        public IntList getAndLoadIfAbsent(int key) {
            IntList value = (IntList)this.cache.getAndMoveToFirst(key);
            if (value == null) {
                value = this.loader.apply(key);
                this.cache.putAndMoveToFirst(key, (Object)value);
            }
            if (this.cache.size() > this.maxSize) {
                this.cache.removeLast();
            }
            return value;
        }

        @VisibleForTesting
        IntList get(int key) {
            return (IntList)this.cache.get(key);
        }
    }

    @VisibleForTesting
    static class Int2IntListLookupTable
    implements Int2IntListMap {
        private final IntList[] lookup;
        private final IntFunction<IntList> loader;

        Int2IntListLookupTable(int maxSize, IntFunction<IntList> loader) {
            this.loader = loader;
            this.lookup = new IntList[maxSize];
        }

        @Override
        public IntList getAndLoadIfAbsent(int key) {
            IntList value = this.lookup[key];
            if (value == null) {
                this.lookup[key] = value = this.loader.apply(key);
            }
            return value;
        }
    }

    private static interface Int2IntListMap {
        public IntList getAndLoadIfAbsent(int var1);
    }

    @VisibleForTesting
    static class LruLoadingHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;
        private final Function<K, V> loader;

        @SuppressForbidden(reason="java.util.LinkedHashMap#<init>(int)")
        LruLoadingHashMap(int maxSize, Function<K, V> loader) {
            super(LruLoadingHashMap.capacity(maxSize));
            this.maxSize = maxSize;
            this.loader = loader;
        }

        V getAndLoadIfAbsent(K key) {
            return this.computeIfAbsent(key, this.loader);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }

        private static int capacity(int expectedSize) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
    }

    @VisibleForTesting
    static class ConditionMatcherFactory
    implements ColumnProcessorFactory<Supplier<IntIterator>> {
        @VisibleForTesting
        static final int CACHE_MAX_SIZE = 1000;
        private static final int MAX_NUM_CACHE = 10;
        private final ValueType keyType;
        private final IndexedTable.Index index;
        private final LruLoadingHashMap<DimensionSelector, Int2IntListMap> dimensionCaches;

        ConditionMatcherFactory(ValueType keyType, IndexedTable.Index index) {
            this.keyType = keyType;
            this.index = index;
            this.dimensionCaches = new LruLoadingHashMap<DimensionSelector, Int2IntListMap>(10, selector -> {
                int cardinality = selector.getValueCardinality();
                IntFunction<IntList> loader = dimensionId -> this.getRowNumbers((DimensionSelector)selector, dimensionId);
                return cardinality <= 1000 ? new Int2IntListLookupTable(cardinality, loader) : new Int2IntListLruCache(1000, loader);
            });
        }

        private IntList getRowNumbers(DimensionSelector selector, int dimensionId) {
            String key = selector.lookupName(dimensionId);
            return this.index.find(key);
        }

        private IntList getAndCacheRowNumbers(DimensionSelector selector, int dimensionId) {
            return this.dimensionCaches.getAndLoadIfAbsent(selector).getAndLoadIfAbsent(dimensionId);
        }

        @Override
        public ValueType defaultType() {
            return this.keyType;
        }

        @Override
        public Supplier<IntIterator> makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
            if (selector.getValueCardinality() == -1) {
                return () -> {
                    IndexedInts row = selector.getRow();
                    if (row.size() == 1) {
                        int dimensionId = row.get(0);
                        IntList rowNumbers = this.getRowNumbers(selector, dimensionId);
                        return rowNumbers.iterator();
                    }
                    if (row.size() == 0) {
                        return IntIterators.EMPTY_ITERATOR;
                    }
                    throw new QueryUnsupportedException("Joining against a multi-value dimension is not supported.");
                };
            }
            return () -> {
                IndexedInts row = selector.getRow();
                if (row.size() == 1) {
                    int dimensionId = row.get(0);
                    IntList rowNumbers = this.getAndCacheRowNumbers(selector, dimensionId);
                    return rowNumbers.iterator();
                }
                if (row.size() == 0) {
                    return IntIterators.EMPTY_ITERATOR;
                }
                throw new QueryUnsupportedException("Joining against a multi-value dimension is not supported.");
            };
        }

        @Override
        public Supplier<IntIterator> makeFloatProcessor(BaseFloatColumnValueSelector selector) {
            if (NullHandling.replaceWithDefault()) {
                return () -> this.index.find(Float.valueOf(selector.getFloat())).iterator();
            }
            return () -> selector.isNull() ? IntIterators.EMPTY_ITERATOR : this.index.find(Float.valueOf(selector.getFloat())).iterator();
        }

        @Override
        public Supplier<IntIterator> makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
            if (NullHandling.replaceWithDefault()) {
                return () -> this.index.find(selector.getDouble()).iterator();
            }
            return () -> selector.isNull() ? IntIterators.EMPTY_ITERATOR : this.index.find(selector.getDouble()).iterator();
        }

        @Override
        public Supplier<IntIterator> makeLongProcessor(BaseLongColumnValueSelector selector) {
            if (NullHandling.replaceWithDefault()) {
                return () -> this.index.find(selector.getLong()).iterator();
            }
            return () -> selector.isNull() ? IntIterators.EMPTY_ITERATOR : this.index.find(selector.getLong()).iterator();
        }

        @Override
        public Supplier<IntIterator> makeComplexProcessor(BaseObjectColumnValueSelector<?> selector) {
            return () -> IntIterators.EMPTY_ITERATOR;
        }
    }
}

