/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.column.ValueType;

public class ExpressionPlan {
    private final Expr expression;
    private final Expr.BindingAnalysis analysis;
    private final EnumSet<Trait> traits;
    @Nullable
    private final ExprType outputType;
    @Nullable
    private final ValueType singleInputType;
    private final Set<String> unknownInputs;
    private final List<String> unappliedInputs;

    ExpressionPlan(Expr expression, Expr.BindingAnalysis analysis, EnumSet<Trait> traits, @Nullable ExprType outputType, @Nullable ValueType singleInputType, Set<String> unknownInputs, List<String> unappliedInputs) {
        this.expression = expression;
        this.analysis = analysis;
        this.traits = traits;
        this.outputType = outputType;
        this.singleInputType = singleInputType;
        this.unknownInputs = unknownInputs;
        this.unappliedInputs = unappliedInputs;
    }

    public boolean isConstant() {
        return this.analysis.getRequiredBindings().isEmpty();
    }

    public Expr getExpression() {
        return this.expression;
    }

    public Expr getAppliedExpression() {
        if (this.is(Trait.NEEDS_APPLIED)) {
            return Parser.applyUnappliedBindings((Expr)this.expression, (Expr.BindingAnalysis)this.analysis, this.unappliedInputs);
        }
        return this.expression;
    }

    public Expr.BindingAnalysis getAnalysis() {
        return this.analysis;
    }

    public boolean is(Trait ... flags) {
        return ExpressionPlan.is(this.traits, flags);
    }

    public boolean any(Trait ... flags) {
        return ExpressionPlan.any(this.traits, flags);
    }

    @Nullable
    public ExprType getOutputType() {
        return this.outputType;
    }

    @Nullable
    public ValueType getSingleInputType() {
        return this.singleInputType;
    }

    public String getSingleInputName() {
        return (String)Iterables.getOnlyElement((Iterable)this.analysis.getRequiredBindings());
    }

    public Set<String> getUnknownInputs() {
        return this.unknownInputs;
    }

    static boolean is(EnumSet<Trait> traits, Trait ... args) {
        return Arrays.stream(args).allMatch(traits::contains);
    }

    static boolean any(EnumSet<Trait> traits, Trait ... args) {
        return Arrays.stream(args).anyMatch(traits::contains);
    }

    static boolean none(EnumSet<Trait> traits, Trait ... args) {
        return Arrays.stream(args).noneMatch(traits::contains);
    }

    public static enum Trait {
        CONSTANT,
        SINGLE_INPUT_SCALAR,
        SINGLE_INPUT_MAPPABLE,
        NEEDS_APPLIED,
        UNKNOWN_INPUTS,
        NON_SCALAR_INPUTS,
        NON_SCALAR_OUTPUT,
        VECTORIZABLE;

    }
}

