/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorSizeInspector;
import org.apache.druid.segment.vector.VectorValueSelector;

class ExpressionVectorInputBinding
implements Expr.VectorInputBinding {
    private final Map<String, VectorValueSelector> numeric = new HashMap<String, VectorValueSelector>();
    private final Map<String, VectorObjectSelector> objects = new HashMap<String, VectorObjectSelector>();
    private final Map<String, ExprType> types = new HashMap<String, ExprType>();
    private final NilVectorSelector nilSelector;
    private final VectorSizeInspector sizeInspector;

    public ExpressionVectorInputBinding(VectorSizeInspector sizeInspector) {
        this.sizeInspector = sizeInspector;
        this.nilSelector = NilVectorSelector.create(sizeInspector);
    }

    public ExpressionVectorInputBinding addNumeric(String name, ExprType type, VectorValueSelector selector) {
        this.numeric.put(name, selector);
        this.types.put(name, type);
        return this;
    }

    public ExpressionVectorInputBinding addObjectSelector(String name, ExprType type, VectorObjectSelector selector) {
        this.objects.put(name, selector);
        this.types.put(name, type);
        return this;
    }

    public <T> T[] getObjectVector(String name) {
        return this.objects.getOrDefault(name, this.nilSelector).getObjectVector();
    }

    public ExprType getType(String name) {
        return this.types.get(name);
    }

    public long[] getLongVector(String name) {
        return this.numeric.getOrDefault(name, this.nilSelector).getLongVector();
    }

    public double[] getDoubleVector(String name) {
        return this.numeric.getOrDefault(name, this.nilSelector).getDoubleVector();
    }

    @Nullable
    public boolean[] getNullVector(String name) {
        return this.numeric.getOrDefault(name, this.nilSelector).getNullVector();
    }

    public int getMaxVectorSize() {
        return this.sizeInspector.getMaxVectorSize();
    }

    public int getCurrentVectorSize() {
        return this.sizeInspector.getCurrentVectorSize();
    }
}

