/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.query.expression.ExprUtils;

public class RegexpLikeExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "regexp_like";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        if (args.size() != 2) {
            throw new IAE("Function[%s] must have 2 arguments", new Object[]{this.name()});
        }
        Expr arg = args.get(0);
        Expr patternExpr = args.get(1);
        if (!ExprUtils.isStringLiteral(patternExpr)) {
            throw new IAE("Function[%s] pattern must be a string literal", new Object[]{this.name()});
        }
        Pattern pattern = Pattern.compile(StringUtils.nullToEmptyNonDruidDataString((String)((String)patternExpr.getLiteralValue())));
        class RegexpLikeExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            final /* synthetic */ Pattern val$pattern;
            final /* synthetic */ Expr val$patternExpr;

            RegexpLikeExpr(Expr arg) {
                this.val$pattern = pattern;
                this.val$patternExpr = expr;
                super(RegexpLikeExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                String s = NullHandling.nullToEmptyIfNeeded((String)this.arg.eval(bindings).asString());
                if (s == null) {
                    return ExprEval.ofLongBoolean((boolean)false);
                }
                Matcher matcher = this.val$pattern.matcher(s);
                return ExprEval.ofLongBoolean((boolean)matcher.find());
            }

            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit((Expr)new RegexpLikeExpr(newArg));
            }

            @Nullable
            public ExprType getOutputType(Expr.InputBindingTypes inputTypes) {
                return ExprType.LONG;
            }

            public String stringify() {
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{RegexpLikeExprMacro.FN_NAME, this.arg.stringify(), this.val$patternExpr.stringify()});
            }
        }
        return new RegexpLikeExpr(arg);
    }
}

