/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;

public class SingleValueStringGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private final SingleValueDimensionVectorSelector selector;

    SingleValueStringGroupByVectorColumnSelector(SingleValueDimensionVectorSelector selector) {
        this.selector = selector;
    }

    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    @Override
    public void writeKeys(WritableMemory keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        int[] vector = this.selector.getRowVector();
        if (keySize == 4) {
            keySpace.putIntArray((long)keyOffset, vector, startRow, endRow - startRow);
        } else {
            int i = startRow;
            int j = keyOffset;
            while (i < endRow) {
                keySpace.putInt((long)j, vector[i]);
                ++i;
                j += keySize;
            }
        }
    }

    @Override
    public void writeKeyToResultRow(Memory keyMemory, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        int id = keyMemory.getInt((long)keyOffset);
        resultRow.set(resultRowPosition, this.selector.lookupName(id));
    }
}

