/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.scan.ScanResultValueTimestampComparator;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.VirtualColumns;

public class ScanQuery
extends BaseQuery<ScanResultValue> {
    public static final String CTX_KEY_OUTERMOST = "scanOutermost";
    private final VirtualColumns virtualColumns;
    private final ResultFormat resultFormat;
    private final int batchSize;
    private final long scanRowsOffset;
    private final long scanRowsLimit;
    private final DimFilter dimFilter;
    private final List<String> columns;
    private final Boolean legacy;
    private final Order order;
    private final Integer maxRowsQueuedForOrdering;
    private final Integer maxSegmentPartitionsOrderedInMemory;

    @JsonCreator
    public ScanQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="resultFormat") ResultFormat resultFormat, @JsonProperty(value="batchSize") int batchSize, @JsonProperty(value="offset") long scanRowsOffset, @JsonProperty(value="limit") long scanRowsLimit, @JsonProperty(value="order") Order order, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="legacy") Boolean legacy, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, false, context);
        this.virtualColumns = VirtualColumns.nullToEmpty(virtualColumns);
        this.resultFormat = resultFormat == null ? ResultFormat.RESULT_FORMAT_LIST : resultFormat;
        this.batchSize = batchSize == 0 ? 20480 : batchSize;
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"batchSize must be greater than 0");
        this.scanRowsOffset = scanRowsOffset;
        Preconditions.checkArgument((this.scanRowsOffset >= 0L ? 1 : 0) != 0, (Object)"offset must be greater than or equal to 0");
        this.scanRowsLimit = scanRowsLimit == 0L ? Long.MAX_VALUE : scanRowsLimit;
        Preconditions.checkArgument((this.scanRowsLimit > 0L ? 1 : 0) != 0, (Object)"limit must be greater than 0");
        this.dimFilter = dimFilter;
        this.columns = columns;
        this.legacy = legacy;
        Order order2 = this.order = order == null ? Order.NONE : order;
        if (this.order != Order.NONE) {
            Preconditions.checkArgument((columns == null || columns.size() == 0 || columns.contains("__time") ? 1 : 0) != 0, (Object)"The __time column must be selected if the results are time-ordered.");
        }
        this.maxRowsQueuedForOrdering = this.validateAndGetMaxRowsQueuedForOrdering();
        this.maxSegmentPartitionsOrderedInMemory = this.validateAndGetMaxSegmentPartitionsOrderedInMemory();
    }

    private Integer validateAndGetMaxRowsQueuedForOrdering() {
        Integer maxRowsQueuedForOrdering = this.getContextValue("maxRowsQueuedForOrdering", null);
        Preconditions.checkArgument((maxRowsQueuedForOrdering == null || maxRowsQueuedForOrdering > 0 ? 1 : 0) != 0, (Object)"maxRowsQueuedForOrdering must be greater than 0");
        return maxRowsQueuedForOrdering;
    }

    private Integer validateAndGetMaxSegmentPartitionsOrderedInMemory() {
        Integer maxSegmentPartitionsOrderedInMemory = this.getContextValue("maxSegmentPartitionsOrderedInMemory", null);
        Preconditions.checkArgument((maxSegmentPartitionsOrderedInMemory == null || maxSegmentPartitionsOrderedInMemory > 0 ? 1 : 0) != 0, (Object)"maxRowsQueuedForOrdering must be greater than 0");
        return maxSegmentPartitionsOrderedInMemory;
    }

    @Override
    @JsonProperty
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    @JsonProperty
    public int getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="offset")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public long getScanRowsOffset() {
        return this.scanRowsOffset;
    }

    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ScanRowsLimitJsonIncludeFilter.class)
    public long getScanRowsLimit() {
        return this.scanRowsLimit;
    }

    public boolean isLimited() {
        return this.scanRowsLimit != Long.MAX_VALUE;
    }

    @JsonProperty
    public Order getOrder() {
        return this.order;
    }

    @Nullable
    @JsonIgnore
    public Integer getMaxRowsQueuedForOrdering() {
        return this.maxRowsQueuedForOrdering;
    }

    @Nullable
    @JsonIgnore
    public Integer getMaxSegmentPartitionsOrderedInMemory() {
        return this.maxSegmentPartitionsOrderedInMemory;
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    @JsonProperty
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "scan";
    }

    @JsonProperty
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Boolean isLegacy() {
        return this.legacy;
    }

    @Override
    public Ordering<ScanResultValue> getResultOrdering() {
        if (this.order == Order.NONE) {
            return Ordering.natural();
        }
        return Ordering.from(new ScanResultValueTimestampComparator(this).thenComparing(this.order == Order.ASCENDING ? Comparator.naturalOrder() : Comparator.naturalOrder().reversed()));
    }

    public ScanQuery withOffset(long newOffset) {
        return Druids.ScanQueryBuilder.copy(this).offset(newOffset).build();
    }

    public ScanQuery withLimit(long newLimit) {
        return Druids.ScanQueryBuilder.copy(this).limit(newLimit).build();
    }

    public ScanQuery withNonNullLegacy(ScanQueryConfig scanQueryConfig) {
        return Druids.ScanQueryBuilder.copy(this).legacy(this.legacy != null ? this.legacy.booleanValue() : scanQueryConfig.isLegacy()).build();
    }

    @Override
    public Query<ScanResultValue> withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return Druids.ScanQueryBuilder.copy(this).intervals(querySegmentSpec).build();
    }

    @Override
    public Query<ScanResultValue> withDataSource(DataSource dataSource) {
        return Druids.ScanQueryBuilder.copy(this).dataSource(dataSource).build();
    }

    @Override
    public Query<ScanResultValue> withOverriddenContext(Map<String, Object> contextOverrides) {
        return Druids.ScanQueryBuilder.copy(this).context(ScanQuery.computeOverriddenContext(this.getContext(), contextOverrides)).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScanQuery scanQuery = (ScanQuery)o;
        return this.batchSize == scanQuery.batchSize && this.scanRowsOffset == scanQuery.scanRowsOffset && this.scanRowsLimit == scanQuery.scanRowsLimit && Objects.equals(this.legacy, scanQuery.legacy) && Objects.equals(this.virtualColumns, scanQuery.virtualColumns) && Objects.equals((Object)this.resultFormat, (Object)scanQuery.resultFormat) && Objects.equals(this.dimFilter, scanQuery.dimFilter) && Objects.equals(this.columns, scanQuery.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.virtualColumns, this.resultFormat, this.batchSize, this.scanRowsOffset, this.scanRowsLimit, this.dimFilter, this.columns, this.legacy});
    }

    public String toString() {
        return "ScanQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", virtualColumns=" + this.getVirtualColumns() + ", resultFormat='" + (Object)((Object)this.resultFormat) + '\'' + ", batchSize=" + this.batchSize + ", offset=" + this.scanRowsOffset + ", limit=" + this.scanRowsLimit + ", dimFilter=" + this.dimFilter + ", columns=" + this.columns + ", legacy=" + this.legacy + '}';
    }

    static class ScanRowsLimitJsonIncludeFilter {
        ScanRowsLimitJsonIncludeFilter() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() == this.getClass()) {
                return true;
            }
            return obj instanceof Long && (Long)obj == Long.MAX_VALUE;
        }
    }

    public static enum Order {
        ASCENDING,
        DESCENDING,
        NONE;


        @JsonValue
        public String toString() {
            return StringUtils.toLowerCase((String)this.name());
        }

        @JsonCreator
        public static Order fromString(String name) {
            return Order.valueOf(StringUtils.toUpperCase((String)name));
        }
    }

    public static enum ResultFormat {
        RESULT_FORMAT_LIST,
        RESULT_FORMAT_COMPACTED_LIST,
        RESULT_FORMAT_VALUE_VECTOR;


        @JsonValue
        public String toString() {
            switch (this) {
                case RESULT_FORMAT_LIST: {
                    return "list";
                }
                case RESULT_FORMAT_COMPACTED_LIST: {
                    return "compactedList";
                }
                case RESULT_FORMAT_VALUE_VECTOR: {
                    return "valueVector";
                }
            }
            return "";
        }

        @JsonCreator
        public static ResultFormat fromString(String name) {
            switch (name) {
                case "compactedList": {
                    return RESULT_FORMAT_COMPACTED_LIST;
                }
                case "valueVector": {
                    return RESULT_FORMAT_VALUE_VECTOR;
                }
                case "list": {
                    return RESULT_FORMAT_LIST;
                }
            }
            throw new UOE("Scan query result format [%s] is not supported.", new Object[]{name});
        }
    }
}

