/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn.types;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.druid.query.topn.types.DoubleTopNColumnAggregatesProcessor;
import org.apache.druid.query.topn.types.FloatTopNColumnAggregatesProcessor;
import org.apache.druid.query.topn.types.LongTopNColumnAggregatesProcessor;
import org.apache.druid.query.topn.types.StringTopNColumnAggregatesProcessor;
import org.apache.druid.query.topn.types.TopNColumnAggregatesProcessor;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;

public class TopNColumnAggregatesProcessorFactory
implements ColumnSelectorStrategyFactory<TopNColumnAggregatesProcessor<?>> {
    private final ValueType dimensionType;

    public TopNColumnAggregatesProcessorFactory(ValueType dimensionType) {
        this.dimensionType = (ValueType)Preconditions.checkNotNull((Object)dimensionType, (Object)"dimensionType");
    }

    @Override
    public TopNColumnAggregatesProcessor<?> makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
        ValueType selectorType = capabilities.getType();
        if (selectorType.equals((Object)ValueType.STRING)) {
            return new StringTopNColumnAggregatesProcessor(this.dimensionType);
        }
        if (selectorType.isNumeric()) {
            ValueType strategyType;
            Function<Object, Comparable<?>> converter;
            if (ValueType.isNumeric((ValueType)this.dimensionType)) {
                converter = DimensionHandlerUtils.converterFromTypeToType(this.dimensionType, this.dimensionType);
                strategyType = this.dimensionType;
            } else {
                converter = DimensionHandlerUtils.converterFromTypeToType(selectorType, this.dimensionType);
                strategyType = selectorType;
            }
            switch (strategyType) {
                case LONG: {
                    return new LongTopNColumnAggregatesProcessor(converter);
                }
                case FLOAT: {
                    return new FloatTopNColumnAggregatesProcessor(converter);
                }
                case DOUBLE: {
                    return new DoubleTopNColumnAggregatesProcessor(converter);
                }
            }
        }
        throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{selectorType});
    }
}

