/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.ConstantValueMatcherFactory;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.PredicateValueMatcherFactory;
import org.apache.druid.segment.filter.cnf.CalciteCnfHelper;
import org.apache.druid.segment.filter.cnf.HiveCnfHelper;
import org.apache.druid.segment.join.filter.AllNullColumnSelectorFactory;

public class Filters {
    private static final ColumnSelectorFactory ALL_NULL_COLUMN_SELECTOR_FACTORY = new AllNullColumnSelectorFactory();

    public static Set<Filter> toFilters(List<DimFilter> dimFilters) {
        return dimFilters.stream().map(DimFilter::toFilter).collect(Collectors.toSet());
    }

    @Nullable
    public static Filter toFilter(@Nullable DimFilter dimFilter) {
        return dimFilter == null ? null : dimFilter.toOptimizedFilter();
    }

    public static ValueMatcher makeValueMatcher(ColumnSelectorFactory columnSelectorFactory, String columnName, String value) {
        return ColumnProcessors.makeProcessor(columnName, new ConstantValueMatcherFactory(value), columnSelectorFactory);
    }

    public static ValueMatcher makeValueMatcher(ColumnSelectorFactory columnSelectorFactory, String columnName, DruidPredicateFactory predicateFactory) {
        return ColumnProcessors.makeProcessor(columnName, new PredicateValueMatcherFactory(predicateFactory), columnSelectorFactory);
    }

    public static ImmutableBitmap allFalse(BitmapIndexSelector selector) {
        return selector.getBitmapFactory().makeEmptyImmutableBitmap();
    }

    public static ImmutableBitmap allTrue(BitmapIndexSelector selector) {
        return selector.getBitmapFactory().complement(selector.getBitmapFactory().makeEmptyImmutableBitmap(), selector.getNumRows());
    }

    public static Iterable<ImmutableBitmap> bitmapsFromIndexes(final IntIterable indexes, final BitmapIndex bitmapIndex) {
        return new Iterable<ImmutableBitmap>(){

            @Override
            public Iterator<ImmutableBitmap> iterator() {
                final IntIterator iterator = indexes.iterator();
                return new Iterator<ImmutableBitmap>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public ImmutableBitmap next() {
                        return bitmapIndex.getBitmap(iterator.nextInt());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> T matchPredicate(String dimension, BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory, Predicate<String> predicate) {
        return bitmapResultFactory.unionDimensionValueBitmaps(Filters.matchPredicateNoUnion(dimension, selector, predicate));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Iterable<ImmutableBitmap> matchPredicateNoUnion(String dimension, BitmapIndexSelector selector, Predicate<String> predicate) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        try (CloseableIndexed<String> dimValues = selector.getDimensionValues(dimension);){
            if (dimValues == null || dimValues.size() == 0) {
                ImmutableList immutableList = ImmutableList.of((Object)(predicate.apply(null) ? Filters.allTrue(selector) : Filters.allFalse(selector)));
                return immutableList;
            }
            BitmapIndex bitmapIndex = selector.getBitmapIndex(dimension);
            Iterable<ImmutableBitmap> iterable = Filters.makePredicateQualifyingBitmapIterable(bitmapIndex, predicate, dimValues);
            return iterable;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static double estimateSelectivity(String dimension, BitmapIndexSelector indexSelector, Predicate<String> predicate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static double estimateSelectivity(BitmapIndex bitmapIndex, IntList bitmaps, long totalNumRows) {
        long numMatchedRows = 0L;
        for (int i = 0; i < bitmaps.size(); ++i) {
            ImmutableBitmap bitmap = bitmapIndex.getBitmap(bitmaps.getInt(i));
            numMatchedRows += (long)bitmap.size();
        }
        return Math.min(1.0, (double)numMatchedRows / (double)totalNumRows);
    }

    public static double estimateSelectivity(Iterator<ImmutableBitmap> bitmaps, long totalNumRows) {
        long numMatchedRows = 0L;
        while (bitmaps.hasNext()) {
            ImmutableBitmap bitmap = bitmaps.next();
            numMatchedRows += (long)bitmap.size();
        }
        return Math.min(1.0, (double)numMatchedRows / (double)totalNumRows);
    }

    private static Iterable<ImmutableBitmap> makePredicateQualifyingBitmapIterable(BitmapIndex bitmapIndex, Predicate<String> predicate, Indexed<String> dimValues) {
        return Filters.bitmapsFromIndexes(Filters.makePredicateQualifyingIndexIterable(bitmapIndex, predicate, dimValues), bitmapIndex);
    }

    private static IntIterable makePredicateQualifyingIndexIterable(final BitmapIndex bitmapIndex, final Predicate<String> predicate, final Indexed<String> dimValues) {
        return new IntIterable(){

            public IntIterator iterator() {
                return new IntIterator(){
                    private final int bitmapIndexCardinality;
                    private int nextIndex;
                    private int found;
                    {
                        this.bitmapIndexCardinality = bitmapIndex.getCardinality();
                        this.nextIndex = 0;
                        this.found = this.findNextIndex();
                    }

                    private int findNextIndex() {
                        while (this.nextIndex < this.bitmapIndexCardinality && !predicate.apply(dimValues.get(this.nextIndex))) {
                            ++this.nextIndex;
                        }
                        if (this.nextIndex < this.bitmapIndexCardinality) {
                            return this.nextIndex++;
                        }
                        return -1;
                    }

                    public boolean hasNext() {
                        return this.found != -1;
                    }

                    public int nextInt() {
                        int foundIndex = this.found;
                        if (foundIndex == -1) {
                            throw new NoSuchElementException();
                        }
                        this.found = this.findNextIndex();
                        return foundIndex;
                    }
                };
            }
        };
    }

    public static boolean supportsSelectivityEstimation(Filter filter, String dimension, ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        ColumnHolder columnHolder;
        if (filter.supportsBitmapIndex(indexSelector) && (columnHolder = columnSelector.getColumnHolder(dimension)) != null) {
            return columnHolder.getCapabilities().hasMultipleValues().isFalse();
        }
        return false;
    }

    @Nullable
    public static Filter convertToCNFFromQueryContext(Query query, @Nullable Filter filter) {
        if (filter == null) {
            return null;
        }
        boolean useCNF = query.getContextBoolean("useFilterCNF", false);
        return useCNF ? Filters.toCnf(filter) : filter;
    }

    public static Filter toCnf(Filter current) {
        current = HiveCnfHelper.pushDownNot(current);
        current = HiveCnfHelper.flatten(current);
        current = CalciteCnfHelper.pull(current);
        current = HiveCnfHelper.convertToCnf(current);
        current = HiveCnfHelper.flatten(current);
        return current;
    }

    public static boolean shouldUseBitmapIndex(Filter filter, BitmapIndexSelector indexSelector, @Nullable FilterTuning filterTuning) {
        FilterTuning tuning;
        FilterTuning filterTuning2 = tuning = filterTuning != null ? filterTuning : FilterTuning.createDefault(filter, indexSelector);
        if (filter.supportsBitmapIndex(indexSelector) && tuning.getUseBitmapIndex()) {
            return filter.getRequiredColumns().stream().allMatch(column -> {
                BitmapIndex index = indexSelector.getBitmapIndex((String)column);
                Preconditions.checkNotNull((Object)index, (Object)"Column does not have a bitmap index");
                int cardinality = index.getCardinality();
                return cardinality >= tuning.getMinCardinalityToUseBitmapIndex() && cardinality <= tuning.getMaxCardinalityToUseBitmapIndex();
            });
        }
        return false;
    }

    @Nullable
    public static Filter and(List<Filter> filterList) {
        if (filterList.isEmpty()) {
            return null;
        }
        if (filterList.size() == 1) {
            return filterList.get(0);
        }
        return new AndFilter(filterList);
    }

    @Nullable
    public static Filter or(Set<Filter> filterSet) {
        if (filterSet.isEmpty()) {
            return null;
        }
        if (filterSet.size() == 1) {
            return filterSet.iterator().next();
        }
        return new OrFilter(filterSet);
    }

    public static Set<Filter> toNormalizedOrClauses(Filter filter) {
        Filter normalizedFilter = Filters.toCnf(filter);
        Set<Filter> normalizedOrClauses = normalizedFilter instanceof AndFilter ? ((AndFilter)normalizedFilter).getFilters() : Collections.singleton(normalizedFilter);
        return normalizedOrClauses;
    }

    public static boolean filterMatchesNull(Filter filter) {
        ValueMatcher valueMatcher = filter.makeMatcher(ALL_NULL_COLUMN_SELECTOR_FACTORY);
        return valueMatcher.matches();
    }
}

