/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.PossiblyNullColumnValueSelector;
import org.apache.druid.segment.join.PossiblyNullDimensionSelector;
import org.joda.time.DateTime;

public class HashJoinEngine {
    private HashJoinEngine() {
    }

    public static Cursor makeJoinCursor(final Cursor leftCursor, final JoinableClause joinableClause, boolean descending, Closer closer) {
        final ColumnSelectorFactory leftColumnSelectorFactory = leftCursor.getColumnSelectorFactory();
        final JoinMatcher joinMatcher = joinableClause.getJoinable().makeJoinMatcher(leftColumnSelectorFactory, joinableClause.getCondition(), joinableClause.getJoinType().isRighty(), descending, closer);
        class JoinColumnSelectorFactory
        implements ColumnSelectorFactory {
            JoinColumnSelectorFactory() {
            }

            @Override
            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                if (joinableClause.includesColumn(dimensionSpec.getDimension())) {
                    return joinMatcher.getColumnSelectorFactory().makeDimensionSelector(dimensionSpec.withDimension(joinableClause.unprefix(dimensionSpec.getDimension())));
                }
                DimensionSelector leftSelector = leftColumnSelectorFactory.makeDimensionSelector(dimensionSpec);
                if (!joinableClause.getJoinType().isRighty()) {
                    return leftSelector;
                }
                return new PossiblyNullDimensionSelector(leftSelector, joinMatcher::matchingRemainder);
            }

            @Override
            public ColumnValueSelector makeColumnValueSelector(String column) {
                if (joinableClause.includesColumn(column)) {
                    return joinMatcher.getColumnSelectorFactory().makeColumnValueSelector(joinableClause.unprefix(column));
                }
                ColumnValueSelector leftSelector = leftColumnSelectorFactory.makeColumnValueSelector(column);
                if (!joinableClause.getJoinType().isRighty()) {
                    return leftSelector;
                }
                return new PossiblyNullColumnValueSelector(leftSelector, joinMatcher::matchingRemainder);
            }

            @Override
            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                if (joinableClause.includesColumn(column)) {
                    return joinMatcher.getColumnSelectorFactory().getColumnCapabilities(joinableClause.unprefix(column));
                }
                return leftColumnSelectorFactory.getColumnCapabilities(column);
            }
        }
        final JoinColumnSelectorFactory joinColumnSelectorFactory = new JoinColumnSelectorFactory();
        class JoinCursor
        implements Cursor {
            JoinCursor() {
            }

            public void initialize() {
                this.matchCurrentPosition();
                if (!joinableClause.getJoinType().isLefty()) {
                    while (!joinMatcher.hasMatch() && !this.isDone()) {
                        this.advance();
                        this.matchCurrentPosition();
                    }
                }
            }

            @Override
            @Nonnull
            public ColumnSelectorFactory getColumnSelectorFactory() {
                return joinColumnSelectorFactory;
            }

            @Override
            @Nonnull
            public DateTime getTime() {
                return leftCursor.getTime();
            }

            @Override
            public void advance() {
                this.advanceUninterruptibly();
                BaseQuery.checkInterrupted();
            }

            private void matchCurrentPosition() {
                if (leftCursor.isDone()) {
                    if (joinableClause.getJoinType().isRighty() && !joinMatcher.matchingRemainder()) {
                        joinMatcher.matchRemainder();
                    }
                } else {
                    joinMatcher.matchCondition();
                }
            }

            @Override
            public void advanceUninterruptibly() {
                if (joinMatcher.hasMatch()) {
                    joinMatcher.nextMatch();
                    if (joinMatcher.hasMatch()) {
                        return;
                    }
                }
                assert (!joinMatcher.hasMatch());
                do {
                    leftCursor.advanceUninterruptibly();
                    this.matchCurrentPosition();
                } while (!joinableClause.getJoinType().isLefty() && !joinMatcher.hasMatch() && !leftCursor.isDone());
            }

            @Override
            public boolean isDone() {
                return leftCursor.isDone() && !joinMatcher.hasMatch();
            }

            @Override
            public boolean isDoneOrInterrupted() {
                return this.isDone() || Thread.currentThread().isInterrupted();
            }

            @Override
            public void reset() {
                leftCursor.reset();
                joinMatcher.reset();
            }
        }
        JoinCursor joinCursor = new JoinCursor();
        joinCursor.initialize();
        return joinCursor;
    }
}

