/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexColumnSelectorFactory;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;

public class BroadcastSegmentIndexedTable
implements IndexedTable {
    private static final Logger LOG = new Logger(BroadcastSegmentIndexedTable.class);
    private final QueryableIndexSegment segment;
    private final QueryableIndexStorageAdapter adapter;
    private final QueryableIndex queryableIndex;
    private final Set<String> keyColumns;
    private final RowSignature rowSignature;
    private final String version;
    private final List<Map<Object, IntList>> keyColumnsIndex;

    public BroadcastSegmentIndexedTable(QueryableIndexSegment theSegment, Set<String> keyColumns, String version) {
        this.keyColumns = keyColumns;
        this.version = version;
        this.segment = (QueryableIndexSegment)Preconditions.checkNotNull((Object)theSegment, (Object)"Segment must not be null");
        this.adapter = (QueryableIndexStorageAdapter)Preconditions.checkNotNull((Object)((QueryableIndexStorageAdapter)this.segment.asStorageAdapter()), (String)"Segment[%s] must have a QueryableIndexStorageAdapter", (Object[])new Object[]{this.segment.getId()});
        this.queryableIndex = (QueryableIndex)Preconditions.checkNotNull((Object)this.segment.asQueryableIndex(), (String)"Segment[%s] must have a QueryableIndexSegment", (Object[])new Object[]{this.segment.getId()});
        RowSignature.Builder sigBuilder = RowSignature.builder();
        sigBuilder.add("__time", ValueType.LONG);
        for (String column : this.queryableIndex.getColumnNames()) {
            sigBuilder.add(column, this.adapter.getColumnCapabilities(column).getType());
        }
        this.rowSignature = sigBuilder.build();
        this.keyColumnsIndex = new ArrayList<Map<Object, IntList>>(this.rowSignature.size());
        ArrayList<String> keyColumnNames = new ArrayList<String>(keyColumns.size());
        for (int i = 0; i < this.rowSignature.size(); ++i) {
            HashMap m;
            String columnName = this.rowSignature.getColumnName(i);
            if (keyColumns.contains(columnName)) {
                m = new HashMap();
                keyColumnNames.add(columnName);
            } else {
                m = null;
            }
            this.keyColumnsIndex.add(m);
        }
        Sequence<Cursor> cursors = this.adapter.makeCursors(Filters.toFilter(null), this.queryableIndex.getDataInterval().withChronology((Chronology)ISOChronology.getInstanceUTC()), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        Sequence sequence = Sequences.map(cursors, cursor -> {
            if (cursor == null) {
                return 0;
            }
            int rowNumber = 0;
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            List selectors = keyColumnNames.stream().map(columnName -> {
                if (this.adapter.getColumnCapabilities((String)columnName).hasMultipleValues().isMaybeTrue()) {
                    return NilColumnValueSelector.instance();
                }
                return columnSelectorFactory.makeColumnValueSelector((String)columnName);
            }).collect(Collectors.toList());
            while (!cursor.isDone()) {
                for (int keyColumnSelectorIndex = 0; keyColumnSelectorIndex < selectors.size(); ++keyColumnSelectorIndex) {
                    String keyColumnName = (String)keyColumnNames.get(keyColumnSelectorIndex);
                    int columnPosition = this.rowSignature.indexOf(keyColumnName);
                    Map<Object, IntList> keyColumnValueIndex = this.keyColumnsIndex.get(columnPosition);
                    Object key = ((BaseObjectColumnValueSelector)selectors.get(keyColumnSelectorIndex)).getObject();
                    if (key == null) continue;
                    IntList array = keyColumnValueIndex.computeIfAbsent(key, k -> new IntArrayList());
                    array.add(rowNumber);
                }
                if (rowNumber % 100000 == 0) {
                    if (rowNumber == 0) {
                        LOG.debug("Indexed first row for table %s", new Object[]{theSegment.getId()});
                    } else {
                        LOG.debug("Indexed row %s for table %s", new Object[]{rowNumber, theSegment.getId()});
                    }
                }
                ++rowNumber;
                cursor.advance();
            }
            return rowNumber;
        });
        Integer totalRows = (Integer)sequence.accumulate((Object)0, (accumulated, in) -> {
            accumulated = accumulated + in;
            return accumulated;
        });
        LOG.info("Created BroadcastSegmentIndexedTable with %s rows.", new Object[]{totalRows});
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public Set<String> keyColumns() {
        return this.keyColumns;
    }

    @Override
    public RowSignature rowSignature() {
        return this.rowSignature;
    }

    @Override
    public int numRows() {
        return this.adapter.getNumRows();
    }

    @Override
    public IndexedTable.Index columnIndex(int column) {
        return RowBasedIndexedTable.getKeyColumnIndex(column, this.keyColumnsIndex, this.rowSignature);
    }

    @Override
    public IndexedTable.Reader columnReader(int column) {
        if (!this.rowSignature.contains(column)) {
            throw new IAE("Column[%d] is not a valid column for segment[%s]", new Object[]{column, this.segment.getId()});
        }
        final SimpleAscendingOffset offset = new SimpleAscendingOffset(this.adapter.getNumRows());
        final BaseColumn baseColumn = this.queryableIndex.getColumnHolder(this.rowSignature.getColumnName(column)).getColumn();
        final ColumnValueSelector<?> selector = baseColumn.makeColumnValueSelector(offset);
        return new IndexedTable.Reader(){

            @Override
            @Nullable
            public Object read(int row) {
                offset.setCurrentOffset(row);
                return selector.getObject();
            }

            @Override
            public void close() throws IOException {
                baseColumn.close();
            }
        };
    }

    @Override
    @Nullable
    public ColumnSelectorFactory makeColumnSelectorFactory(ReadableOffset offset, boolean descending, Closer closer) {
        return new QueryableIndexColumnSelectorFactory(this.queryableIndex, VirtualColumns.EMPTY, descending, closer, offset, new HashMap<String, BaseColumn>());
    }

    @Override
    public void close() {
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        return Optional.empty();
    }
}

