/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.ConstantVectorSelectors;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.segment.virtual.ExpressionVectorInputBinding;
import org.apache.druid.segment.virtual.ExpressionVectorObjectSelector;
import org.apache.druid.segment.virtual.ExpressionVectorValueSelector;

public class ExpressionVectorSelectors {
    private ExpressionVectorSelectors() {
    }

    public static SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(VectorColumnSelectorFactory factory, Expr expression) {
        ExpressionPlan plan = ExpressionPlanner.plan(factory, expression);
        Preconditions.checkArgument((boolean)plan.is(ExpressionPlan.Trait.VECTORIZABLE));
        if (plan.isConstant()) {
            String constant = plan.getExpression().eval(ExprUtils.nilBindings()).asString();
            return ConstantVectorSelectors.singleValueDimensionVectorSelector(factory.getVectorSizeInspector(), constant);
        }
        throw new IllegalStateException("Only constant expressions currently support dimension selectors");
    }

    public static VectorValueSelector makeVectorValueSelector(VectorColumnSelectorFactory factory, Expr expression) {
        ExpressionPlan plan = ExpressionPlanner.plan(factory, expression);
        Preconditions.checkArgument((boolean)plan.is(ExpressionPlan.Trait.VECTORIZABLE));
        if (plan.isConstant()) {
            return ConstantVectorSelectors.vectorValueSelector(factory.getVectorSizeInspector(), (Number)plan.getExpression().eval(ExprUtils.nilBindings()).value());
        }
        Expr.VectorInputBinding bindings = ExpressionVectorSelectors.createVectorBindings(plan.getAnalysis(), factory);
        ExprVectorProcessor processor = plan.getExpression().buildVectorized((Expr.VectorInputBindingTypes)bindings);
        return new ExpressionVectorValueSelector(processor, bindings);
    }

    public static VectorObjectSelector makeVectorObjectSelector(VectorColumnSelectorFactory factory, Expr expression) {
        ExpressionPlan plan = ExpressionPlanner.plan(factory, expression);
        Preconditions.checkArgument((boolean)plan.is(ExpressionPlan.Trait.VECTORIZABLE));
        if (plan.isConstant()) {
            return ConstantVectorSelectors.vectorObjectSelector(factory.getVectorSizeInspector(), plan.getExpression().eval(ExprUtils.nilBindings()).value());
        }
        Expr.VectorInputBinding bindings = ExpressionVectorSelectors.createVectorBindings(plan.getAnalysis(), factory);
        ExprVectorProcessor processor = plan.getExpression().buildVectorized((Expr.VectorInputBindingTypes)bindings);
        return new ExpressionVectorObjectSelector(processor, bindings);
    }

    private static Expr.VectorInputBinding createVectorBindings(Expr.BindingAnalysis bindingAnalysis, VectorColumnSelectorFactory vectorColumnSelectorFactory) {
        ExpressionVectorInputBinding binding = new ExpressionVectorInputBinding(vectorColumnSelectorFactory.getVectorSizeInspector());
        List columns = bindingAnalysis.getRequiredBindingsList();
        block4: for (String columnName : columns) {
            ColumnCapabilities columnCapabilities = vectorColumnSelectorFactory.getColumnCapabilities(columnName);
            ValueType nativeType = columnCapabilities != null ? columnCapabilities.getType() : null;
            if (nativeType == null) continue;
            switch (nativeType) {
                case FLOAT: 
                case DOUBLE: {
                    binding.addNumeric(columnName, ExprType.DOUBLE, vectorColumnSelectorFactory.makeValueSelector(columnName));
                    continue block4;
                }
                case LONG: {
                    binding.addNumeric(columnName, ExprType.LONG, vectorColumnSelectorFactory.makeValueSelector(columnName));
                    continue block4;
                }
            }
            binding.addObjectSelector(columnName, ExprType.STRING, vectorColumnSelectorFactory.makeObjectSelector(columnName));
        }
        return binding;
    }
}

