/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;

public class UnionDataSource
implements DataSource {
    @JsonProperty
    private final List<TableDataSource> dataSources;

    @JsonCreator
    public UnionDataSource(@JsonProperty(value="dataSources") List<TableDataSource> dataSources) {
        if (dataSources == null || dataSources.isEmpty()) {
            throw new ISE("'dataSources' must be non-null and non-empty for 'union'", new Object[0]);
        }
        this.dataSources = dataSources;
    }

    @Override
    public Set<String> getTableNames() {
        return this.dataSources.stream().map(input -> (String)Iterables.getOnlyElement(input.getTableNames())).collect(Collectors.toSet());
    }

    @JsonProperty
    public List<TableDataSource> getDataSources() {
        return this.dataSources;
    }

    @Override
    public List<DataSource> getChildren() {
        return ImmutableList.copyOf(this.dataSources);
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (children.size() != this.dataSources.size()) {
            throw new IAE("Expected [%d] children, got [%d]", new Object[]{this.dataSources.size(), children.size()});
        }
        if (!children.stream().allMatch(dataSource -> dataSource instanceof TableDataSource)) {
            throw new IAE("All children must be tables", new Object[0]);
        }
        return new UnionDataSource(children.stream().map(dataSource -> (TableDataSource)dataSource).collect(Collectors.toList()));
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return this.dataSources.stream().allMatch(DataSource::isGlobal);
    }

    @Override
    public boolean isConcrete() {
        return this.dataSources.stream().allMatch(DataSource::isConcrete);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionDataSource that = (UnionDataSource)o;
        return this.dataSources.equals(that.dataSources);
    }

    public int hashCode() {
        return this.dataSources.hashCode();
    }

    public String toString() {
        return "UnionDataSource{dataSources=" + this.dataSources + '}';
    }
}

