/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;

public class ColumnCapabilitiesImpl
implements ColumnCapabilities {
    private static final ColumnCapabilities.CoercionLogic ALL_FALSE = new ColumnCapabilities.CoercionLogic(){

        @Override
        public boolean dictionaryEncoded() {
            return false;
        }

        @Override
        public boolean dictionaryValuesSorted() {
            return false;
        }

        @Override
        public boolean dictionaryValuesUnique() {
            return false;
        }

        @Override
        public boolean multipleValues() {
            return false;
        }

        @Override
        public boolean hasNulls() {
            return false;
        }
    };
    @Nullable
    private ValueType type = null;
    private boolean hasInvertedIndexes = false;
    private boolean hasSpatialIndexes = false;
    private ColumnCapabilities.Capable dictionaryEncoded = ColumnCapabilities.Capable.UNKNOWN;
    private ColumnCapabilities.Capable hasMultipleValues = ColumnCapabilities.Capable.UNKNOWN;
    @JsonIgnore
    private ColumnCapabilities.Capable dictionaryValuesSorted = ColumnCapabilities.Capable.UNKNOWN;
    @JsonIgnore
    private ColumnCapabilities.Capable dictionaryValuesUnique = ColumnCapabilities.Capable.UNKNOWN;
    @JsonIgnore
    private boolean filterable;
    @JsonIgnore
    private ColumnCapabilities.Capable hasNulls = ColumnCapabilities.Capable.UNKNOWN;

    public static ColumnCapabilitiesImpl copyOf(@Nullable ColumnCapabilities other) {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl();
        if (other != null) {
            capabilities.type = other.getType();
            capabilities.dictionaryEncoded = other.isDictionaryEncoded();
            capabilities.hasInvertedIndexes = other.hasBitmapIndexes();
            capabilities.hasSpatialIndexes = other.hasSpatialIndexes();
            capabilities.hasMultipleValues = other.hasMultipleValues();
            capabilities.dictionaryValuesSorted = other.areDictionaryValuesSorted();
            capabilities.dictionaryValuesUnique = other.areDictionaryValuesUnique();
            capabilities.hasNulls = other.hasNulls();
            capabilities.filterable = other.isFilterable();
        }
        return capabilities;
    }

    @Nullable
    public static ColumnCapabilitiesImpl snapshot(@Nullable ColumnCapabilities capabilities, ColumnCapabilities.CoercionLogic coerce) {
        if (capabilities == null) {
            return null;
        }
        ColumnCapabilitiesImpl copy = ColumnCapabilitiesImpl.copyOf(capabilities);
        copy.dictionaryEncoded = copy.dictionaryEncoded.coerceUnknownToBoolean(coerce.dictionaryEncoded());
        copy.dictionaryValuesSorted = copy.dictionaryValuesSorted.coerceUnknownToBoolean(coerce.dictionaryValuesSorted());
        copy.dictionaryValuesUnique = copy.dictionaryValuesUnique.coerceUnknownToBoolean(coerce.dictionaryValuesUnique());
        copy.hasMultipleValues = copy.hasMultipleValues.coerceUnknownToBoolean(coerce.multipleValues());
        copy.hasNulls = copy.hasNulls.coerceUnknownToBoolean(coerce.hasNulls());
        return copy;
    }

    @Nullable
    public static ColumnCapabilitiesImpl merge(@Nullable ColumnCapabilities capabilities, @Nullable ColumnCapabilities other, ColumnCapabilities.CoercionLogic coercionLogic) {
        ColumnCapabilitiesImpl merged = ColumnCapabilitiesImpl.snapshot(capabilities, coercionLogic);
        ColumnCapabilitiesImpl otherSnapshot = ColumnCapabilitiesImpl.snapshot(other, coercionLogic);
        if (merged == null) {
            return otherSnapshot;
        }
        if (otherSnapshot == null) {
            return merged;
        }
        if (merged.type == null) {
            merged.type = other.getType();
        }
        if (!merged.type.equals((Object)otherSnapshot.getType())) {
            throw new ISE("Cannot merge columns of type[%s] and [%s]", new Object[]{merged.type, otherSnapshot.getType()});
        }
        merged.dictionaryEncoded = merged.dictionaryEncoded.or(otherSnapshot.isDictionaryEncoded());
        merged.hasMultipleValues = merged.hasMultipleValues.or(otherSnapshot.hasMultipleValues());
        merged.dictionaryValuesSorted = merged.dictionaryValuesSorted.and(otherSnapshot.areDictionaryValuesSorted());
        merged.dictionaryValuesUnique = merged.dictionaryValuesUnique.and(otherSnapshot.areDictionaryValuesUnique());
        merged.hasNulls = merged.hasNulls.or(other.hasNulls());
        merged.hasInvertedIndexes |= otherSnapshot.hasBitmapIndexes();
        merged.hasSpatialIndexes |= otherSnapshot.hasSpatialIndexes();
        merged.filterable &= otherSnapshot.isFilterable();
        return merged;
    }

    public static ColumnCapabilitiesImpl createDefault() {
        return ColumnCapabilitiesImpl.snapshot(new ColumnCapabilitiesImpl(), ALL_FALSE);
    }

    public static ColumnCapabilitiesImpl createSimpleNumericColumnCapabilities(ValueType valueType) {
        ColumnCapabilitiesImpl builder = new ColumnCapabilitiesImpl().setType(valueType).setHasMultipleValues(false).setHasBitmapIndexes(false).setDictionaryEncoded(false).setDictionaryValuesSorted(false).setDictionaryValuesUnique(false).setHasSpatialIndexes(false);
        if (NullHandling.replaceWithDefault()) {
            builder.setHasNulls(false);
        }
        return builder;
    }

    public static ColumnCapabilitiesImpl createSimpleArrayColumnCapabilities(ValueType valueType) {
        ColumnCapabilitiesImpl builder = new ColumnCapabilitiesImpl().setType(valueType).setHasMultipleValues(true).setHasBitmapIndexes(false).setDictionaryEncoded(false).setDictionaryValuesSorted(false).setDictionaryValuesUnique(false).setHasSpatialIndexes(false);
        return builder;
    }

    @Override
    @JsonProperty
    public ValueType getType() {
        return this.type;
    }

    public ColumnCapabilitiesImpl setType(ValueType type) {
        this.type = (ValueType)Preconditions.checkNotNull((Object)type, (Object)"'type' must be nonnull");
        return this;
    }

    @Override
    @JsonProperty(value="dictionaryEncoded")
    public ColumnCapabilities.Capable isDictionaryEncoded() {
        return this.dictionaryEncoded;
    }

    @JsonSetter(value="dictionaryEncoded")
    public ColumnCapabilitiesImpl setDictionaryEncoded(boolean dictionaryEncoded) {
        this.dictionaryEncoded = ColumnCapabilities.Capable.of(dictionaryEncoded);
        return this;
    }

    @Override
    public ColumnCapabilities.Capable areDictionaryValuesSorted() {
        return this.dictionaryValuesSorted;
    }

    public ColumnCapabilitiesImpl setDictionaryValuesSorted(boolean dictionaryValuesSorted) {
        this.dictionaryValuesSorted = ColumnCapabilities.Capable.of(dictionaryValuesSorted);
        return this;
    }

    @Override
    public ColumnCapabilities.Capable areDictionaryValuesUnique() {
        return this.dictionaryValuesUnique;
    }

    public ColumnCapabilitiesImpl setDictionaryValuesUnique(boolean dictionaryValuesUnique) {
        this.dictionaryValuesUnique = ColumnCapabilities.Capable.of(dictionaryValuesUnique);
        return this;
    }

    @Override
    @JsonProperty(value="hasBitmapIndexes")
    public boolean hasBitmapIndexes() {
        return this.hasInvertedIndexes;
    }

    public ColumnCapabilitiesImpl setHasBitmapIndexes(boolean hasInvertedIndexes) {
        this.hasInvertedIndexes = hasInvertedIndexes;
        return this;
    }

    @Override
    @JsonProperty(value="hasSpatialIndexes")
    public boolean hasSpatialIndexes() {
        return this.hasSpatialIndexes;
    }

    public ColumnCapabilitiesImpl setHasSpatialIndexes(boolean hasSpatialIndexes) {
        this.hasSpatialIndexes = hasSpatialIndexes;
        return this;
    }

    @Override
    @JsonProperty(value="hasMultipleValues")
    public ColumnCapabilities.Capable hasMultipleValues() {
        return this.hasMultipleValues;
    }

    public ColumnCapabilitiesImpl setHasMultipleValues(boolean hasMultipleValues) {
        this.hasMultipleValues = ColumnCapabilities.Capable.of(hasMultipleValues);
        return this;
    }

    @Override
    public ColumnCapabilities.Capable hasNulls() {
        return this.hasNulls;
    }

    public ColumnCapabilitiesImpl setHasNulls(boolean hasNulls) {
        this.hasNulls = ColumnCapabilities.Capable.of(hasNulls);
        return this;
    }

    public ColumnCapabilitiesImpl setHasNulls(ColumnCapabilities.Capable hasNulls) {
        this.hasNulls = hasNulls;
        return this;
    }

    @Override
    public boolean isFilterable() {
        return this.type == ValueType.STRING || this.type == ValueType.LONG || this.type == ValueType.FLOAT || this.type == ValueType.DOUBLE || this.filterable;
    }

    public ColumnCapabilitiesImpl setFilterable(boolean filterable) {
        this.filterable = filterable;
        return this;
    }
}

