/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.virtual.SingleInputBindings;

public class SingleLongInputCachingExpressionColumnValueSelector
implements ColumnValueSelector<ExprEval> {
    private static final int CACHE_SIZE = 1000;
    private final ColumnValueSelector selector;
    private final Expr expression;
    private final SingleInputBindings bindings = new SingleInputBindings();
    @Nullable
    private final LruEvalCache lruEvalCache;
    private long lastInput;
    @Nullable
    private ExprEval lastOutput;

    public SingleLongInputCachingExpressionColumnValueSelector(ColumnValueSelector selector, Expr expression, boolean useLruCache) {
        if (expression.analyzeInputs().getRequiredBindings().size() != 1) {
            throw new ISE("Expected expression with just one binding", new Object[0]);
        }
        this.selector = (ColumnValueSelector)Preconditions.checkNotNull((Object)selector, (Object)"selector");
        this.expression = (Expr)Preconditions.checkNotNull((Object)expression, (Object)"expression");
        this.lruEvalCache = useLruCache ? new LruEvalCache() : null;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("expression", this.expression);
    }

    @Override
    public double getDouble() {
        return this.getObject().asDouble();
    }

    @Override
    public float getFloat() {
        return (float)this.getObject().asDouble();
    }

    @Override
    public long getLong() {
        return this.getObject().asLong();
    }

    @Override
    @Nonnull
    public ExprEval getObject() {
        boolean cached;
        if (this.selector.isNull()) {
            return ExprEval.ofLong(null);
        }
        long input = this.selector.getLong();
        boolean bl = cached = input == this.lastInput && this.lastOutput != null;
        if (!cached) {
            if (this.lruEvalCache == null) {
                this.bindings.set(input);
                this.lastOutput = this.expression.eval((Expr.ObjectBinding)this.bindings);
            } else {
                this.lastOutput = this.lruEvalCache.compute(input);
            }
            this.lastInput = input;
        }
        return this.lastOutput;
    }

    @Override
    public Class<ExprEval> classOfObject() {
        return ExprEval.class;
    }

    @Override
    public boolean isNull() {
        return this.getObject().isNumericNull();
    }

    public class LruEvalCache {
        private final Long2ObjectLinkedOpenHashMap<ExprEval> m = new Long2ObjectLinkedOpenHashMap();

        public ExprEval compute(long n) {
            ExprEval value = (ExprEval)this.m.getAndMoveToFirst(n);
            if (value == null) {
                SingleLongInputCachingExpressionColumnValueSelector.this.bindings.set(n);
                value = SingleLongInputCachingExpressionColumnValueSelector.this.expression.eval((Expr.ObjectBinding)SingleLongInputCachingExpressionColumnValueSelector.this.bindings);
                this.m.putAndMoveToFirst(n, (Object)value);
                if (this.m.size() > 1000) {
                    this.m.removeLast();
                }
            }
            return value;
        }
    }
}

