/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.hyperloglog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.column.ValueType;

public class HyperUniqueFinalizingPostAggregator
implements PostAggregator {
    private static final Comparator<Double> DOUBLE_COMPARATOR = Ordering.from((lhs, rhs) -> Double.compare(lhs, rhs)).nullsFirst();
    private final String name;
    private final String fieldName;
    @Nullable
    private final AggregatorFactory aggregatorFactory;

    @JsonCreator
    public HyperUniqueFinalizingPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this(name, fieldName, null);
    }

    private HyperUniqueFinalizingPostAggregator(String name, String fieldName, @Nullable AggregatorFactory aggregatorFactory) {
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName is null");
        this.name = name == null ? fieldName : name;
        this.aggregatorFactory = aggregatorFactory;
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Comparator<Double> getComparator() {
        return DOUBLE_COMPARATOR;
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        Object collector = combinedAggregators.get(this.fieldName);
        if (this.aggregatorFactory == null) {
            return HyperUniquesAggregatorFactory.estimateCardinality(collector, false);
        }
        return this.aggregatorFactory.finalizeComputation(collector);
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    public ValueType getType() {
        return this.aggregatorFactory != null ? this.aggregatorFactory.getFinalizedType() : null;
    }

    @Override
    public HyperUniqueFinalizingPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        AggregatorFactory theAggregatorFactory = aggregators != null ? aggregators.get(this.fieldName) : null;
        return new HyperUniqueFinalizingPostAggregator(this.name, this.fieldName, theAggregatorFactory);
    }

    @JsonProperty(value="fieldName")
    public String getFieldName() {
        return this.fieldName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HyperUniqueFinalizingPostAggregator that = (HyperUniqueFinalizingPostAggregator)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.fieldName != null ? this.fieldName.equals(that.fieldName) : that.fieldName == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HyperUniqueFinalizingPostAggregator{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(9).appendString(this.fieldName).build();
    }
}

