/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.context;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.context.DefaultResponseContext;

public abstract class ResponseContext {
    private static final Comparator<Map.Entry<String, JsonNode>> VALUE_LENGTH_REVERSED_COMPARATOR = Comparator.comparing(e -> ((JsonNode)e.getValue()).toString().length()).reversed();

    protected abstract Map<BaseKey, Object> getDelegate();

    public static ResponseContext createEmpty() {
        return DefaultResponseContext.createEmpty();
    }

    public static ResponseContext deserialize(String responseContext, ObjectMapper objectMapper) throws IOException {
        Map keyNameToObjects = (Map)objectMapper.readValue(responseContext, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        ResponseContext context = ResponseContext.createEmpty();
        keyNameToObjects.forEach((keyName, value) -> {
            BaseKey key = Key.keyOf(keyName);
            context.add(key, value);
        });
        return context;
    }

    public Object put(BaseKey key, Object value) {
        BaseKey registeredKey = Key.keyOf(key.getName());
        return this.getDelegate().put(registeredKey, value);
    }

    public Object get(BaseKey key) {
        return this.getDelegate().get(key);
    }

    public Object remove(BaseKey key) {
        return this.getDelegate().remove(key);
    }

    public Object add(BaseKey key, Object value) {
        BaseKey registeredKey = Key.keyOf(key.getName());
        return this.getDelegate().merge(registeredKey, value, key.getMergeFunction());
    }

    public void merge(ResponseContext responseContext) {
        responseContext.getDelegate().forEach((key, newValue) -> {
            if (newValue != null) {
                this.add((BaseKey)key, newValue);
            }
        });
    }

    public SerializationResult serializeWith(ObjectMapper objectMapper, int maxCharsNumber) throws JsonProcessingException {
        String fullSerializedString = objectMapper.writeValueAsString(this.getDelegate());
        if (fullSerializedString.length() <= maxCharsNumber) {
            return new SerializationResult(null, fullSerializedString);
        }
        this.add(Key.TRUNCATED, true);
        ObjectNode contextJsonNode = (ObjectNode)objectMapper.valueToTree(this.getDelegate());
        ArrayList sortedNodesByLength = Lists.newArrayList((Iterator)contextJsonNode.fields());
        sortedNodesByLength.sort(VALUE_LENGTH_REVERSED_COMPARATOR);
        int needToRemoveCharsNumber = fullSerializedString.length() - maxCharsNumber;
        for (Map.Entry e : sortedNodesByLength) {
            String fieldName = (String)e.getKey();
            JsonNode node = (JsonNode)e.getValue();
            if (node.isArray()) {
                if (needToRemoveCharsNumber >= node.toString().length()) {
                    contextJsonNode.remove(fieldName);
                    needToRemoveCharsNumber = contextJsonNode.toString().length() - maxCharsNumber;
                } else {
                    ArrayNode arrayNode = (ArrayNode)node;
                    needToRemoveCharsNumber -= ResponseContext.removeNodeElementsToSatisfyCharsLimit(arrayNode, needToRemoveCharsNumber);
                    if (arrayNode.size() == 0) {
                        contextJsonNode.remove(fieldName);
                        needToRemoveCharsNumber = contextJsonNode.toString().length() - maxCharsNumber;
                    }
                }
            } else {
                contextJsonNode.remove(fieldName);
                needToRemoveCharsNumber = contextJsonNode.toString().length() - maxCharsNumber;
            }
            if (needToRemoveCharsNumber > 0) continue;
            break;
        }
        return new SerializationResult(contextJsonNode.toString(), fullSerializedString);
    }

    private static int removeNodeElementsToSatisfyCharsLimit(ArrayNode node, int needToRemoveCharsNumber) {
        int removedCharsNumber;
        int lengthAfterRemove;
        int lengthBeforeRemove;
        for (removedCharsNumber = 0; node.size() > 0 && needToRemoveCharsNumber > removedCharsNumber; removedCharsNumber += lengthBeforeRemove - lengthAfterRemove) {
            lengthBeforeRemove = node.toString().length();
            int removeUntil = node.size() / 2;
            for (int removeAt = node.size() - 1; removeAt >= removeUntil; --removeAt) {
                node.remove(removeAt);
            }
            lengthAfterRemove = node.toString().length();
        }
        return removedCharsNumber;
    }

    public static class SerializationResult {
        @Nullable
        private final String truncatedResult;
        private final String fullResult;

        SerializationResult(@Nullable String truncatedResult, String fullResult) {
            this.truncatedResult = truncatedResult;
            this.fullResult = fullResult;
        }

        public String getResult() {
            return this.isTruncated() ? this.truncatedResult : this.fullResult;
        }

        public String getFullResult() {
            return this.fullResult;
        }

        public boolean isTruncated() {
            return this.truncatedResult != null;
        }
    }

    public static enum Key implements BaseKey
    {
        UNCOVERED_INTERVALS("uncoveredIntervals", (oldValue, newValue) -> {
            ArrayList result = new ArrayList((List)oldValue);
            result.addAll((List)newValue);
            return result;
        }),
        UNCOVERED_INTERVALS_OVERFLOWED("uncoveredIntervalsOverflowed", (oldValue, newValue) -> (Boolean)oldValue != false || (Boolean)newValue != false),
        REMAINING_RESPONSES_FROM_QUERY_SERVERS("remainingResponsesFromQueryServers", (totalRemainingPerId, idAndNumResponses) -> {
            ConcurrentHashMap map = (ConcurrentHashMap)totalRemainingPerId;
            NonnullPair pair = (NonnullPair)idAndNumResponses;
            map.compute(pair.lhs, (id, remaining) -> remaining == null ? (Integer)pair.rhs : remaining + (Integer)pair.rhs);
            return map;
        }),
        MISSING_SEGMENTS("missingSegments", (oldValue, newValue) -> {
            ArrayList result = new ArrayList((List)oldValue);
            result.addAll((List)newValue);
            return result;
        }),
        ETAG("ETag"),
        QUERY_FAIL_DEADLINE_MILLIS("queryFailTime"),
        QUERY_TOTAL_BYTES_GATHERED("queryTotalBytesGathered"),
        TIMEOUT_AT("timeoutAt"),
        NUM_SCANNED_ROWS("count", (oldValue, newValue) -> ((Number)oldValue).longValue() + ((Number)newValue).longValue()),
        CPU_CONSUMED_NANOS("cpuConsumed", (oldValue, newValue) -> ((Number)oldValue).longValue() + ((Number)newValue).longValue()),
        TRUNCATED("truncated", (oldValue, newValue) -> (Boolean)oldValue != false || (Boolean)newValue != false);

        private static final ConcurrentMap<String, BaseKey> REGISTERED_KEYS;
        private final String name;
        private final BiFunction<Object, Object, Object> mergeFunction;

        public static void registerKey(BaseKey key) {
            if (REGISTERED_KEYS.putIfAbsent(key.getName(), key) != null) {
                throw new IAE("Key [%s] has already been registered as a context key", new Object[]{key.getName()});
            }
        }

        public static BaseKey keyOf(String name) {
            BaseKey key = (BaseKey)REGISTERED_KEYS.get(name);
            if (key == null) {
                throw new ISE("Key [%s] has not yet been registered as a context key", new Object[]{name});
            }
            return key;
        }

        public static Collection<BaseKey> getAllRegisteredKeys() {
            return Collections.unmodifiableCollection(REGISTERED_KEYS.values());
        }

        private Key(String name) {
            this.name = name;
            this.mergeFunction = (oldValue, newValue) -> newValue;
        }

        private Key(String name, BiFunction<Object, Object, Object> mergeFunction) {
            this.name = name;
            this.mergeFunction = mergeFunction;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public BiFunction<Object, Object, Object> getMergeFunction() {
            return this.mergeFunction;
        }

        static {
            REGISTERED_KEYS = new ConcurrentSkipListMap<String, BaseKey>();
            for (Key key : Key.values()) {
                Key.registerKey(key);
            }
        }
    }

    public static interface BaseKey {
        @JsonValue
        public String getName();

        public BiFunction<Object, Object, Object> getMergeFunction();
    }
}

