/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.strategy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.ResultMergeQueryRunner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.GroupByBinaryFnV2;
import org.apache.druid.query.groupby.epinephelinae.GroupByMergingQueryRunnerV2;
import org.apache.druid.query.groupby.epinephelinae.GroupByQueryEngineV2;
import org.apache.druid.query.groupby.epinephelinae.GroupByRowProcessor;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.resource.GroupByQueryResource;
import org.apache.druid.query.groupby.strategy.GroupByStrategy;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class GroupByStrategyV2
implements GroupByStrategy {
    public static final String CTX_KEY_FUDGE_TIMESTAMP = "fudgeTimestamp";
    public static final String CTX_KEY_OUTERMOST = "groupByOutermost";
    private static final int MAX_MERGE_BUFFER_NUM = 2;
    private final DruidProcessingConfig processingConfig;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final NonBlockingPool<ByteBuffer> bufferPool;
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final ObjectMapper spillMapper;
    private final QueryWatcher queryWatcher;

    @Inject
    public GroupByStrategyV2(DruidProcessingConfig processingConfig, Supplier<GroupByQueryConfig> configSupplier, @Global NonBlockingPool<ByteBuffer> bufferPool, @Merging BlockingPool<ByteBuffer> mergeBufferPool, @Smile ObjectMapper spillMapper, QueryWatcher queryWatcher) {
        this.processingConfig = processingConfig;
        this.configSupplier = configSupplier;
        this.bufferPool = bufferPool;
        this.mergeBufferPool = mergeBufferPool;
        this.spillMapper = spillMapper;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public GroupByQueryResource prepareResource(GroupByQuery query) {
        int requiredMergeBufferNum = GroupByStrategyV2.countRequiredMergeBufferNum(query, 1) + this.numMergeBuffersNeededForSubtotalsSpec(query);
        if (requiredMergeBufferNum > this.mergeBufferPool.maxSize()) {
            throw new ResourceLimitExceededException("Query needs " + requiredMergeBufferNum + " merge buffers, but only " + this.mergeBufferPool.maxSize() + " merge buffers were configured");
        }
        if (requiredMergeBufferNum == 0) {
            return new GroupByQueryResource();
        }
        List mergeBufferHolders = QueryContexts.hasTimeout(query) ? this.mergeBufferPool.takeBatch(requiredMergeBufferNum, QueryContexts.getTimeout(query)) : this.mergeBufferPool.takeBatch(requiredMergeBufferNum);
        if (mergeBufferHolders.isEmpty()) {
            throw QueryCapacityExceededException.withErrorMessageAndResolvedHost(StringUtils.format((String)"Cannot acquire %s merge buffers. Try again after current running queries are finished.", (Object[])new Object[]{requiredMergeBufferNum}));
        }
        return new GroupByQueryResource(mergeBufferHolders);
    }

    private static int countRequiredMergeBufferNum(Query query, int foundNum) {
        DataSource dataSource = query.getDataSource();
        if (foundNum == 3 || !(dataSource instanceof QueryDataSource)) {
            return foundNum - 1;
        }
        return GroupByStrategyV2.countRequiredMergeBufferNum(((QueryDataSource)dataSource).getQuery(), foundNum + 1);
    }

    @Override
    public boolean isCacheable(boolean willMergeRunners) {
        return willMergeRunners;
    }

    @Override
    public boolean doMergeResults(GroupByQuery query) {
        return true;
    }

    @Override
    public Comparator<ResultRow> createResultComparator(Query<ResultRow> queryParam) {
        return ((GroupByQuery)queryParam).getRowOrdering(true);
    }

    @Override
    public BinaryOperator<ResultRow> createMergeFn(Query<ResultRow> queryParam) {
        return new GroupByBinaryFnV2((GroupByQuery)queryParam);
    }

    @Override
    public Sequence<ResultRow> mergeResults(QueryRunner<ResultRow> baseRunner, GroupByQuery query, ResponseContext responseContext) {
        ResultMergeQueryRunner<ResultRow> mergingQueryRunner = new ResultMergeQueryRunner<ResultRow>(baseRunner, this::createResultComparator, this::createMergeFn);
        ImmutableMap.Builder context = ImmutableMap.builder();
        context.put((Object)"finalize", (Object)false);
        context.put((Object)"groupByStrategy", (Object)"v2");
        context.put((Object)CTX_KEY_OUTERMOST, (Object)false);
        if (query.getUniversalTimestamp() != null) {
            context.put((Object)CTX_KEY_FUDGE_TIMESTAMP, (Object)String.valueOf(query.getUniversalTimestamp().getMillis()));
        }
        context.put((Object)"applyLimitPushDown", (Object)query.isApplyLimitPushDown());
        context.put((Object)"resultAsArray", (Object)true);
        Query newQuery = new GroupByQuery(query.getDataSource(), query.getQuerySegmentSpec(), query.getVirtualColumns(), query.getDimFilter(), query.getGranularity(), query.getDimensions(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs(), null, query.isApplyLimitPushDown() ? ((DefaultLimitSpec)query.getLimitSpec()).withOffsetToLimit() : null, query.getSubtotalsSpec(), query.getContext()).withOverriddenContext((Map)context.build());
        Sequence mergedResults = mergingQueryRunner.run(QueryPlus.wrap(newQuery), responseContext);
        if (!query.getContextBoolean(CTX_KEY_OUTERMOST, true) || query.getPostAggregatorSpecs().isEmpty() || query.getContextBoolean("executingNestedQuery", false)) {
            return mergedResults;
        }
        return Sequences.map(mergedResults, row -> {
            ResultRow rowWithPostAggregations = ResultRow.create(query.getResultRowSizeWithPostAggregators());
            for (int i = 0; i < query.getResultRowPostAggregatorStart(); ++i) {
                rowWithPostAggregations.set(i, row.get(i));
            }
            Map<String, Object> mapForPostAggregationComputation = rowWithPostAggregations.toMap(query);
            for (int i = 0; i < query.getPostAggregatorSpecs().size(); ++i) {
                PostAggregator postAggregator = query.getPostAggregatorSpecs().get(i);
                Object value = postAggregator.compute(mapForPostAggregationComputation);
                rowWithPostAggregations.set(query.getResultRowPostAggregatorStart() + i, value);
                mapForPostAggregationComputation.put(postAggregator.getName(), value);
            }
            return rowWithPostAggregations;
        });
    }

    @Override
    public Sequence<ResultRow> applyPostProcessing(Sequence<ResultRow> results, GroupByQuery query) {
        if (query.getContextBoolean(CTX_KEY_OUTERMOST, true)) {
            return query.postProcess(results);
        }
        return results;
    }

    @Override
    public Sequence<ResultRow> processSubqueryResult(GroupByQuery subquery, GroupByQuery query, GroupByQueryResource resource, Sequence<ResultRow> subqueryResult, boolean wasQueryPushedDown) {
        GroupByRowProcessor.ResultSupplier resultSupplier = null;
        try {
            GroupByQuery queryToRun = wasQueryPushedDown ? query.withDimFilter(null).withQuerySegmentSpec(new MultipleIntervalSegmentSpec((List<Interval>)Intervals.ONLY_ETERNITY)) : query;
            GroupByRowProcessor.ResultSupplier finalResultSupplier = resultSupplier = GroupByRowProcessor.process(queryToRun, wasQueryPushedDown ? queryToRun : subquery, subqueryResult, (GroupByQueryConfig)this.configSupplier.get(), resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes());
            return Sequences.withBaggage(this.mergeResults((queryPlus, responseContext) -> finalResultSupplier.results(null), query, null), (Closeable)finalResultSupplier);
        }
        catch (Exception ex) {
            CloseQuietly.close(resultSupplier);
            throw ex;
        }
    }

    @Override
    public Sequence<ResultRow> processSubtotalsSpec(GroupByQuery query, GroupByQueryResource resource, Sequence<ResultRow> queryResult) {
        GroupByRowProcessor.ResultSupplier resultSupplierOne = null;
        try {
            GroupByQuery baseSubtotalQuery = query.withDimensionSpecs(query.getDimensions().stream().map(dimSpec -> new DefaultDimensionSpec(dimSpec.getOutputName(), dimSpec.getOutputName(), dimSpec.getOutputType())).collect(Collectors.toList())).withAggregatorSpecs(query.getAggregatorSpecs().stream().map(AggregatorFactory::getCombiningFactory).collect(Collectors.toList())).withVirtualColumns(VirtualColumns.EMPTY).withDimFilter(null).withSubtotalsSpec(null);
            resultSupplierOne = GroupByRowProcessor.process(baseSubtotalQuery, baseSubtotalQuery, queryResult, (GroupByQueryConfig)this.configSupplier.get(), resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes());
            List queryDimNames = baseSubtotalQuery.getDimensions().stream().map(DimensionSpec::getOutputName).collect(Collectors.toList());
            Set<String> aggsAndPostAggs = null;
            if (!(baseSubtotalQuery.getLimitSpec() instanceof NoopLimitSpec)) {
                aggsAndPostAggs = this.getAggregatorAndPostAggregatorNames(baseSubtotalQuery);
            }
            List<List<String>> subtotals = query.getSubtotalsSpec();
            ArrayList<Sequence<ResultRow>> subtotalsResults = new ArrayList<Sequence<ResultRow>>(subtotals.size());
            for (List<String> subtotalSpec : subtotals) {
                ImmutableSet dimsInSubtotalSpec = ImmutableSet.copyOf(subtotalSpec);
                ArrayList<DimensionSpec> subTotalDimensionSpec = new ArrayList<DimensionSpec>(dimsInSubtotalSpec.size());
                List<DimensionSpec> dimensions = query.getDimensions();
                for (DimensionSpec dimensionSpec : dimensions) {
                    if (!dimsInSubtotalSpec.contains((Object)dimensionSpec.getOutputName())) continue;
                    subTotalDimensionSpec.add(dimensionSpec);
                }
                LimitSpec subtotalQueryLimitSpec = NoopLimitSpec.instance();
                if (!(baseSubtotalQuery.getLimitSpec() instanceof NoopLimitSpec)) {
                    HashSet<String> columns = new HashSet<String>(aggsAndPostAggs);
                    columns.addAll(subtotalSpec);
                    subtotalQueryLimitSpec = baseSubtotalQuery.getLimitSpec().filterColumns(columns);
                }
                GroupByQuery subtotalQuery = baseSubtotalQuery.withLimitSpec(subtotalQueryLimitSpec);
                GroupByRowProcessor.ResultSupplier resultSupplierOneFinal = resultSupplierOne;
                if (Utils.isPrefix(subtotalSpec, queryDimNames)) {
                    subtotalsResults.add(this.processSubtotalsResultAndOptionallyClose((Supplier<GroupByRowProcessor.ResultSupplier>)((Supplier)() -> resultSupplierOneFinal), subTotalDimensionSpec, subtotalQuery, false));
                    continue;
                }
                Supplier resultSupplierTwo = () -> GroupByRowProcessor.process(baseSubtotalQuery, subtotalQuery, resultSupplierOneFinal.results(subTotalDimensionSpec), (GroupByQueryConfig)this.configSupplier.get(), resource, this.spillMapper, this.processingConfig.getTmpDir(), this.processingConfig.intermediateComputeSizeBytes());
                subtotalsResults.add(this.processSubtotalsResultAndOptionallyClose((Supplier<GroupByRowProcessor.ResultSupplier>)resultSupplierTwo, subTotalDimensionSpec, subtotalQuery, true));
            }
            return Sequences.withBaggage(query.postProcess((Sequence<ResultRow>)Sequences.concat(subtotalsResults)), (Closeable)resultSupplierOne);
        }
        catch (Exception ex) {
            CloseQuietly.close(resultSupplierOne);
            throw ex;
        }
    }

    private Sequence<ResultRow> processSubtotalsResultAndOptionallyClose(Supplier<GroupByRowProcessor.ResultSupplier> baseResultsSupplier, List<DimensionSpec> dimsToInclude, GroupByQuery subtotalQuery, boolean closeOnSequenceRead) {
        try {
            Supplier memoizedSupplier = Suppliers.memoize(baseResultsSupplier);
            return this.mergeResults((queryPlus, responseContext) -> new LazySequence(() -> Sequences.withBaggage(((GroupByRowProcessor.ResultSupplier)memoizedSupplier.get()).results(dimsToInclude), (Closeable)(closeOnSequenceRead ? () -> CloseQuietly.close((Closeable)((Closeable)memoizedSupplier.get())) : () -> {}))), subtotalQuery, null);
        }
        catch (Exception ex) {
            CloseQuietly.close((Closeable)((Closeable)baseResultsSupplier.get()));
            throw ex;
        }
    }

    private Set<String> getAggregatorAndPostAggregatorNames(GroupByQuery query) {
        HashSet<String> aggsAndPostAggs = new HashSet<String>();
        if (query.getAggregatorSpecs() != null) {
            for (AggregatorFactory af : query.getAggregatorSpecs()) {
                aggsAndPostAggs.add(af.getName());
            }
        }
        if (query.getPostAggregatorSpecs() != null) {
            for (PostAggregator pa : query.getPostAggregatorSpecs()) {
                aggsAndPostAggs.add(pa.getName());
            }
        }
        return aggsAndPostAggs;
    }

    private int numMergeBuffersNeededForSubtotalsSpec(GroupByQuery query) {
        List<List<String>> subtotalSpecs = query.getSubtotalsSpec();
        if (subtotalSpecs == null || subtotalSpecs.size() == 0) {
            return 0;
        }
        List queryDimOutputNames = query.getDimensions().stream().map(DimensionSpec::getOutputName).collect(Collectors.toList());
        for (List<String> subtotalSpec : subtotalSpecs) {
            if (Utils.isPrefix(subtotalSpec, queryDimOutputNames)) continue;
            return 2;
        }
        return 1;
    }

    @Override
    public QueryRunner<ResultRow> mergeRunners(ListeningExecutorService exec, Iterable<QueryRunner<ResultRow>> queryRunners) {
        return new GroupByMergingQueryRunnerV2((GroupByQueryConfig)this.configSupplier.get(), (ExecutorService)exec, this.queryWatcher, queryRunners, this.processingConfig.getNumThreads(), this.mergeBufferPool, this.processingConfig.intermediateComputeSizeBytes(), this.spillMapper, this.processingConfig.getTmpDir());
    }

    @Override
    public Sequence<ResultRow> process(GroupByQuery query, StorageAdapter storageAdapter) {
        return GroupByQueryEngineV2.process(query, storageAdapter, this.bufferPool, ((GroupByQueryConfig)this.configSupplier.get()).withOverrides(query));
    }

    @Override
    public boolean supportsNestedQueryPushDown() {
        return true;
    }
}

