/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.table.IndexedTable;

public class UniqueLongArrayIndex
implements IndexedTable.Index {
    private final int[] index;
    private final long minKey;

    UniqueLongArrayIndex(int[] index, long minKey) {
        this.index = index;
        this.minKey = minKey;
    }

    @Override
    public ValueType keyType() {
        return ValueType.LONG;
    }

    @Override
    public boolean areKeysUnique() {
        return true;
    }

    @Override
    public IntList find(Object key) {
        int row;
        Long longKey = DimensionHandlerUtils.convertObjectToLong(key);
        if (longKey != null && (row = this.findUniqueLong(longKey)) >= 0) {
            return IntLists.singleton((int)row);
        }
        return IntLists.EMPTY_LIST;
    }

    @Override
    public int findUniqueLong(long key) {
        if (key >= this.minKey && key < this.minKey + (long)this.index.length) {
            return this.index[(int)(key - this.minKey)];
        }
        return -1;
    }
}

