/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionPlan;

public class ExpressionPlanner {
    private ExpressionPlanner() {
    }

    public static ExpressionPlan plan(ColumnInspector inspector, Expr expression) {
        boolean supportsVector;
        boolean shouldComputeOutput;
        String column;
        Object capabilities;
        Expr.BindingAnalysis analysis = expression.analyzeInputs();
        Parser.validateExpr((Expr)expression, (Expr.BindingAnalysis)analysis);
        EnumSet<ExpressionPlan.Trait> traits = EnumSet.noneOf(ExpressionPlan.Trait.class);
        HashSet<String> noCapabilities = new HashSet<String>();
        HashSet<String> maybeMultiValued = new HashSet<String>();
        Object needsApplied = ImmutableList.of();
        ValueType singleInputType = null;
        ExprType outputType = null;
        Set columns = analysis.getRequiredBindings();
        if (columns.isEmpty()) {
            traits.add(ExpressionPlan.Trait.CONSTANT);
        } else if (columns.size() == 1 && (capabilities = inspector.getColumnCapabilities(column = (String)Iterables.getOnlyElement((Iterable)columns))) != null) {
            boolean isSingleInputScalar;
            boolean isSingleInputMappable = false;
            boolean bl = isSingleInputScalar = capabilities.hasMultipleValues().isFalse() && !analysis.hasInputArrays() && !analysis.isOutputArray();
            if (capabilities.getType() == ValueType.STRING) {
                isSingleInputScalar &= capabilities.isDictionaryEncoded().isTrue();
                boolean bl2 = isSingleInputMappable = capabilities.isDictionaryEncoded().isTrue() && !capabilities.hasMultipleValues().isUnknown() && !analysis.hasInputArrays() && !analysis.isOutputArray();
            }
            if (isSingleInputScalar || isSingleInputMappable) {
                singleInputType = capabilities.getType();
                if (isSingleInputScalar) {
                    traits.add(ExpressionPlan.Trait.SINGLE_INPUT_SCALAR);
                }
                if (isSingleInputMappable) {
                    traits.add(ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE);
                }
            }
        }
        if (ExpressionPlan.none(traits, ExpressionPlan.Trait.SINGLE_INPUT_SCALAR)) {
            HashSet<String> definitelyMultiValued = new HashSet<String>();
            for (String column2 : analysis.getRequiredBindings()) {
                ColumnCapabilities capabilities2 = inspector.getColumnCapabilities(column2);
                if (capabilities2 != null) {
                    if (capabilities2.hasMultipleValues().isTrue()) {
                        definitelyMultiValued.add(column2);
                        continue;
                    }
                    if (!capabilities2.getType().equals((Object)ValueType.STRING) || !capabilities2.hasMultipleValues().isMaybeTrue() || analysis.getArrayBindings().contains(column2)) continue;
                    maybeMultiValued.add(column2);
                    continue;
                }
                noCapabilities.add(column2);
            }
            needsApplied = columns.stream().filter(c -> definitelyMultiValued.contains(c) && !analysis.getArrayBindings().contains(c)).collect(Collectors.toList());
            if (analysis.hasInputArrays()) {
                traits.add(ExpressionPlan.Trait.NON_SCALAR_INPUTS);
            }
            if (!noCapabilities.isEmpty()) {
                traits.add(ExpressionPlan.Trait.UNKNOWN_INPUTS);
            }
            if (!maybeMultiValued.isEmpty()) {
                traits.add(ExpressionPlan.Trait.INCOMPLETE_INPUTS);
            }
            if (!needsApplied.isEmpty()) {
                traits.add(ExpressionPlan.Trait.NEEDS_APPLIED);
            }
        }
        if (shouldComputeOutput = ExpressionPlan.none(traits, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED)) {
            outputType = expression.getOutputType((Expr.InputBindingInspector)inspector);
        }
        if (analysis.isOutputArray() || ExprType.isArray((ExprType)outputType)) {
            traits.add(ExpressionPlan.Trait.NON_SCALAR_OUTPUT);
            traits.remove((Object)ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE);
        }
        if (ExpressionPlan.is(traits, ExpressionPlan.Trait.NEEDS_APPLIED)) {
            traits.add(ExpressionPlan.Trait.NON_SCALAR_OUTPUT);
        }
        if ((supportsVector = ExpressionPlan.none(traits, ExpressionPlan.Trait.INCOMPLETE_INPUTS, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.NON_SCALAR_INPUTS, ExpressionPlan.Trait.NON_SCALAR_OUTPUT)) && expression.canVectorize((Expr.InputBindingInspector)inspector)) {
            outputType = expression.getOutputType((Expr.InputBindingInspector)inspector);
            traits.add(ExpressionPlan.Trait.VECTORIZABLE);
        }
        return new ExpressionPlan(expression, analysis, traits, outputType, singleInputType, (Set<String>)Sets.union(noCapabilities, maybeMultiValued), (List<String>)needsApplied);
    }
}

