/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.Query;

public class QueryContexts {
    public static final String FINALIZE_KEY = "finalize";
    public static final String PRIORITY_KEY = "priority";
    public static final String LANE_KEY = "lane";
    public static final String TIMEOUT_KEY = "timeout";
    public static final String MAX_SCATTER_GATHER_BYTES_KEY = "maxScatterGatherBytes";
    public static final String MAX_QUEUED_BYTES_KEY = "maxQueuedBytes";
    public static final String DEFAULT_TIMEOUT_KEY = "defaultTimeout";
    public static final String BROKER_PARALLEL_MERGE_KEY = "enableParallelMerge";
    public static final String BROKER_PARALLEL_MERGE_INITIAL_YIELD_ROWS_KEY = "parallelMergeInitialYieldRows";
    public static final String BROKER_PARALLEL_MERGE_SMALL_BATCH_ROWS_KEY = "parallelMergeSmallBatchRows";
    public static final String BROKER_PARALLELISM = "parallelMergeParallelism";
    public static final String VECTORIZE_KEY = "vectorize";
    public static final String VECTORIZE_VIRTUAL_COLUMNS_KEY = "vectorizeVirtualColumns";
    public static final String VECTOR_SIZE_KEY = "vectorSize";
    public static final String MAX_SUBQUERY_ROWS_KEY = "maxSubqueryRows";
    public static final String JOIN_FILTER_PUSH_DOWN_KEY = "enableJoinFilterPushDown";
    public static final String JOIN_FILTER_REWRITE_ENABLE_KEY = "enableJoinFilterRewrite";
    public static final String JOIN_FILTER_REWRITE_VALUE_COLUMN_FILTERS_ENABLE_KEY = "enableJoinFilterRewriteValueColumnFilters";
    public static final String JOIN_FILTER_REWRITE_MAX_SIZE_KEY = "joinFilterRewriteMaxSize";
    public static final String USE_FILTER_CNF_KEY = "useFilterCNF";
    public static final String NUM_RETRIES_ON_MISSING_SEGMENTS_KEY = "numRetriesOnMissingSegments";
    public static final String RETURN_PARTIAL_RESULTS_KEY = "returnPartialResults";
    public static final String USE_CACHE_KEY = "useCache";
    public static final String SECONDARY_PARTITION_PRUNING_KEY = "secondaryPartitionPruning";
    public static final boolean DEFAULT_BY_SEGMENT = false;
    public static final boolean DEFAULT_POPULATE_CACHE = true;
    public static final boolean DEFAULT_USE_CACHE = true;
    public static final boolean DEFAULT_POPULATE_RESULTLEVEL_CACHE = true;
    public static final boolean DEFAULT_USE_RESULTLEVEL_CACHE = true;
    public static final Vectorize DEFAULT_VECTORIZE = Vectorize.TRUE;
    public static final Vectorize DEFAULT_VECTORIZE_VIRTUAL_COLUMN = Vectorize.FALSE;
    public static final int DEFAULT_PRIORITY = 0;
    public static final int DEFAULT_UNCOVERED_INTERVALS_LIMIT = 0;
    public static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    public static final long NO_TIMEOUT = 0L;
    public static final boolean DEFAULT_ENABLE_PARALLEL_MERGE = true;
    public static final boolean DEFAULT_ENABLE_JOIN_FILTER_PUSH_DOWN = true;
    public static final boolean DEFAULT_ENABLE_JOIN_FILTER_REWRITE = true;
    public static final boolean DEFAULT_ENABLE_JOIN_FILTER_REWRITE_VALUE_COLUMN_FILTERS = false;
    public static final long DEFAULT_ENABLE_JOIN_FILTER_REWRITE_MAX_SIZE = 10000L;
    public static final boolean DEFAULT_USE_FILTER_CNF = false;
    public static final boolean DEFAULT_SECONDARY_PARTITION_PRUNING = true;

    public static <T> boolean isBySegment(Query<T> query) {
        return QueryContexts.isBySegment(query, false);
    }

    public static <T> boolean isBySegment(Query<T> query, boolean defaultValue) {
        return QueryContexts.parseBoolean(query, "bySegment", defaultValue);
    }

    public static <T> boolean isPopulateCache(Query<T> query) {
        return QueryContexts.isPopulateCache(query, true);
    }

    public static <T> boolean isPopulateCache(Query<T> query, boolean defaultValue) {
        return QueryContexts.parseBoolean(query, "populateCache", defaultValue);
    }

    public static <T> boolean isUseCache(Query<T> query) {
        return QueryContexts.isUseCache(query, true);
    }

    public static <T> boolean isUseCache(Query<T> query, boolean defaultValue) {
        return QueryContexts.parseBoolean(query, USE_CACHE_KEY, defaultValue);
    }

    public static <T> boolean isPopulateResultLevelCache(Query<T> query) {
        return QueryContexts.isPopulateResultLevelCache(query, true);
    }

    public static <T> boolean isPopulateResultLevelCache(Query<T> query, boolean defaultValue) {
        return QueryContexts.parseBoolean(query, "populateResultLevelCache", defaultValue);
    }

    public static <T> boolean isUseResultLevelCache(Query<T> query) {
        return QueryContexts.isUseResultLevelCache(query, true);
    }

    public static <T> boolean isUseResultLevelCache(Query<T> query, boolean defaultValue) {
        return QueryContexts.parseBoolean(query, "useResultLevelCache", defaultValue);
    }

    public static <T> boolean isFinalize(Query<T> query, boolean defaultValue) {
        return QueryContexts.parseBoolean(query, FINALIZE_KEY, defaultValue);
    }

    public static <T> boolean isSerializeDateTimeAsLong(Query<T> query, boolean defaultValue) {
        return QueryContexts.parseBoolean(query, "serializeDateTimeAsLong", defaultValue);
    }

    public static <T> boolean isSerializeDateTimeAsLongInner(Query<T> query, boolean defaultValue) {
        return QueryContexts.parseBoolean(query, "serializeDateTimeAsLongInner", defaultValue);
    }

    public static <T> Vectorize getVectorize(Query<T> query) {
        return QueryContexts.getVectorize(query, DEFAULT_VECTORIZE);
    }

    public static <T> Vectorize getVectorize(Query<T> query, Vectorize defaultValue) {
        return QueryContexts.parseEnum(query, VECTORIZE_KEY, Vectorize.class, defaultValue);
    }

    public static <T> Vectorize getVectorizeVirtualColumns(Query<T> query) {
        return QueryContexts.getVectorizeVirtualColumns(query, DEFAULT_VECTORIZE_VIRTUAL_COLUMN);
    }

    public static <T> Vectorize getVectorizeVirtualColumns(Query<T> query, Vectorize defaultValue) {
        return QueryContexts.parseEnum(query, VECTORIZE_VIRTUAL_COLUMNS_KEY, Vectorize.class, defaultValue);
    }

    public static <T> int getVectorSize(Query<T> query) {
        return QueryContexts.getVectorSize(query, 512);
    }

    public static <T> int getVectorSize(Query<T> query, int defaultSize) {
        return QueryContexts.parseInt(query, VECTOR_SIZE_KEY, defaultSize);
    }

    public static <T> int getMaxSubqueryRows(Query<T> query, int defaultSize) {
        return QueryContexts.parseInt(query, MAX_SUBQUERY_ROWS_KEY, defaultSize);
    }

    public static <T> int getUncoveredIntervalsLimit(Query<T> query) {
        return QueryContexts.getUncoveredIntervalsLimit(query, 0);
    }

    public static <T> int getUncoveredIntervalsLimit(Query<T> query, int defaultValue) {
        return QueryContexts.parseInt(query, "uncoveredIntervalsLimit", defaultValue);
    }

    public static <T> int getPriority(Query<T> query) {
        return QueryContexts.getPriority(query, 0);
    }

    public static <T> int getPriority(Query<T> query, int defaultValue) {
        return QueryContexts.parseInt(query, PRIORITY_KEY, defaultValue);
    }

    public static <T> String getLane(Query<T> query) {
        return (String)query.getContextValue(LANE_KEY);
    }

    public static <T> boolean getEnableParallelMerges(Query<T> query) {
        return QueryContexts.parseBoolean(query, BROKER_PARALLEL_MERGE_KEY, true);
    }

    public static <T> int getParallelMergeInitialYieldRows(Query<T> query, int defaultValue) {
        return QueryContexts.parseInt(query, BROKER_PARALLEL_MERGE_INITIAL_YIELD_ROWS_KEY, defaultValue);
    }

    public static <T> int getParallelMergeSmallBatchRows(Query<T> query, int defaultValue) {
        return QueryContexts.parseInt(query, BROKER_PARALLEL_MERGE_SMALL_BATCH_ROWS_KEY, defaultValue);
    }

    public static <T> int getParallelMergeParallelism(Query<T> query, int defaultValue) {
        return QueryContexts.parseInt(query, BROKER_PARALLELISM, defaultValue);
    }

    public static <T> boolean getEnableJoinFilterRewriteValueColumnFilters(Query<T> query) {
        return QueryContexts.parseBoolean(query, JOIN_FILTER_REWRITE_VALUE_COLUMN_FILTERS_ENABLE_KEY, false);
    }

    public static <T> long getJoinFilterRewriteMaxSize(Query<T> query) {
        return QueryContexts.parseLong(query, JOIN_FILTER_REWRITE_MAX_SIZE_KEY, 10000L);
    }

    public static <T> boolean getEnableJoinFilterPushDown(Query<T> query) {
        return QueryContexts.parseBoolean(query, JOIN_FILTER_PUSH_DOWN_KEY, true);
    }

    public static <T> boolean getEnableJoinFilterRewrite(Query<T> query) {
        return QueryContexts.parseBoolean(query, JOIN_FILTER_REWRITE_ENABLE_KEY, true);
    }

    public static <T> boolean isSecondaryPartitionPruningEnabled(Query<T> query) {
        return QueryContexts.parseBoolean(query, SECONDARY_PARTITION_PRUNING_KEY, true);
    }

    public static <T> Query<T> withMaxScatterGatherBytes(Query<T> query, long maxScatterGatherBytesLimit) {
        Object obj = query.getContextValue(MAX_SCATTER_GATHER_BYTES_KEY);
        if (obj == null) {
            return query.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)MAX_SCATTER_GATHER_BYTES_KEY, (Object)maxScatterGatherBytesLimit));
        }
        long curr = ((Number)obj).longValue();
        if (curr > maxScatterGatherBytesLimit) {
            throw new IAE("configured [%s = %s] is more than enforced limit of [%s].", new Object[]{MAX_SCATTER_GATHER_BYTES_KEY, curr, maxScatterGatherBytesLimit});
        }
        return query;
    }

    public static <T> Query<T> verifyMaxQueryTimeout(Query<T> query, long maxQueryTimeout) {
        long timeout = QueryContexts.getTimeout(query);
        if (timeout > maxQueryTimeout) {
            throw new IAE("configured [%s = %s] is more than enforced limit of maxQueryTimeout [%s].", new Object[]{TIMEOUT_KEY, timeout, maxQueryTimeout});
        }
        return query;
    }

    public static <T> long getMaxQueuedBytes(Query<T> query, long defaultValue) {
        return QueryContexts.parseLong(query, MAX_QUEUED_BYTES_KEY, defaultValue);
    }

    public static <T> long getMaxScatterGatherBytes(Query<T> query) {
        return QueryContexts.parseLong(query, MAX_SCATTER_GATHER_BYTES_KEY, Long.MAX_VALUE);
    }

    public static <T> boolean hasTimeout(Query<T> query) {
        return QueryContexts.getTimeout(query) != 0L;
    }

    public static <T> long getTimeout(Query<T> query) {
        return QueryContexts.getTimeout(query, QueryContexts.getDefaultTimeout(query));
    }

    public static <T> long getTimeout(Query<T> query, long defaultTimeout) {
        long timeout = QueryContexts.parseLong(query, TIMEOUT_KEY, defaultTimeout);
        Preconditions.checkState((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout must be a non negative value, but was [%s]", (Object[])new Object[]{timeout});
        return timeout;
    }

    public static <T> Query<T> withTimeout(Query<T> query, long timeout) {
        return query.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)TIMEOUT_KEY, (Object)timeout));
    }

    public static <T> Query<T> withDefaultTimeout(Query<T> query, long defaultTimeout) {
        return query.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)DEFAULT_TIMEOUT_KEY, (Object)defaultTimeout));
    }

    static <T> long getDefaultTimeout(Query<T> query) {
        long defaultTimeout = QueryContexts.parseLong(query, DEFAULT_TIMEOUT_KEY, DEFAULT_TIMEOUT_MILLIS);
        Preconditions.checkState((defaultTimeout >= 0L ? 1 : 0) != 0, (String)"Timeout must be a non negative value, but was [%s]", (Object[])new Object[]{defaultTimeout});
        return defaultTimeout;
    }

    public static <T> int getNumRetriesOnMissingSegments(Query<T> query, int defaultValue) {
        return query.getContextValue(NUM_RETRIES_ON_MISSING_SEGMENTS_KEY, defaultValue);
    }

    public static <T> boolean allowReturnPartialResults(Query<T> query, boolean defaultValue) {
        return query.getContextBoolean(RETURN_PARTIAL_RESULTS_KEY, defaultValue);
    }

    static <T> long parseLong(Query<T> query, String key, long defaultValue) {
        Object val = query.getContextValue(key);
        return val == null ? defaultValue : Numbers.parseLong(val);
    }

    static <T> int parseInt(Query<T> query, String key, int defaultValue) {
        Object val = query.getContextValue(key);
        return val == null ? defaultValue : Numbers.parseInt(val);
    }

    static <T> boolean parseBoolean(Query<T> query, String key, boolean defaultValue) {
        Object val = query.getContextValue(key);
        return val == null ? defaultValue : Numbers.parseBoolean(val);
    }

    private QueryContexts() {
    }

    static <T, E extends Enum<E>> E parseEnum(Query<T> query, String key, Class<E> clazz, E defaultValue) {
        Object val = query.getContextValue(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof String) {
            return Enum.valueOf(clazz, StringUtils.toUpperCase((String)((String)val)));
        }
        if (val instanceof Boolean) {
            return Enum.valueOf(clazz, StringUtils.toUpperCase((String)String.valueOf(val)));
        }
        throw new ISE("Unknown type [%s]. Cannot parse!", new Object[]{val.getClass()});
    }

    public static enum Vectorize {
        FALSE{

            @Override
            public boolean shouldVectorize(boolean canVectorize) {
                return false;
            }
        }
        ,
        TRUE{

            @Override
            public boolean shouldVectorize(boolean canVectorize) {
                return canVectorize;
            }
        }
        ,
        FORCE{

            @Override
            public boolean shouldVectorize(boolean canVectorize) {
                if (!canVectorize) {
                    throw new ISE("Cannot vectorize!", new Object[0]);
                }
                return true;
            }
        };


        public abstract boolean shouldVectorize(boolean var1);

        @JsonCreator
        public static Vectorize fromString(String str) {
            return Vectorize.valueOf(StringUtils.toUpperCase((String)str));
        }

        @JsonValue
        public String toString() {
            return StringUtils.toLowerCase((String)this.name()).replace('_', '-');
        }
    }
}

