/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.FilteredAggregator;
import org.apache.druid.query.aggregation.FilteredBufferAggregator;
import org.apache.druid.query.aggregation.FilteredVectorAggregator;
import org.apache.druid.query.aggregation.SuppressedAggregatorFactory;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.IntervalDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class FilteredAggregatorFactory
extends AggregatorFactory {
    private final AggregatorFactory delegate;
    private final DimFilter dimFilter;
    private final Filter filter;
    @Nullable
    private final String name;

    public FilteredAggregatorFactory(AggregatorFactory delegate, DimFilter filter) {
        this(delegate, filter, null);
    }

    @JsonCreator
    public FilteredAggregatorFactory(@JsonProperty(value="aggregator") AggregatorFactory delegate, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="name") @Nullable String name) {
        Preconditions.checkNotNull((Object)delegate, (Object)"aggregator");
        Preconditions.checkNotNull((Object)dimFilter, (Object)"filter");
        this.delegate = delegate;
        this.dimFilter = dimFilter;
        this.filter = dimFilter.toFilter();
        this.name = name;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory columnSelectorFactory) {
        ValueMatcher valueMatcher = this.filter.makeMatcher(columnSelectorFactory);
        return new FilteredAggregator(valueMatcher, this.delegate.factorize(columnSelectorFactory));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        ValueMatcher valueMatcher = this.filter.makeMatcher(columnSelectorFactory);
        return new FilteredBufferAggregator(valueMatcher, this.delegate.factorizeBuffered(columnSelectorFactory));
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory) {
        Preconditions.checkState((boolean)this.canVectorize(columnSelectorFactory), (Object)"Cannot vectorize");
        VectorValueMatcher valueMatcher = this.filter.makeVectorMatcher(columnSelectorFactory);
        return new FilteredVectorAggregator(valueMatcher, this.delegate.factorizeVector(columnSelectorFactory));
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return this.delegate.canVectorize(columnInspector) && this.filter.canVectorizeMatcher();
    }

    @Override
    public Comparator getComparator() {
        return this.delegate.getComparator();
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return this.delegate.combine(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return this.delegate.makeAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return this.delegate.getCombiningFactory();
    }

    @Override
    public Object deserialize(Object object) {
        return this.delegate.deserialize(object);
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return this.delegate.finalizeComputation(object);
    }

    @Override
    @JsonProperty
    public String getName() {
        String name = this.name;
        if (Strings.isNullOrEmpty((String)name)) {
            name = this.delegate.getName();
        }
        return name;
    }

    @Override
    public List<String> requiredFields() {
        return this.delegate.requiredFields();
    }

    public byte[] getCacheKey() {
        byte[] filterCacheKey = this.dimFilter.getCacheKey();
        byte[] aggregatorCacheKey = this.delegate.getCacheKey();
        return ByteBuffer.allocate(1 + filterCacheKey.length + aggregatorCacheKey.length).put((byte)9).put(filterCacheKey).put(aggregatorCacheKey).array();
    }

    @Override
    public String getComplexTypeName() {
        return this.delegate.getComplexTypeName();
    }

    @Override
    public ValueType getType() {
        return this.delegate.getType();
    }

    @Override
    public ValueType getFinalizedType() {
        return this.delegate.getFinalizedType();
    }

    @Override
    public int getMaxIntermediateSize() {
        return this.delegate.getMaxIntermediateSizeWithNulls();
    }

    @Override
    public AggregatorFactory optimizeForSegment(PerSegmentQueryOptimizationContext optimizationContext) {
        if (this.dimFilter instanceof IntervalDimFilter) {
            IntervalDimFilter intervalDimFilter = (IntervalDimFilter)this.dimFilter;
            if (intervalDimFilter.getExtractionFn() != null) {
                return this;
            }
            if (!intervalDimFilter.getDimension().equals("__time")) {
                return this;
            }
            Interval segmentInterval = optimizationContext.getSegmentDescriptor().getInterval();
            List<Interval> filterIntervals = intervalDimFilter.getIntervals();
            ArrayList<Interval> excludedFilterIntervals = new ArrayList<Interval>();
            ArrayList<Interval> effectiveFilterIntervals = new ArrayList<Interval>();
            boolean segmentIsCovered = false;
            for (Interval filterInterval : filterIntervals) {
                Interval overlap = filterInterval.overlap((ReadableInterval)segmentInterval);
                if (overlap == null) {
                    excludedFilterIntervals.add(filterInterval);
                    continue;
                }
                if (overlap.equals((Object)segmentInterval)) {
                    segmentIsCovered = true;
                    break;
                }
                effectiveFilterIntervals.add(overlap);
            }
            if (segmentIsCovered) {
                return this.delegate;
            }
            if (excludedFilterIntervals.size() == filterIntervals.size()) {
                return new SuppressedAggregatorFactory(this.delegate);
            }
            return new FilteredAggregatorFactory(this.delegate, new IntervalDimFilter(intervalDimFilter.getDimension(), effectiveFilterIntervals, intervalDimFilter.getExtractionFn(), intervalDimFilter.getFilterTuning()), this.name);
        }
        return this;
    }

    @JsonProperty
    public AggregatorFactory getAggregator() {
        return this.delegate;
    }

    @JsonProperty
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return this.delegate.getRequiredColumns();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredAggregatorFactory that = (FilteredAggregatorFactory)o;
        return Objects.equals(this.delegate, that.delegate) && Objects.equals(this.dimFilter, that.dimFilter) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.delegate, this.dimFilter, this.name);
    }

    public String toString() {
        return "FilteredAggregatorFactory{delegate=" + this.delegate + ", dimFilter=" + this.dimFilter + ", name='" + this.name + '\'' + '}';
    }
}

