/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;

public class TimestampParseExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_parse";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 1 || args.size() > 3) {
            throw new IAE("Function[%s] must have 1 to 3 arguments", new Object[]{this.name()});
        }
        Expr arg = args.get(0);
        String formatString = args.size() > 1 ? (String)args.get(1).getLiteralValue() : null;
        DateTimeZone timeZone = args.size() > 2 && args.get(2).getLiteralValue() != null ? DateTimes.inferTzFromString((String)((String)args.get(2).getLiteralValue())) : DateTimeZone.UTC;
        DateTimes.UtcFormatter formatter = formatString == null ? TimestampParseExprMacro.createDefaultParser(timeZone) : DateTimes.wrapFormatter((DateTimeFormatter)DateTimeFormat.forPattern((String)formatString).withZone(timeZone));
        class TimestampParseExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            final /* synthetic */ DateTimes.UtcFormatter val$formatter;
            final /* synthetic */ List val$args;

            TimestampParseExpr(Expr arg) {
                this.val$formatter = utcFormatter;
                this.val$args = list;
                super(TimestampParseExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                String value = this.arg.eval(bindings).asString();
                if (value == null) {
                    return ExprEval.of(null);
                }
                try {
                    return ExprEval.of((long)this.val$formatter.parse(value).getMillis());
                }
                catch (IllegalArgumentException e) {
                    return ExprEval.of(null);
                }
            }

            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit((Expr)new TimestampParseExpr(newArg));
            }

            @Nullable
            public ExprType getOutputType(Expr.InputBindingInspector inspector) {
                return ExprType.LONG;
            }

            public String stringify() {
                if (this.val$args.size() > 2) {
                    return StringUtils.format((String)"%s(%s, %s, %s)", (Object[])new Object[]{TimestampParseExprMacro.FN_NAME, this.arg.stringify(), ((Expr)this.val$args.get(1)).stringify(), ((Expr)this.val$args.get(2)).stringify()});
                }
                if (this.val$args.size() > 1) {
                    return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{TimestampParseExprMacro.FN_NAME, this.arg.stringify(), ((Expr)this.val$args.get(1)).stringify()});
                }
                return super.stringify();
            }
        }
        return new TimestampParseExpr(arg);
    }

    private static DateTimes.UtcFormatter createDefaultParser(DateTimeZone timeZone) {
        DateTimeFormatter offsetElement = new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
        DateTimeParser timeOrOffset = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().appendLiteral('T').toParser(), new DateTimeFormatterBuilder().appendLiteral(' ').toParser()}).appendOptional(ISODateTimeFormat.timeElementParser().getParser()).appendOptional(offsetElement.getParser()).toParser();
        return DateTimes.wrapFormatter((DateTimeFormatter)new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateElementParser()).appendOptional(timeOrOffset).toFormatter().withZone(timeZone));
    }
}

