/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;

public class TimestampShiftExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_shift";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 3 || args.size() > 4) {
            throw new IAE("Function[%s] must have 3 to 4 arguments", new Object[]{this.name()});
        }
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampShiftExpr(args);
        }
        return new TimestampShiftDynamicExpr(args);
    }

    private static Period getPeriod(List<Expr> args, Expr.ObjectBinding bindings) {
        return new Period((Object)args.get(1).eval(bindings).asString());
    }

    private static int getStep(List<Expr> args, Expr.ObjectBinding bindings) {
        return args.get(2).eval(bindings).asInt();
    }

    private static ISOChronology getTimeZone(List<Expr> args, Expr.ObjectBinding bindings) {
        Expr timeZoneArg;
        Expr expr = timeZoneArg = args.size() > 3 ? args.get(3) : null;
        if (timeZoneArg == null) {
            return ISOChronology.getInstance(null);
        }
        String zone = timeZoneArg.eval(bindings).asString();
        return ISOChronology.getInstance((DateTimeZone)(zone != null ? DateTimes.inferTzFromString((String)zone) : null));
    }

    private static class TimestampShiftDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampShiftDynamicExpr(List<Expr> args) {
            super(TimestampShiftExprMacro.FN_NAME, args);
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            Period period = TimestampShiftExprMacro.getPeriod(this.args, bindings);
            ISOChronology chronology = TimestampShiftExprMacro.getTimeZone(this.args, bindings);
            int step = TimestampShiftExprMacro.getStep(this.args, bindings);
            return ExprEval.of((long)chronology.add((ReadablePeriod)period, ((Expr)this.args.get(0)).eval(bindings).asLong(), step));
        }

        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit((Expr)new TimestampShiftDynamicExpr(newArgs));
        }

        @Nullable
        public ExprType getOutputType(Expr.InputBindingInspector inspector) {
            return ExprType.LONG;
        }
    }

    private static class TimestampShiftExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final Chronology chronology;
        private final Period period;
        private final int step;

        TimestampShiftExpr(List<Expr> args) {
            super(TimestampShiftExprMacro.FN_NAME, args);
            this.period = TimestampShiftExprMacro.getPeriod(args, ExprUtils.nilBindings());
            this.chronology = TimestampShiftExprMacro.getTimeZone(args, ExprUtils.nilBindings());
            this.step = TimestampShiftExprMacro.getStep(args, ExprUtils.nilBindings());
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            return ExprEval.of((long)this.chronology.add((ReadablePeriod)this.period, ((Expr)this.args.get(0)).eval(bindings).asLong(), this.step));
        }

        public Expr visit(Expr.Shuttle shuttle) {
            List<Expr> newArgs = this.args.stream().map(x -> x.visit(shuttle)).collect(Collectors.toList());
            return shuttle.visit((Expr)new TimestampShiftExpr(newArgs));
        }

        @Nullable
        public ExprType getOutputType(Expr.InputBindingInspector inspector) {
            return ExprType.LONG;
        }
    }
}

