/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import javax.annotation.Nullable;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.Result;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.TopNAlgorithm;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryMetrics;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.query.topn.types.TopNColumnAggregatesProcessor;
import org.apache.druid.query.topn.types.TopNColumnAggregatesProcessorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;

public class TopNMapFn {
    private final TopNQuery query;
    private final TopNAlgorithm topNAlgorithm;

    public TopNMapFn(TopNQuery query, TopNAlgorithm topNAlgorithm) {
        this.query = query;
        this.topNAlgorithm = topNAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Result<TopNResultValue> apply(Cursor cursor, @Nullable TopNQueryMetrics queryMetrics) {
        ColumnSelectorPlus<TopNColumnAggregatesProcessor> selectorPlus = DimensionHandlerUtils.createColumnSelectorPlus(new TopNColumnAggregatesProcessorFactory(this.query.getDimensionSpec().getOutputType()), this.query.getDimensionSpec(), cursor.getColumnSelectorFactory());
        if (selectorPlus.getSelector() == null) {
            return null;
        }
        TopNParams params = null;
        try {
            params = this.topNAlgorithm.makeInitParams(selectorPlus, cursor);
            if (queryMetrics != null) {
                queryMetrics.columnValueSelector(selectorPlus.getSelector());
                queryMetrics.numValuesPerPass(params);
            }
            TopNResultBuilder resultBuilder = BaseTopNAlgorithm.makeResultBuilder(params, this.query);
            this.topNAlgorithm.run(params, resultBuilder, null, queryMetrics);
            Result<TopNResultValue> result = resultBuilder.build();
            return result;
        }
        finally {
            this.topNAlgorithm.cleanup(params);
        }
    }
}

