/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.data.ReadableOffset;

public class SimpleAscendingOffset
extends SimpleSettableOffset {
    private final int rowCount;
    private final int initialOffset;
    private int currentOffset;

    public SimpleAscendingOffset(int rowCount) {
        this(0, rowCount);
    }

    private SimpleAscendingOffset(int initialOffset, int rowCount) {
        this.initialOffset = initialOffset;
        this.currentOffset = initialOffset;
        this.rowCount = rowCount;
    }

    @Override
    public void increment() {
        ++this.currentOffset;
    }

    @Override
    public boolean withinBounds() {
        return this.currentOffset < this.rowCount;
    }

    @Override
    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = currentOffset;
    }

    @Override
    public void reset() {
        this.currentOffset = this.initialOffset;
    }

    @Override
    public ReadableOffset getBaseReadableOffset() {
        return this;
    }

    @Override
    public Offset clone() {
        return new SimpleAscendingOffset(this.currentOffset, this.rowCount);
    }

    @Override
    public int getOffset() {
        return this.currentOffset;
    }

    public String toString() {
        return this.currentOffset + "/" + this.rowCount;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }
}

