/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.serde.Serializer;

public class CompressedColumnarLongsSupplier
implements Supplier<ColumnarLongs>,
Serializer {
    public static final byte LZF_VERSION = 1;
    public static final byte VERSION = 2;
    private static final MetaSerdeHelper<CompressedColumnarLongsSupplier> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.totalSize).writeInt(x -> x.sizePer).maybeWriteByte(x -> x.encoding != CompressionFactory.LEGACY_LONG_ENCODING_FORMAT, x -> CompressionFactory.setEncodingFlag(x.compression.getId())).writeByte(x -> {
        if (x.encoding != CompressionFactory.LEGACY_LONG_ENCODING_FORMAT) {
            return x.encoding.getId();
        }
        return x.compression.getId();
    });
    private final int totalSize;
    private final int sizePer;
    private final ByteBuffer buffer;
    private final Supplier<ColumnarLongs> supplier;
    private final CompressionStrategy compression;
    private final CompressionFactory.LongEncodingFormat encoding;

    CompressedColumnarLongsSupplier(int totalSize, int sizePer, ByteBuffer buffer, Supplier<ColumnarLongs> supplier, CompressionStrategy compression, CompressionFactory.LongEncodingFormat encoding) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.buffer = buffer;
        this.supplier = supplier;
        this.compression = compression;
        this.encoding = encoding;
    }

    public ColumnarLongs get() {
        return (ColumnarLongs)this.supplier.get();
    }

    @Override
    public long getSerializedSize() {
        return (long)META_SERDE_HELPER.size(this) + (long)this.buffer.remaining();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        META_SERDE_HELPER.writeTo(channel, this);
        Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)this.buffer.asReadOnlyBuffer());
    }

    public static CompressedColumnarLongsSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1 || versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressionStrategy compression = CompressionStrategy.LZF;
            CompressionFactory.LongEncodingFormat encoding = CompressionFactory.LEGACY_LONG_ENCODING_FORMAT;
            if (versionFromBuffer == 2) {
                byte compressionId = buffer.get();
                if (CompressionFactory.hasEncodingFlag(compressionId)) {
                    encoding = CompressionFactory.LongEncodingFormat.forId(buffer.get());
                    compressionId = CompressionFactory.clearEncodingFlag(compressionId);
                }
                compression = CompressionStrategy.forId(compressionId);
            }
            Supplier<ColumnarLongs> supplier = CompressionFactory.getLongSupplier(totalSize, sizePer, buffer.asReadOnlyBuffer(), order, encoding, compression);
            return new CompressedColumnarLongsSupplier(totalSize, sizePer, buffer, supplier, compression, encoding);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }
}

