/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.ColumnCapacityExceededException;
import org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class EntireLayoutColumnarLongsSerializer
implements ColumnarLongsSerializer {
    private static final MetaSerdeHelper<EntireLayoutColumnarLongsSerializer> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> 0).writeSomething(CompressionFactory.longEncodingWriter(x -> x.writer, x -> CompressionStrategy.NONE));
    private final String columnName;
    private final CompressionFactory.LongEncodingWriter writer;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private WriteOutBytes valuesOut;
    private int numInserted = 0;

    EntireLayoutColumnarLongsSerializer(String columnName, SegmentWriteOutMedium segmentWriteOutMedium, CompressionFactory.LongEncodingWriter writer) {
        this.columnName = columnName;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.writer = writer;
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.writer.setOutputStream(this.valuesOut);
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(long value) throws IOException {
        this.writer.write(value);
        ++this.numInserted;
        if (this.numInserted < 0) {
            throw new ColumnCapacityExceededException(this.columnName);
        }
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writer.flush();
        return (long)META_SERDE_HELPER.size(this) + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writer.flush();
        META_SERDE_HELPER.writeTo(channel, this);
        this.valuesOut.writeTo(channel);
    }
}

