/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.FalseVectorMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.filter.FalseValueMatcher;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class FalseFilter
implements Filter {
    private static final FalseFilter INSTANCE = new FalseFilter();

    public static FalseFilter instance() {
        return INSTANCE;
    }

    private FalseFilter() {
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        return 0.0;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return FalseValueMatcher.instance();
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return new FalseVectorMatcher(factory.getReadableVectorInspector());
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return true;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return true;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return true;
    }

    @Override
    public boolean canVectorizeMatcher() {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return Collections.emptySet();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        return this;
    }

    public String toString() {
        return "false";
    }

    public final int hashCode() {
        return FalseFilter.class.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj instanceof FalseFilter;
    }
}

