/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.distribution.ZipfDistribution;
import org.apache.commons.math3.util.Pair;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.generator.EnumeratedTreeDistribution;
import org.apache.druid.segment.generator.GeneratorColumnSchema;
import org.apache.druid.segment.generator.RealRoundingDistribution;
import org.apache.druid.segment.generator.SequentialDistribution;

public class ColumnValueGenerator {
    private final GeneratorColumnSchema schema;
    private final long seed;
    private Serializable distribution;
    private Random simpleRng;

    public ColumnValueGenerator(GeneratorColumnSchema schema, long seed) {
        this.schema = schema;
        this.seed = seed;
        this.simpleRng = new Random(seed);
        this.initDistribution();
    }

    public Object generateRowValue() {
        double randDouble;
        Double nullProbability = this.schema.getNullProbability();
        int rowSize = this.schema.getRowSize();
        if (nullProbability != null && (randDouble = this.simpleRng.nextDouble()) <= nullProbability) {
            return null;
        }
        if (rowSize == 1) {
            return this.generateSingleRowValue();
        }
        ArrayList<Object> rowVals = new ArrayList<Object>(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            rowVals.add(this.generateSingleRowValue());
        }
        return rowVals;
    }

    public GeneratorColumnSchema getSchema() {
        return this.schema;
    }

    private Object generateSingleRowValue() {
        Object ret = null;
        ValueType type = this.schema.getType();
        if (this.distribution instanceof AbstractIntegerDistribution) {
            ret = ((AbstractIntegerDistribution)this.distribution).sample();
        } else if (this.distribution instanceof AbstractRealDistribution) {
            ret = ((AbstractRealDistribution)this.distribution).sample();
        } else if (this.distribution instanceof EnumeratedDistribution) {
            ret = ((EnumeratedDistribution)this.distribution).sample();
        }
        ret = this.convertType(ret, type);
        return ret;
    }

    private Object convertType(Object input, ValueType type) {
        Object ret;
        if (input == null) {
            return null;
        }
        switch (type) {
            case STRING: {
                ret = input.toString();
                break;
            }
            case LONG: {
                if (input instanceof Number) {
                    ret = ((Number)input).longValue();
                    break;
                }
                ret = Long.parseLong(input.toString());
                break;
            }
            case DOUBLE: {
                if (input instanceof Number) {
                    ret = ((Number)input).doubleValue();
                    break;
                }
                ret = Double.parseDouble(input.toString());
                break;
            }
            case FLOAT: {
                if (input instanceof Number) {
                    ret = Float.valueOf(((Number)input).floatValue());
                    break;
                }
                ret = Float.valueOf(Float.parseFloat(input.toString()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown data type: " + type);
            }
        }
        return ret;
    }

    private void initDistribution() {
        GeneratorColumnSchema.ValueDistribution distributionType = this.schema.getDistributionType();
        ValueType type = this.schema.getType();
        List<Object> enumeratedValues = this.schema.getEnumeratedValues();
        List<Double> enumeratedProbabilities = this.schema.getEnumeratedProbabilities();
        ArrayList probabilities = new ArrayList();
        switch (distributionType) {
            case SEQUENTIAL: {
                this.distribution = new SequentialDistribution(this.schema.getStartInt(), this.schema.getEndInt(), this.schema.getEnumeratedValues());
                break;
            }
            case UNIFORM: {
                this.distribution = new UniformRealDistribution(this.schema.getStartDouble().doubleValue(), this.schema.getEndDouble().doubleValue());
                break;
            }
            case DISCRETE_UNIFORM: {
                if (enumeratedValues == null) {
                    enumeratedValues = new ArrayList<Object>();
                    for (int i = this.schema.getStartInt().intValue(); i < this.schema.getEndInt(); ++i) {
                        Object val = this.convertType(i, type);
                        enumeratedValues.add(val);
                    }
                }
                for (Object enumeratedValue : enumeratedValues) {
                    probabilities.add(new Pair(enumeratedValue, (Object)0.1));
                }
                this.distribution = new EnumeratedTreeDistribution(probabilities);
                break;
            }
            case NORMAL: {
                this.distribution = new NormalDistribution(this.schema.getMean().doubleValue(), this.schema.getStandardDeviation().doubleValue());
                break;
            }
            case ROUNDED_NORMAL: {
                NormalDistribution normalDist = new NormalDistribution(this.schema.getMean().doubleValue(), this.schema.getStandardDeviation().doubleValue());
                this.distribution = new RealRoundingDistribution((AbstractRealDistribution)normalDist);
                break;
            }
            case ZIPF: {
                if (enumeratedValues == null) {
                    Integer startInt = this.schema.getStartInt();
                    int cardinality = this.schema.getEndInt() - startInt;
                    ZipfDistribution zipf = new ZipfDistribution(cardinality, this.schema.getZipfExponent().doubleValue());
                    for (int i = 0; i < cardinality; ++i) {
                        probabilities.add(new Pair((Object)(i + startInt), (Object)zipf.probability(i)));
                    }
                } else {
                    int cardinality = enumeratedValues.size();
                    ZipfDistribution zipf = new ZipfDistribution(enumeratedValues.size(), this.schema.getZipfExponent().doubleValue());
                    for (int i = 0; i < cardinality; ++i) {
                        probabilities.add(new Pair(enumeratedValues.get(i), (Object)zipf.probability(i)));
                    }
                }
                this.distribution = new EnumeratedTreeDistribution(probabilities);
                break;
            }
            case LAZY_ZIPF: {
                Integer startInt = this.schema.getStartInt();
                int lazyCardinality = this.schema.getEndInt() - startInt;
                this.distribution = new ZipfDistribution(lazyCardinality, this.schema.getZipfExponent().doubleValue());
                break;
            }
            case LAZY_DISCRETE_UNIFORM: {
                this.distribution = new UniformIntegerDistribution(this.schema.getStartInt().intValue(), this.schema.getEndInt().intValue());
                break;
            }
            case ENUMERATED: {
                for (int i = 0; i < enumeratedValues.size(); ++i) {
                    probabilities.add(new Pair(enumeratedValues.get(i), (Object)enumeratedProbabilities.get(i)));
                }
                this.distribution = new EnumeratedTreeDistribution(probabilities);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown distribution type: " + (Object)((Object)distributionType));
            }
        }
        if (this.distribution instanceof AbstractIntegerDistribution) {
            ((AbstractIntegerDistribution)this.distribution).reseedRandomGenerator(this.seed);
        } else if (this.distribution instanceof AbstractRealDistribution) {
            ((AbstractRealDistribution)this.distribution).reseedRandomGenerator(this.seed);
        } else {
            ((EnumeratedDistribution)this.distribution).reseedRandomGenerator(this.seed);
        }
    }
}

