/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Query;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.join.HashJoinSegment;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.filter.JoinFilterAnalyzer;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysisKey;
import org.apache.druid.segment.join.filter.JoinableClauses;
import org.apache.druid.segment.join.filter.rewrite.JoinFilterRewriteConfig;
import org.apache.druid.utils.JvmUtils;

public class JoinableFactoryWrapper {
    private static final byte JOIN_OPERATION = 1;
    private static final Logger log = new Logger(JoinableFactoryWrapper.class);
    private final JoinableFactory joinableFactory;

    public JoinableFactoryWrapper(JoinableFactory joinableFactory) {
        this.joinableFactory = (JoinableFactory)Preconditions.checkNotNull((Object)joinableFactory, (Object)"joinableFactory");
    }

    public Function<SegmentReference, SegmentReference> createSegmentMapFn(List<PreJoinableClause> clauses, AtomicLong cpuTimeAccumulator, Query<?> query) {
        return (Function)JvmUtils.safeAccumulateThreadCpuTime((AtomicLong)cpuTimeAccumulator, () -> {
            if (clauses.isEmpty()) {
                return Function.identity();
            }
            JoinableClauses joinableClauses = JoinableClauses.createClauses(clauses, this.joinableFactory);
            JoinFilterPreAnalysis joinFilterPreAnalysis = JoinFilterAnalyzer.computeJoinFilterPreAnalysis(new JoinFilterPreAnalysisKey(JoinFilterRewriteConfig.forQuery(query), joinableClauses.getJoinableClauses(), query.getVirtualColumns(), Filters.toFilter(query.getFilter())));
            return baseSegment -> new HashJoinSegment((SegmentReference)baseSegment, joinableClauses.getJoinableClauses(), joinFilterPreAnalysis);
        });
    }

    public Optional<byte[]> computeJoinDataSourceCacheKey(DataSourceAnalysis dataSourceAnalysis) {
        List<PreJoinableClause> clauses = dataSourceAnalysis.getPreJoinableClauses();
        if (clauses.isEmpty()) {
            throw new IAE("No join clauses to build the cache key for data source [%s]", new Object[]{dataSourceAnalysis.getDataSource()});
        }
        CacheKeyBuilder keyBuilder = new CacheKeyBuilder(1);
        for (PreJoinableClause clause : clauses) {
            Optional<byte[]> bytes = this.joinableFactory.computeJoinCacheKey(clause.getDataSource(), clause.getCondition());
            if (!bytes.isPresent()) {
                log.debug("skipping caching for join since [%s] does not support caching", new Object[]{clause.getDataSource()});
                return Optional.empty();
            }
            keyBuilder.appendByteArray(bytes.get());
            keyBuilder.appendString(clause.getCondition().getOriginalExpression());
            keyBuilder.appendString(clause.getPrefix());
            keyBuilder.appendString(clause.getJoinType().name());
        }
        return Optional.of(keyBuilder.build());
    }
}

