/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.Rows;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.transform.RowFunction;
import org.apache.druid.segment.transform.Transform;
import org.apache.druid.segment.transform.TransformSpec;
import org.joda.time.DateTime;

public class Transformer {
    private final Map<String, RowFunction> transforms = new HashMap<String, RowFunction>();
    private final ThreadLocal<Row> rowSupplierForValueMatcher = new ThreadLocal();
    private final ValueMatcher valueMatcher;

    Transformer(TransformSpec transformSpec) {
        for (Transform transform : transformSpec.getTransforms()) {
            this.transforms.put(transform.getName(), transform.getRowFunction());
        }
        this.valueMatcher = transformSpec.getFilter() != null ? transformSpec.getFilter().toFilter().makeMatcher(RowBasedColumnSelectorFactory.create(RowAdapters.standardRow(), this.rowSupplierForValueMatcher::get, RowSignature.empty(), false)) : null;
    }

    @Nullable
    public InputRow transform(@Nullable InputRow row) {
        if (row == null) {
            return null;
        }
        Object transformedRow = this.transforms.isEmpty() ? row : new TransformedInputRow(row, this.transforms);
        if (this.valueMatcher != null) {
            this.rowSupplierForValueMatcher.set((Row)transformedRow);
            if (!this.valueMatcher.matches()) {
                return null;
            }
        }
        return transformedRow;
    }

    @Nullable
    public InputRowListPlusRawValues transform(@Nullable InputRowListPlusRawValues row) {
        InputRowListPlusRawValues inputRowListPlusRawValues;
        if (row == null) {
            return null;
        }
        if (this.transforms.isEmpty() || row.getInputRows() == null) {
            inputRowListPlusRawValues = row;
        } else {
            List originalRows = row.getInputRows();
            ArrayList<TransformedInputRow> transformedRows = new ArrayList<TransformedInputRow>(originalRows.size());
            for (InputRow originalRow : originalRows) {
                transformedRows.add(new TransformedInputRow(originalRow, this.transforms));
            }
            inputRowListPlusRawValues = InputRowListPlusRawValues.ofList((List)row.getRawValuesList(), transformedRows);
        }
        if (this.valueMatcher != null && inputRowListPlusRawValues.getInputRows() != null) {
            int size = inputRowListPlusRawValues.getInputRows().size();
            ArrayList matchedRows = new ArrayList(size);
            ArrayList matchedVals = new ArrayList(size);
            List inputRows = inputRowListPlusRawValues.getInputRows();
            List inputVals = inputRowListPlusRawValues.getRawValuesList();
            for (int i = 0; i < size; ++i) {
                this.rowSupplierForValueMatcher.set((Row)inputRows.get(i));
                if (!this.valueMatcher.matches()) continue;
                matchedRows.add(inputRows.get(i));
                matchedVals.add(inputVals.get(i));
            }
            return InputRowListPlusRawValues.ofList(matchedVals, matchedRows);
        }
        return inputRowListPlusRawValues;
    }

    public static class TransformedInputRow
    implements InputRow {
        private final InputRow row;
        private final Map<String, RowFunction> transforms;

        public TransformedInputRow(InputRow row, Map<String, RowFunction> transforms) {
            this.row = row;
            this.transforms = transforms;
        }

        public List<String> getDimensions() {
            return this.row.getDimensions();
        }

        public long getTimestampFromEpoch() {
            RowFunction transform = this.transforms.get("__time");
            if (transform != null) {
                return Rows.objectToNumber((String)"__time", (Object)transform.eval((Row)this.row), (boolean)true).longValue();
            }
            return this.row.getTimestampFromEpoch();
        }

        public DateTime getTimestamp() {
            RowFunction transform = this.transforms.get("__time");
            if (transform != null) {
                return DateTimes.utc((long)this.getTimestampFromEpoch());
            }
            return this.row.getTimestamp();
        }

        public List<String> getDimension(String dimension) {
            RowFunction transform = this.transforms.get(dimension);
            if (transform != null) {
                return Rows.objectToStrings((Object)transform.eval((Row)this.row));
            }
            return this.row.getDimension(dimension);
        }

        public Object getRaw(String column) {
            RowFunction transform = this.transforms.get(column);
            if (transform != null) {
                return transform.eval((Row)this.row);
            }
            return this.row.getRaw(column);
        }

        public Number getMetric(String metric) {
            RowFunction transform = this.transforms.get(metric);
            if (transform != null) {
                return Rows.objectToNumber((String)metric, (Object)transform.eval((Row)this.row), (boolean)true);
            }
            return this.row.getMetric(metric);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransformedInputRow that = (TransformedInputRow)o;
            return Objects.equals(this.row, that.row) && Objects.equals(this.transforms, that.transforms);
        }

        public int hashCode() {
            return Objects.hash(this.row, this.transforms);
        }

        public int compareTo(Row o) {
            return this.row.compareTo((Object)o);
        }

        public String toString() {
            return "TransformedInputRow{row=" + this.row + '}';
        }
    }
}

