/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.join.JoinType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class JoinDataSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final TableDataSource fooTable = new TableDataSource("foo");
    private final TableDataSource barTable = new TableDataSource("bar");
    private final LookupDataSource lookylooLookup = new LookupDataSource("lookyloo");
    private final JoinDataSource joinTableToLookup = JoinDataSource.create((DataSource)this.fooTable, (DataSource)this.lookylooLookup, (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil());
    private final JoinDataSource joinTableToTable = JoinDataSource.create((DataSource)this.fooTable, (DataSource)this.barTable, (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil());

    @Test
    public void test_getTableNames_tableToTable() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"bar"), (Object)this.joinTableToTable.getTableNames());
    }

    @Test
    public void test_getTableNames_tableToLookup() {
        Assert.assertEquals(Collections.singleton("foo"), (Object)this.joinTableToLookup.getTableNames());
    }

    @Test
    public void test_getChildren_tableToTable() {
        Assert.assertEquals((Object)ImmutableList.of((Object)this.fooTable, (Object)this.barTable), (Object)this.joinTableToTable.getChildren());
    }

    @Test
    public void test_getChildren_tableToLookup() {
        Assert.assertEquals((Object)ImmutableList.of((Object)this.fooTable, (Object)this.lookylooLookup), (Object)this.joinTableToLookup.getChildren());
    }

    @Test
    public void test_isCacheable_tableToTable() {
        Assert.assertTrue((boolean)this.joinTableToTable.isCacheable(true));
        Assert.assertTrue((boolean)this.joinTableToTable.isCacheable(false));
    }

    @Test
    public void test_isCacheable_lookup() {
        Assert.assertFalse((boolean)this.joinTableToLookup.isCacheable(true));
        Assert.assertFalse((boolean)this.joinTableToLookup.isCacheable(false));
    }

    @Test
    public void test_isConcrete_tableToTable() {
        Assert.assertFalse((boolean)this.joinTableToTable.isConcrete());
    }

    @Test
    public void test_isConcrete_tableToLookup() {
        Assert.assertFalse((boolean)this.joinTableToLookup.isConcrete());
    }

    @Test
    public void test_isGlobal_tableToTable() {
        Assert.assertFalse((boolean)this.joinTableToTable.isGlobal());
    }

    @Test
    public void test_isGlobal_tableToLookup() {
        Assert.assertFalse((boolean)this.joinTableToLookup.isGlobal());
    }

    @Test
    public void test_withChildren_empty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected [2] children, got [0]");
        DataSource ignored = this.joinTableToTable.withChildren(Collections.emptyList());
    }

    @Test
    public void test_withChildren_two() {
        DataSource transformed = this.joinTableToTable.withChildren((List)ImmutableList.of((Object)this.fooTable, (Object)this.lookylooLookup));
        Assert.assertEquals((Object)this.joinTableToLookup, (Object)transformed);
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(JoinDataSource.class).usingGetClass().withNonnullFields(new String[]{"left", "right", "rightPrefix", "conditionAnalysis", "joinType"}).verify();
    }

    @Test
    public void test_serde() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        JoinDataSource joinDataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil());
        JoinDataSource deserialized = (JoinDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)joinDataSource), DataSource.class);
        Assert.assertEquals((Object)joinDataSource, (Object)deserialized);
    }

    @Test
    public void testException_leftFilterOnNonTableSource() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("left filter is only supported if left data source is direct table access");
        JoinDataSource ignored = JoinDataSource.create((DataSource)new QueryDataSource((Query)Mockito.mock(Query.class)), (DataSource)new TableDataSource("table"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil());
    }

    @Test
    public void testLeftFilter() {
        JoinDataSource dataSource = JoinDataSource.create((DataSource)new TableDataSource("table1"), (DataSource)new TableDataSource("table2"), (String)"j.", (String)"x == \"j.x\"", (JoinType)JoinType.LEFT, (DimFilter)TrueDimFilter.instance(), (ExprMacroTable)ExprMacroTable.nil());
        Assert.assertEquals((Object)TrueDimFilter.instance(), (Object)dataSource.getLeftFilter());
    }
}

