/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.HistogramAggregatorFactory;
import org.apache.druid.query.aggregation.JavaScriptAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SuppressedAggregatorFactory;
import org.apache.druid.query.aggregation.any.DoubleAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.FloatAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.LongAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.mean.DoubleMeanAggregatorFactory;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class AggregatorFactoryTest
extends InitializedNullHandlingTest {
    @Test
    public void testMergeAggregators() {
        Assert.assertNull((Object)AggregatorFactory.mergeAggregators(null));
        Assert.assertNull((Object)AggregatorFactory.mergeAggregators((List)ImmutableList.of()));
        ArrayList<Object[]> aggregatorsToBeMerged = new ArrayList<Object[]>();
        aggregatorsToBeMerged.add(null);
        Assert.assertNull((Object)AggregatorFactory.mergeAggregators(aggregatorsToBeMerged));
        Object[] emptyAggFactory = new AggregatorFactory[]{};
        aggregatorsToBeMerged.clear();
        aggregatorsToBeMerged.add(emptyAggFactory);
        Assert.assertArrayEquals((Object[])emptyAggFactory, (Object[])AggregatorFactory.mergeAggregators(aggregatorsToBeMerged));
        aggregatorsToBeMerged.clear();
        aggregatorsToBeMerged.add(emptyAggFactory);
        aggregatorsToBeMerged.add(null);
        Assert.assertNull((Object)AggregatorFactory.mergeAggregators(aggregatorsToBeMerged));
        aggregatorsToBeMerged.clear();
        AggregatorFactory[] af1 = new AggregatorFactory[]{new LongMaxAggregatorFactory("name", "fieldName1")};
        AggregatorFactory[] af2 = new AggregatorFactory[]{new LongMaxAggregatorFactory("name", "fieldName2")};
        Assert.assertArrayEquals((Object[])new AggregatorFactory[]{new LongMaxAggregatorFactory("name", "name")}, (Object[])AggregatorFactory.mergeAggregators((List)ImmutableList.of((Object)af1, (Object)af2)));
        aggregatorsToBeMerged.clear();
        af1 = new AggregatorFactory[]{new LongMaxAggregatorFactory("name", "fieldName1")};
        af2 = new AggregatorFactory[]{new DoubleMaxAggregatorFactory("name", "fieldName2")};
        Assert.assertNull((Object)AggregatorFactory.mergeAggregators((List)ImmutableList.of((Object)af1, (Object)af2)));
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new JavaScriptAggregatorFactory("js", (List)ImmutableList.of((Object)"col"), "function(a,b) { return a + b; }", "function() { return 0; }", "function(a,b) { return a + b }", new JavaScriptConfig(true)), new LongSumAggregatorFactory("longSum", "long-col"), new LongMinAggregatorFactory("longMin", "long-col"), new LongMaxAggregatorFactory("longMax", "long-col"), new LongFirstAggregatorFactory("longFirst", "long-col"), new LongLastAggregatorFactory("longLast", "long-col"), new LongAnyAggregatorFactory("longAny", "long-col"), new DoubleSumAggregatorFactory("doubleSum", "double-col"), new DoubleMinAggregatorFactory("doubleMin", "double-col"), new DoubleMaxAggregatorFactory("doubleMax", "double-col"), new DoubleFirstAggregatorFactory("doubleFirst", "double-col"), new DoubleLastAggregatorFactory("doubleLast", "double-col"), new DoubleAnyAggregatorFactory("doubleAny", "double-col"), new DoubleMeanAggregatorFactory("doubleMean", "double-col"), new FloatSumAggregatorFactory("floatSum", "float-col"), new FloatMinAggregatorFactory("floatMin", "float-col"), new FloatMaxAggregatorFactory("floatMax", "float-col"), new FloatFirstAggregatorFactory("floatFirst", "float-col"), new FloatLastAggregatorFactory("floatLast", "float-col"), new FloatAnyAggregatorFactory("floatAny", "float-col"), new StringFirstAggregatorFactory("stringFirst", "col", Integer.valueOf(1024)), new StringLastAggregatorFactory("stringLast", "col", Integer.valueOf(1024)), new StringAnyAggregatorFactory("stringAny", "col", Integer.valueOf(1024)), new CardinalityAggregatorFactory("cardinality", (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"some-col")), false), new HyperUniquesAggregatorFactory("hyperUnique", "hyperunique"), new HistogramAggregatorFactory("histogram", "histogram", (List)ImmutableList.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.75f))), new FilteredAggregatorFactory((AggregatorFactory)new HyperUniquesAggregatorFactory("filtered", "hyperunique"), (DimFilter)new SelectorDimFilter("col", "hello", null)), new SuppressedAggregatorFactory((AggregatorFactory)new HyperUniquesAggregatorFactory("suppressed", "hyperunique"))}).postAggregators(new PostAggregator[]{new FinalizingFieldAccessPostAggregator("count-finalize", "count"), new FinalizingFieldAccessPostAggregator("js-finalize", "js"), new FinalizingFieldAccessPostAggregator("longSum-finalize", "longSum"), new FinalizingFieldAccessPostAggregator("longMin-finalize", "longMin"), new FinalizingFieldAccessPostAggregator("longMax-finalize", "longMax"), new FinalizingFieldAccessPostAggregator("longFirst-finalize", "longFirst"), new FinalizingFieldAccessPostAggregator("longLast-finalize", "longLast"), new FinalizingFieldAccessPostAggregator("longAny-finalize", "longAny"), new FinalizingFieldAccessPostAggregator("doubleSum-finalize", "doubleSum"), new FinalizingFieldAccessPostAggregator("doubleMin-finalize", "doubleMin"), new FinalizingFieldAccessPostAggregator("doubleMax-finalize", "doubleMax"), new FinalizingFieldAccessPostAggregator("doubleFirst-finalize", "doubleFirst"), new FinalizingFieldAccessPostAggregator("doubleLast-finalize", "doubleLast"), new FinalizingFieldAccessPostAggregator("doubleAny-finalize", "doubleAny"), new FinalizingFieldAccessPostAggregator("doubleMean-finalize", "doubleMean"), new FinalizingFieldAccessPostAggregator("floatSum-finalize", "floatSum"), new FinalizingFieldAccessPostAggregator("floatMin-finalize", "floatMin"), new FinalizingFieldAccessPostAggregator("floatMax-finalize", "floatMax"), new FinalizingFieldAccessPostAggregator("floatFirst-finalize", "floatFirst"), new FinalizingFieldAccessPostAggregator("floatLast-finalize", "floatLast"), new FinalizingFieldAccessPostAggregator("floatAny-finalize", "floatAny"), new FinalizingFieldAccessPostAggregator("stringFirst-finalize", "stringFirst"), new FinalizingFieldAccessPostAggregator("stringLast-finalize", "stringLast"), new FinalizingFieldAccessPostAggregator("stringAny-finalize", "stringAny"), new FinalizingFieldAccessPostAggregator("cardinality-finalize", "cardinality"), new FinalizingFieldAccessPostAggregator("hyperUnique-finalize", "hyperUnique"), new FinalizingFieldAccessPostAggregator("histogram-finalize", "histogram"), new FinalizingFieldAccessPostAggregator("filtered-finalize", "filtered"), new FinalizingFieldAccessPostAggregator("suppressed-finalize", "suppressed")}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("js", ValueType.FLOAT).add("longSum", ValueType.LONG).add("longMin", ValueType.LONG).add("longMax", ValueType.LONG).add("longFirst", ValueType.LONG).add("longLast", ValueType.LONG).add("longAny", ValueType.LONG).add("doubleSum", ValueType.DOUBLE).add("doubleMin", ValueType.DOUBLE).add("doubleMax", ValueType.DOUBLE).add("doubleFirst", ValueType.DOUBLE).add("doubleLast", ValueType.DOUBLE).add("doubleAny", ValueType.DOUBLE).add("doubleMean", null).add("floatSum", ValueType.FLOAT).add("floatMin", ValueType.FLOAT).add("floatMax", ValueType.FLOAT).add("floatFirst", ValueType.FLOAT).add("floatLast", ValueType.FLOAT).add("floatAny", ValueType.FLOAT).add("stringFirst", null).add("stringLast", null).add("stringAny", ValueType.STRING).add("cardinality", null).add("hyperUnique", null).add("histogram", ValueType.COMPLEX).add("filtered", null).add("suppressed", null).add("count-finalize", ValueType.LONG).add("js-finalize", ValueType.FLOAT).add("longSum-finalize", ValueType.LONG).add("longMin-finalize", ValueType.LONG).add("longMax-finalize", ValueType.LONG).add("longFirst-finalize", ValueType.LONG).add("longLast-finalize", ValueType.LONG).add("longAny-finalize", ValueType.LONG).add("doubleSum-finalize", ValueType.DOUBLE).add("doubleMin-finalize", ValueType.DOUBLE).add("doubleMax-finalize", ValueType.DOUBLE).add("doubleFirst-finalize", ValueType.DOUBLE).add("doubleLast-finalize", ValueType.DOUBLE).add("doubleAny-finalize", ValueType.DOUBLE).add("doubleMean-finalize", ValueType.DOUBLE).add("floatSum-finalize", ValueType.FLOAT).add("floatMin-finalize", ValueType.FLOAT).add("floatMax-finalize", ValueType.FLOAT).add("floatFirst-finalize", ValueType.FLOAT).add("floatLast-finalize", ValueType.FLOAT).add("floatAny-finalize", ValueType.FLOAT).add("stringFirst-finalize", ValueType.STRING).add("stringLast-finalize", ValueType.STRING).add("stringAny-finalize", ValueType.STRING).add("cardinality-finalize", ValueType.DOUBLE).add("hyperUnique-finalize", ValueType.DOUBLE).add("histogram-finalize", ValueType.COMPLEX).add("filtered-finalize", ValueType.DOUBLE).add("suppressed-finalize", ValueType.DOUBLE).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

