/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ExpressionLambdaAggregatorFactoryTest
extends InitializedNullHandlingTest {
    private static ObjectMapper MAPPER = TestHelper.makeJsonMapper();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), "customAccumulator", "0.0", "10.0", Boolean.valueOf(true), "customAccumulator + some_column + some_other_column", "customAccumulator + expr_agg_name", "if (o1 > o2, if (o1 == o2, 0, 1), -1)", "o + 100", new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)agg, (Object)MAPPER.readValue(MAPPER.writeValueAsBytes((Object)agg), ExpressionLambdaAggregatorFactory.class));
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(ExpressionLambdaAggregatorFactory.class).usingGetClass().withIgnoredFields(new String[]{"macroTable", "initialValue", "initialCombineValue", "foldExpression", "combineExpression", "compareExpression", "finalizeExpression", "compareBindings", "combineBindings", "finalizeBindings", "finalizeInspector"}).verify();
    }

    @Test
    public void testInitialValueMustBeConstant() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("initial value must be constant");
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "x + y", null, Boolean.valueOf(true), "__acc + some_column + some_other_column", "__acc + expr_agg_name", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        agg.getType();
    }

    @Test
    public void testInitialCombineValueMustBeConstant() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("initial combining value must be constant");
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0.0", "x + y", Boolean.valueOf(true), "__acc + some_column + some_other_column", "__acc + expr_agg_name", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        agg.getFinalizedType();
    }

    @Test
    public void testSingleInputCombineExpressionIsOptional() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"x"), null, "0", null, Boolean.valueOf(true), "__acc + x", null, null, null, null, TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)1L, (Object)agg.combine((Object)0L, (Object)1L));
    }

    @Test
    public void testFinalizeCanDo() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"x"), null, "0", null, Boolean.valueOf(true), "__acc + x", null, null, "o + 100", null, TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)100L, (Object)agg.finalizeComputation((Object)0L));
    }

    @Test
    public void testFinalizeCanDoArrays() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"x"), null, "0", null, Boolean.valueOf(true), "array_set_add(__acc, x)", "array_set_add_all(__acc, expr_agg_name)", null, "array_to_string(o, ',')", null, TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)"a,b,c", (Object)agg.finalizeComputation((Object)new String[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"a,b,c", (Object)agg.finalizeComputation((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
    }

    @Test
    public void testStringType() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "''", "''", Boolean.valueOf(true), "concat(__acc, some_column, some_other_column)", "concat(__acc, expr_agg_name)", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)ValueType.STRING, (Object)agg.getType());
        Assert.assertEquals((Object)ValueType.STRING, (Object)agg.getCombiningFactory().getType());
        Assert.assertEquals((Object)ValueType.STRING, (Object)agg.getFinalizedType());
    }

    @Test
    public void testLongType() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0", null, null, "__acc + some_column + some_other_column", "__acc + expr_agg_name", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)ValueType.LONG, (Object)agg.getType());
        Assert.assertEquals((Object)ValueType.LONG, (Object)agg.getCombiningFactory().getType());
        Assert.assertEquals((Object)ValueType.LONG, (Object)agg.getFinalizedType());
    }

    @Test
    public void testDoubleType() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0.0", null, null, "__acc + some_column + some_other_column", "__acc + expr_agg_name", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)agg.getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)agg.getCombiningFactory().getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)agg.getFinalizedType());
    }

    @Test
    public void testStringArrayType() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "''", "<STRING>[]", null, "concat(__acc, some_column, some_other_column)", "array_set_add(__acc, expr_agg_name)", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)ValueType.STRING, (Object)agg.getType());
        Assert.assertEquals((Object)ValueType.STRING_ARRAY, (Object)agg.getCombiningFactory().getType());
        Assert.assertEquals((Object)ValueType.STRING_ARRAY, (Object)agg.getFinalizedType());
    }

    @Test
    public void testStringArrayTypeFinalized() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "''", "<STRING>[]", null, "concat(__acc, some_column, some_other_column)", "array_set_add(__acc, expr_agg_name)", null, "array_to_string(o, ';')", new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)ValueType.STRING, (Object)agg.getType());
        Assert.assertEquals((Object)ValueType.STRING_ARRAY, (Object)agg.getCombiningFactory().getType());
        Assert.assertEquals((Object)ValueType.STRING, (Object)agg.getFinalizedType());
    }

    @Test
    public void testLongArrayType() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0", "<LONG>[]", null, "__acc + some_column + some_other_column", "array_set_add(__acc, expr_agg_name)", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)ValueType.LONG, (Object)agg.getType());
        Assert.assertEquals((Object)ValueType.LONG_ARRAY, (Object)agg.getCombiningFactory().getType());
        Assert.assertEquals((Object)ValueType.LONG_ARRAY, (Object)agg.getFinalizedType());
    }

    @Test
    public void testLongArrayTypeFinalized() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0", "<LONG>[]", null, "__acc + some_column + some_other_column", "array_set_add(__acc, expr_agg_name)", null, "array_to_string(o, ';')", new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)ValueType.LONG, (Object)agg.getType());
        Assert.assertEquals((Object)ValueType.LONG_ARRAY, (Object)agg.getCombiningFactory().getType());
        Assert.assertEquals((Object)ValueType.STRING, (Object)agg.getFinalizedType());
    }

    @Test
    public void testDoubleArrayType() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0.0", "<DOUBLE>[]", null, "__acc + some_column + some_other_column", "array_set_add(__acc, expr_agg_name)", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)agg.getType());
        Assert.assertEquals((Object)ValueType.DOUBLE_ARRAY, (Object)agg.getCombiningFactory().getType());
        Assert.assertEquals((Object)ValueType.DOUBLE_ARRAY, (Object)agg.getFinalizedType());
    }

    @Test
    public void testDoubleArrayTypeFinalized() {
        ExpressionLambdaAggregatorFactory agg = new ExpressionLambdaAggregatorFactory("expr_agg_name", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0.0", "<DOUBLE>[]", null, "__acc + some_column + some_other_column", "array_set_add(__acc, expr_agg_name)", null, "array_to_string(o, ';')", new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE);
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)agg.getType());
        Assert.assertEquals((Object)ValueType.DOUBLE_ARRAY, (Object)agg.getCombiningFactory().getType());
        Assert.assertEquals((Object)ValueType.STRING, (Object)agg.getFinalizedType());
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("string_expr", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "''", "''", null, "concat(__acc, some_column, some_other_column)", "concat(__acc, string_expr)", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("double_expr", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0.0", null, null, "__acc + some_column + some_other_column", "__acc + double_expr", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("long_expr", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0", null, null, "__acc + some_column + some_other_column", "__acc + long_expr", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("string_array_expr", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "<STRING>[]", "<STRING>[]", null, "array_set_add(__acc, concat(some_column, some_other_column))", "array_set_add_all(__acc, string_array_expr)", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("double_array_expr", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column_expr"), null, "0.0", "<DOUBLE>[]", null, "__acc + some_column + some_other_column", "array_set_add(__acc, double_array)", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("long_array_expr", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0", "<LONG>[]", null, "__acc + some_column + some_other_column", "array_set_add(__acc, long_array_expr)", null, null, new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("string_array_expr_finalized", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "''", "<STRING>[]", null, "concat(__acc, some_column, some_other_column)", "array_set_add(__acc, string_array_expr)", null, "array_to_string(o, ';')", new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("double_array_expr_finalized", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column_expr"), null, "0.0", "<DOUBLE>[]", null, "__acc + some_column + some_other_column", "array_set_add(__acc, double_array)", null, "array_to_string(o, ';')", new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("long_array_expr_finalized", (Set)ImmutableSet.of((Object)"some_column", (Object)"some_other_column"), null, "0", "<LONG>[]", null, "__acc + some_column + some_other_column", "array_set_add(__acc, long_array_expr)", null, "fold((x, acc) -> x + acc, o, 0)", new HumanReadableBytes(2048L), TestExprMacroTable.INSTANCE)}).postAggregators(new PostAggregator[]{new FieldAccessPostAggregator("string-array-expr-access", "string_array_expr_finalized"), new FinalizingFieldAccessPostAggregator("string-array-expr-finalize", "string_array_expr_finalized"), new FieldAccessPostAggregator("double-array-expr-access", "double_array_expr_finalized"), new FinalizingFieldAccessPostAggregator("double-array-expr-finalize", "double_array_expr_finalized"), new FieldAccessPostAggregator("long-array-expr-access", "long_array_expr_finalized"), new FinalizingFieldAccessPostAggregator("long-array-expr-finalize", "long_array_expr_finalized")}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("string_expr", ValueType.STRING).add("double_expr", ValueType.DOUBLE).add("long_expr", ValueType.LONG).add("string_array_expr", ValueType.STRING_ARRAY).add("double_array_expr", null).add("long_array_expr", null).add("string_array_expr_finalized", ValueType.STRING).add("double_array_expr_finalized", null).add("long_array_expr_finalized", ValueType.LONG).add("string-array-expr-access", ValueType.STRING).add("string-array-expr-finalize", ValueType.STRING).add("double-array-expr-access", ValueType.DOUBLE).add("double-array-expr-finalize", ValueType.STRING).add("long-array-expr-access", ValueType.LONG).add("long-array-expr-finalize", ValueType.LONG).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }
}

